/*
 *	grastructs.h
 *
 *	Gra2 main structures
 *
 *	(C)	1994 Daniel MARMIER
 */

#ifndef _GRA_STRUCTS_H_
#define _GRA_STRUCTS_H_

#include <c++/portable.h>

struct Dim
{
	Card16 dy;
	Card16 dx;
};

struct Pos
{
	Int16 y;
	Int16 x;
};

struct Box
{
	Pos o;
	Dim d;
};

struct Seg
{
	Pos p;			// startpoint
	Pos q;			// endpoint
};


struct Image
{
	Card8 type;
	Card8 coding;
	Card8 depth;
	Card8 dir;
	Card16 dx;
	Card16 dy;
	Card32 length;

	Card16 pixsiz;
	Card16 pixcnt;
	Card32 clutlen;
	Card8 res[12];
};

#define LG_IMAGE (sizeof (Image))

struct Gencar
{
	Card32	pad1;
	Card16	mat_l;
	Card16	mat_h;
	Card8	mat_w;
	Card8	pad2;
	Card8	first;
	Card8	last;
	Card16	left_ref;
	Card16	baseline;
	Card16	ascent;
	Card16	descent;
	Card16	max_w;
	Card16	interl;
	Card8	chasse;
	Card8	pad3;
	Card32	date;
	Card16	widths;
	Card16	heights_up;
	Card16	heights_down;
	Card16	matrices;
};

#endif /* _GRA_STRUCTS_H_ */

