/*
 *	monsel.cxx
 *
 *	Repris de DEF_SMS...
 */

#include <c++/ntrel.h>
#include <c++/fos.h>

#include "monselmenu.h"
#include "monselmisc.h"
#include "monselhwdis.h"

#define	MONSEL_INFO		"#:(INFO:,)(MSEL_%N,SMA_MONSEL).INFO"

/****************************************************************/

unsigned long _stksize	 = 10*1024;		// pile
unsigned long _SMASOVER	 = 1;			// utilise entre OVERLAY de prfrence
unsigned char _SMAPRIO	 = 11;
unsigned char _SMAREV	 = 1;			// rvision
unsigned char _SMAVER	 = 3;			// version
unsigned long _SMAUNIT	 = 0x00000027;	// normal

unsigned short _SMADIS[] = {640, 2000, 340, 2000};
char           _SMAIDE[] = "(C) 1996-1999, Pierre ARNAUD et EPSITEC SA";

/****************************************************************/

static const Card32 res_rv = (1 << 16) | 0;

ResFile	 res_file ("(,#):DEF_MONSEL(_%L,).RS", RSOPCACHE, res_rv);
ResType  rtyp_dbox (res_file, RtypDbox);
ResType  rtyp_image (res_file, RtypImageCod);
ColorMan color_man;
dbox     my_dbox;

/****************************************************************/

static short my_convtable[] = {
    F1, F2, F3,			/* ====> */	F1, 0,
    F4, F5, F6,			/* ====> */	F4, 0,
    F7, F8, F9,			/* ====> */ F7, 0,
    F0, F13, F14, F15,	/* ====> */ F0, 0,
    0
};

static dboxgroup my_group = { 0, { 0 } };

/****************************************************************/

/*
 *	Draw the icons for the edition line. This is based on a
 *	MONSEL description record.
 */

Card16 icon_x_pos[6] = { 0, 0, 0, 0, 0 };

static void
draw_edit_line_icons (const MonSelNamedRec& record)
{
	const char load_small_char[] = { 0xA1, 'N', 'R'+0x80, 5 };
	const char use_small_char[] = { 0xA0, 'N', 'R'+0x80, 5 };
	
	L_string (load_small_char, 4);
	L_string (use_small_char, 4);
	
	Point p1, p2;
	Pos p;
	
	dboxgetco (&my_dbox, 21, &p1, &p2);
	p.x = p1.x + (p2.x - p1.x) / 2 - 10; p.y = p1.y - 12; icon_x_pos[0] = p.x;
	color_man.DrawIcon (rIconMonitor1 + record.monitor, p);
	
	dboxgetco (&my_dbox, 22, &p1, &p2);
	p.x = p1.x + (p2.x - p1.x) / 2 - 15; p.y = p1.y - 12; icon_x_pos[1] = p.x;
	color_man.DrawIcon (rIconDepth1 + find_depth (record.depth), p);
	
	dboxgetco (&my_dbox, 23, &p1, &p2);
	p1.x += (p2.x - p1.x - 6*(4+1+4)) / 2; icon_x_pos[2] = p1.x;
	p1.y -= 2;
	
	L_setcurs (p1);
	L_string ("         ", 9);
	
	dboxgetco (&my_dbox, 23, &p1, &p2);
	
	char buffer[16];
	sprintf (buffer, "%dx%d", record.width, record.height);
	
	p1.x += (p2.x - p1.x - 6*strlen (buffer)) / 2;
	p1.y -= 2;
	
	L_setcurs (p1);
	L_string (buffer, strlen (buffer));
	L_rstgc ();
	
	dboxgetco (&my_dbox, 24, &p1, &p2);
	p.x = p1.x + (p2.x - p1.x) / 2 - 15; p.y = p1.y - 12; icon_x_pos[3] = p.x;
	color_man.DrawIcon (record.flags & 0x01 ? rIconTopNo : rIconTopYes, p);
	
	dboxgetco (&my_dbox, 25, &p1, &p2);
	p.x = p1.x + (p2.x - p1.x) / 2 - 15; p.y = p1.y - 12; icon_x_pos[4] = p.x;
	color_man.DrawIcon (record.flags & 0x02 ? rIconKeyNo : rIconKeyYes, p);
	
	dboxgetco (&my_dbox, 26, &p1, &p2);
	p.x = p1.x + (p2.x - p1.x) / 2 - 7; p.y = p1.y - 12; icon_x_pos[5] = p.x;
	color_man.DrawIcon (record.def ? rIconMarkYes : rIconMarkNo, p);
	
	dboxgetco (&my_dbox, 20, &p1, &p2);
	L_setcurs (p1);
	L_string (record.name, strlen (record.name));
}

/****************************************************************/

static void
add_record (const MonSelNamedRec& record, MonSelNamedRec*& info, int& num)
{
	int i = 0;
	
	if (record.def) {
		for (i = 0; i < num; i++) {
			info[i].def = 0;
		}
	}
	
	i = 0;
	
	while (i < num) {
		if (strcmp (info[i].name, record.name) == 0) {
			info[i] = record;
			return;
		}
		i++;
	}
	
	MonSelNamedRec* n_info = new MonSelNamedRec[num+1];
	i = 0;
	
	while (i < num) {
		n_info[i] = info[i];
		i++;
	}
	
	n_info[num] = record;
	num++;
	
	if (info) delete info;
	info = n_info;
}

static void
rem_record (const MonSelNamedRec& record, MonSelNamedRec*& info, int& num)
{
	int i = 0;
	
	while (i < num) {
		if (strcmp (info[i].name, record.name) == 0) {
			int j = i; num--;
			while (j < num) {
				info[j] = info[j+1];
				j++;
			}
			return;
		}
		i++;
	}
}

static int
find_record (const MonSelNamedRec& record, MonSelNamedRec*& info, int& num)
{
	int i = 0;
	
	while (i < num) {
		if (strcmp (info[i].name, record.name) == 0) {
			return i;
		}
		i++;
	}
	
	return -1;
}

static void
up_record (const MonSelNamedRec& record, MonSelNamedRec*& info, int& num)
{
	int where = find_record (record, info, num);
	if (where == -1) {
		add_record (record, info, num);
		where = num-1;
	}
	
	if (where == 0) return;
	MonSelNamedRec temp = info[where-1];
	info[where-1] = info[where];
	info[where] = temp;
}

static void
down_record (const MonSelNamedRec& record, MonSelNamedRec*& info, int& num)
{
	int where = find_record (record, info, num);
	if (where == -1) {
		add_record (record, info, num);
		where = num-1;
	}
	
	if (where >= num-1) return;
	MonSelNamedRec temp = info[where+1];
	info[where+1] = info[where];
	info[where] = temp;
}

void
load_info_file (MonSelNamedRec*& info, int& num)
{
	SmakyArgs args;
	Card16 channel;
	
	if (FOS::ArgsOpen (MONSEL_INFO, FOS_OPEN_READ | FOS_OPEN_SYS, args, channel)) {
		return;
	}
	
	int elem_n = args.length / sizeof (MonSelNamedRec);
	int elem_x = args.length % sizeof (MonSelNamedRec);
	
	if (elem_x == 0) {
		info = new MonSelNamedRec [elem_n];
		Card32 size = elem_n * sizeof (MonSelNamedRec);
		FOS::Read (channel, size, info);
		num = elem_n;
	}
	
	FOS::Close (channel);
}

void
save_info_file (MonSelNamedRec*& info, int& num)
{
	Card16 channel;
	
	if (FOS::Open (MONSEL_INFO, FOS_OPEN_WRITE | FOS_OPEN_CREATE, channel)) {
		return;
	}
	
	Card32 size = num * sizeof (MonSelNamedRec);
	
	FOS::Write (channel, size, info);
	FOS::Trunc (channel);
	FOS::Close (channel);
}


/****************************************************************/

int
main (int argc, char** argv)
{
	int  err;
	Bool stop = FALSE;
	Card8 buttons;
	Point point;
	int   sel_info = 0;
	
	err = read_hwdis_status (hwdis_status);
	
	if (err) {
		return 0;
	}
	
	err = init_res_stuff ();
	if (err) return err;
	
	MonSelNamedRec record = { 0, 0, 0, 640, 480, 4, 0, 0, 0, "" };
	
	MonSelNamedRec* info = 0;
	int info_num = 0;
	
	load_info_file (info, info_num);
	
	//	Initialize hldbox
	
	if (err = dboxinit ((u_char *)(dbox_res->GetData ()), &my_dbox, &my_group, my_convtable)) {
		return err;
	}
	
	//	Open dbox
	
	dboxopen (&my_dbox);
	
	draw_dbox_adornment ();
	draw_scroll_list ();
	draw_softkeys ();
	
	draw_edit_line_icons (record);
	update_scroll_list (info_num, info, -1);
	
	dboxputline (&my_dbox, 0, record.name);
	dboxchline (&my_dbox, 0);
	
	//	Main loop
	
	do {
		short touche;
		
		dboxedit (&my_dbox, &touche);
		dboxgetlinecpy (&my_dbox, 0, record.name);
		
		switch ((Card16)(touche)) {
			
			case F1:	// termine
				dboxgetlinecpy (&my_dbox, 0, record.name);
				add_record (record, info, info_num);
				save_info_file (info, info_num);
				stop = TRUE;
				break;
			
			case F0:		// annule
				stop = TRUE;
				break;
			
			case KEYMGP:
				L_ifmouse (&point, &buttons);
				
				if (track_scroll_list (point.x, point.y, info, sel_info)) {
					if (sel_info != -1) {
						record = info[sel_info];
						dboxputline (&my_dbox, 0, record.name);
						draw_edit_line_icons (record);
					} else {
						record.name[0] = 0;
						dboxputline (&my_dbox, 0, record.name);
						draw_edit_line_icons (record);
					}
				} else {
					dboxbip (&my_dbox, touche);
				}
				break;
			
			case 0x000D:
				dboxgetlinecpy (&my_dbox, 0, record.name);
				add_record (record, info, info_num);
				update_scroll_list (info_num, info, find_record (record, info, info_num));
				break;
			
			case CLEAR:
				dboxgetlinecpy (&my_dbox, 0, record.name);
				rem_record (record, info, info_num);
				update_scroll_list (info_num, info);
				record.name[0] = 0;
				dboxputline (&my_dbox, 0, record.name);
				draw_edit_line_icons (record);
				break;
			
			case 0x082C:
				up_record (record, info, info_num);
				update_scroll_list (info_num, info, find_record (record, info, info_num));
				break;
			
			case 0x082E:
				down_record (record, info, info_num);
				update_scroll_list (info_num, info, find_record (record, info, info_num));
				break;
			
			case 0x0890:
				if (info) {
					delete info;
					info     = 0;
					info_num = 0;
				}
				
				load_info_file (info, info_num);
				update_scroll_list (info_num, info, find_record (record, info, info_num));
				break;
			
			case 0xFF21:	//	moniteur
				show_menu_mon (record.monitor);
				draw_edit_line_icons (record);
				break;
			
			case 0xFF22:	//	profondeur
				show_menu_depth (record.depth);
				draw_edit_line_icons (record);
				break;
			
			case 0xFF23:	//	taille
				show_menu_geom (record.width, record.height);
				draw_edit_line_icons (record);
				break;
			
			case 0xFF24:	//	bannire
				record.flags ^= 0x01;
				draw_edit_line_icons (record);
				break;
			
			case 0xFF25:	//	touches
				record.flags ^= 0x02;
				draw_edit_line_icons (record);
				break;
			
			case 0xFF26:	//	marque "actif"
				record.def = !record.def;
				draw_edit_line_icons (record);
				break;
			
			case 0:
				break;
			
			default :
				dboxbip (&my_dbox, touche);
		}

	} while (!stop);
	
	dboxclose (&my_dbox);
	
	return 0;
}


