
#include <c++/fos.h>
#include "monselhwdis.h"

HWDisStatus hwdis_status = {
	{ { 0, 0, 0, 0 },
	  { 0, 0, 0, 0 },
	  { 0, 0, 0, 0 },
	  { 0, 0, 0, 0 } }
};

static int
fos_rstatus (Card16 ch, void* ptr, Card32 len)
{
	Card16 err = 0;
	
	asm volatile ( "movew %1,d6\n\t"
				   "movel %2,a4\n\t"
				   "movel %3,d4\n\t"
				   ".long 0x4E45001E\n\t"
				   "movew d7,%0"
				 : "=g" (err)
				 : "g" (ch), "g" (ptr), "g" (len)
				 : "d4", "d6", "d7", "a4" );
	
	return err;
}


int
read_hwdis_status (HWDisStatus& status)
{
	int    err     = 0;
	Card16 channel = 0;
	
	err = FOS::Open ("#HWDIS", FOS_OPEN_RSTATUS, channel);
	
	if (err) return err;
	
	err = fos_rstatus (channel, & status, sizeof (status));
	
	FOS::Close (channel);
	return err;
}

const char*
get_hwdis_name (HWDisStatus& status, int index)
{
	if ((index < 0) || (index > 3)) return 0;
	if (status.dm[index].channel == 0) return 0;
	if (status.dm[index].header == 0) return 0;
	
	const char* header = (const char*)(status.dm[index].header);
	return header + 0x20;
}

