
#include <c++/portable.h>
#include "monselmenu.h"
#include "monselhwdis.h"

extern "C" int L_mmenu (const char* textes, Card16* choix, Card32 bitmap);


/****************************************************************/

static const char* menu_depth_text[] = {
	" 1 bpp: noir & blanc",
	" 2 bpp: gris",
	" 4 bpp: 16 couleurs",
	" 8 bpp: 256 couleurs",
	"15 bpp: 32768 couleurs",
	"16 bpp: 65536 couleurs",
	"24 bpp: vraies couleurs",
	"32 bpp: vraies couleurs"
};

static const Card16 menu_depth_value[] = { 1, 2, 4, 8, 15, 16, 24, 32 };

static const char* menu_geom_text[] = {
	" 640 x  400",
	" 640 x  480",
	" 800 x  600",
	" 832 x  624",
	" 960 x  720",
	"1024 x  768",
	"1120 x  832",
	"1152 x  872",
	"1280 x 1024",
	"1504 x 1128",
	"1600 x 1200",
	"1600 x 1280",
	" 736 x  960",
	" 768 x 1024",
	" 864 x 1024",
	"1024 x 1280",
	" 736 x  736",
	" 960 x  960"
};

static const Card16 menu_geom_dx[] =
{ 640, 640, 800, 832, 960, 1024, 1120, 1152, 1280, 1504, 1600, 1600, 736,  768,  864, 1024, 736, 960 };

static const Card16 menu_geom_dy[] =
{ 400, 480, 600, 624, 720,  768,  832,  872, 1024, 1128, 1200, 1280, 960, 1024, 1024, 1280, 736, 960 };

/****************************************************************/

static Card16
show_menu (const char** model, int max)
{
	char* menu  = new char[2000];
	char* fill  = menu;
	
	Card16 sel  = 0;
	Card32 map  = 0;
	
	strcpy (fill, " ");
	fill += strlen (fill) + 1;
	*fill++ = 0xFF;
	
	while (max--) {
		*fill++ = ' ';
		strcpy (fill, *model++);
		fill += strlen (fill);
		*fill++ = ' ';
		*fill++ = 0;
	}
	
	*fill = 0;
	
	if (L_mmenu (menu, &sel, map)) {
		sel = 0;
	}
	
	delete menu;
	return sel;
}

Bool
show_menu_depth (Card16& depth)
{
	int          max   = sizeof (menu_depth_text) / sizeof (const char*);
	const char** model = menu_depth_text;
	Card16       sel   = show_menu (model, max);
	
	if (sel-- == 0) return FALSE;
	
	depth = menu_depth_value[sel];
	return TRUE;
}

Bool
show_menu_geom (Card16& dx, Card16& dy)
{
	int          max   = sizeof (menu_geom_text) / sizeof (const char*);
	const char** model = menu_geom_text;
	Card16       sel   = show_menu (model, max);
	
	if (sel-- == 0) return FALSE;
	
	dx = menu_geom_dx[sel];
	dy = menu_geom_dy[sel];
	return TRUE;
}

Bool
show_menu_mon (Card16& mon)
{
	int max = 0;
	const char* menu[4] = { 0, 0, 0, 0};
	
	while (max < 4) {
		
		menu[max] = get_hwdis_name (hwdis_status, max);
		
		if (menu[max]) {
			max++;
			continue;
		}
		break;
	}
	
	Card16 sel = show_menu (menu, max);
	if (sel-- == 0) return FALSE;
	
	mon = sel;
	
	return TRUE;
}

/****************************************************************/

int
find_depth (Card16 depth)
{
	int max = sizeof (menu_depth_text) / sizeof (const char*);
	int sel = 0;
	
	while (sel < max) {
		if (menu_depth_value[sel] == depth) {
			return sel;
		}
		sel++;
	}
	
	return -1;
}

int
find_geom (Card16 dx, Card16 dy)
{
	int max = sizeof (menu_geom_text) / sizeof (const char*);
	int sel = 0;
	
	while (sel < max) {
		if ( (menu_geom_dx[sel] == dx)
		  && (menu_geom_dy[sel] == dy) ) {
			return sel;
		}
		sel++;
	}
	
	return -1;
}

/****************************************************************/

