
#include "monselmisc.h"

Res* dbox_res = 0;
void* pdis = 0;

/****************************************************************/

int
load_libs ()
{
    int err;
    
    if (err = dbox_opelib ()) return err;
    atexit ((void (*)(void))(dbox_clolib));
    
    return 0;
}

/****************************************************************/

void
draw_softkeys ()
{
	static const char menu[] = {
		"\0"
		"\0"
		"\0"
		"D'accord\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"\0"
		"Annule\0"
	};
	
	L_afmenu ((void *)(menu));
}

/****************************************************************/

void
draw_dbox_adornment ()
{
	Point p1, p2, wdim, dummy;
	int nowdo;
	int i;
	
	L_getwdo (&dummy, &wdim, &nowdo);
	
	//	Draw rivets
	
	Dim rivetdim;
	color_man.GetIconSize (rIconRivet, rivetdim);
	
	const Int16 rivetborder = 6;
	const Pos rivetpos[] = {
		{ rivetborder, rivetborder},
		{ rivetborder, wdim.x - rivetborder - rivetdim.dx },
		{ wdim.y - rivetborder - rivetdim.dy, rivetborder },
		{ wdim.y - rivetborder - rivetdim.dy, wdim.x - rivetborder  - rivetdim.dx }
	};
	
	for (i = 0; i < 4; i++) {
		color_man.DrawIcon (rIconRivet, rivetpos[i]);
	}
	
	//	Draw lines
	
	dboxgetco (&my_dbox, 2, &p1, &p2);
	p1.x = 0;
	p1.y -= 20;
	
	Box b = { { p1.y, p1.x }, { 0, wdim.x } };
	color_man.DrawLine (b);
}

/****************************************************************/

int
init_res_stuff ()
{
	int  err;
	
	//	Load libraries
	
	if (err = res_file.GetError ()) return err;
	if (err = load_libs ()) return err;
	
	dbox_res = new Res (rtyp_dbox, rMainDbox);
	if (err = dbox_res->GetError ()) return err;
	
	//	Find monochrome image
	
	Res mres (rtyp_image, rMonoImage);
	if (err = mres.GetError ()) return err;
	const void *mdata = mres.GetData ();
	
	//	Find color image
	
	Res cres (rtyp_image, rColorImage);
	if (err = cres.GetError ()) return err;
	const void *cdata = cres.GetData ();
	
	//	Init color management class
	
	color_man.Init (mdata, cdata, ICONS_NUMBER, icons_def);
	color_man.Update ();
	
	L_getpdis (&pdis);
	
	return 0;
}

