
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <c++/portable.h>

#include "monsel.h"
#include "colorman.h"
#include "iconsdef.h"
#include "lib/res.h"

typedef struct { short y,x; } Point;

struct MonSelNamedRec
{
	Card16		monitor;
	Card8		flags;
	Card8		def;
	Card16		width;
	Card16		height;
	Card16		depth;
	Card16		res_2, res_3, res_4;
	char		name[32];
};

extern "C"
{
#include "hldbox.h"

extern int L_drseg (Point origine, Point dim, u_short mode);
extern int L_afmenu (const void* liste);
extern int L_getwdo (Point* UpperLeft, Point* Dim, int* nowdo);
extern int L_string (const char* string, unsigned long length);
extern int L_rstgc ();
extern int L_setcurs (Point p);
extern int L_getpdis (void* dis_desc);
extern int L_ifmouse (Point* pos, u_char* boutons);

extern int dbox_opelib (void);
extern int dbox_clolib (void);
}

#define F0		0x80
#define F1		0x81
#define F2		0x82
#define F3		0x83
#define F4		0x84
#define F5		0x85
#define F6		0x86
#define F7		0x87
#define F8		0x88
#define F9		0x89
#define F10		0x8A
#define F11		0x8B
#define F12		0x8C
#define F13		0x8D
#define F14		0x8E
#define F15		0x8F

#define	UNDO	0x90
#define	HELP	0x91
#define	END		0x92
#define	MACRO	0x93
#define	FNCT	0x94
#define	DEFINE	0x95
#define POINT	0x97
#define	ENTER	0x98
#define	DELETE	0x9E
#define	CLEAR	0x9F
#define RETURN	0x0d

#define	KEYMGP	0x7F01

extern ResFile  res_file;
extern ResType  rtyp_dbox;
extern ResType  rtyp_image;
extern ColorMan color_man;
extern dbox     my_dbox;
extern Res*     dbox_res;
extern void*	pdis;
extern Card16	icon_x_pos[6];

extern int load_libs ();
extern void draw_softkeys ();
extern void draw_dbox_adornment ();

extern int init_res_stuff ();

extern void draw_scroll_list ();
extern void update_scroll_list (int num, const MonSelNamedRec* array, int select = -1);
extern int get_scroll_select ();
extern Bool track_scroll_list (Card16 x, Card16 y, const MonSelNamedRec* array, int& sel);

