
#include "monselmisc.h"
#include "monselmenu.h"

#include "lib/scroll.h"

typedef u_char Trame88[8];

extern "C" int L_flush ();
extern "C" int L_getcurs (Point*);
extern "C" int L_drmdef (Trame88 trame);
extern "C" int L_drtrame (Point origine, Point dim, u_short mode);
extern "C" int L_drrect (Point origine, Point dim, u_short mode);

#define	SCROLL_LIST_DY	18

static ListStruct my_list = { { 0 } };

void
draw_scroll_list ()
{
	Point p1, p2, p3;
	
	dboxgetco (&my_dbox, 0, &p1, &p2);
	dboxgetco (&my_dbox, 1, &p2, &p3);
	
	my_list.slvid = TRUE;
	my_list.slpos.x = p1.x;
	my_list.slpos.y = p1.y - 16;
	my_list.sldim.x = p2.x - my_list.slpos.x;
	my_list.sldim.y = p2.y - my_list.slpos.y;
	
	scroll_ldim (& my_list, pdis);
	
	my_list.slcar.y = SCROLL_LIST_DY;
	my_list.slc1y   = SCROLL_LIST_DY - my_list.slc2y - 1;
	my_list.slc2y   = SCROLL_LIST_DY - my_list.slc1y;
	my_list.slnby   = (my_list.sldim.y / my_list.slcar.y) - 1;
	my_list.sldim.y = my_list.slcar.y * (my_list.slnby + 1) + 2;
	my_list.slsptr  = & my_list;
	
	scroll_ldraw (& my_list, pdis, "< Nouvelle dfinition >");
	
	p1.x = my_list.slpos.x + my_list.sldim.x + 5 + 8;
	p1.y = my_list.slpos.y + my_list.slcar.y + 1;
	p2.x = my_list.sldim.x - 6 - 8;
	p2.y = my_list.sldim.y - my_list.slcar.y - 1;
	
	L_drrect (p1, p2, 0);
}

static const MonSelNamedRec* rec = 0;

static Card16 mem_y_coord[20] = { 0 };
static void draw_complement (Card16 cell, Card16 y);

static short
update_func (void* calleevar, Card16 cell, Card16 numchars, Card16 firstchar)
{
	Point point;
	
	Point trame_org;
	Point trame_dim;
	
	Trame88 trame;
	for (int i = 0; i < 8; i++) trame[i] = 0x00;
	
	L_flush ();
	L_getcurs (&point);
	
	trame_org.x = point.x - 1;
	trame_org.y = point.y - my_list.slc1y;
	trame_dim.x = my_list.sldim.x - 16;
	trame_dim.y = my_list.slcar.y;
	
	L_drmdef (trame);
	L_drtrame (trame_org, trame_dim, 0);
	
	L_string (" ", 1);
	L_string (rec[cell].name, strlen (rec[cell].name));
	L_flush ();
	
	Card16 index = cell - my_list.slcya;
	mem_y_coord[index] = point.y;
	
	draw_complement (cell, point.y);
	return 0;
}

static void
redraw_complement ()
{
	Card16 start = my_list.slcya;
	Card16 index = 0;
	
	while (index < 20) {
		if (mem_y_coord[index]) {
			draw_complement (start, mem_y_coord[index]);
		}
		start++;
		index++;
	}
}


static void
draw_complement (Card16 cell, Card16 y)
{
	if (cell >= my_list.slcyn) {
		
		Point trame_org, trame_dim;
		Trame88 trame;
		for (int i = 0; i < 8; i++) trame[i] = 0x00;
		
		const char pop_color[]  = { 0xBE, 0x02 };
		const char back_color[] = { 0xBE, 0x01, 0xBB, 0x00, 0x00, 0x14, 0x01 };
		L_string (back_color, 7);
		L_flush ();
		
		trame_org.x = icon_x_pos[0];
		trame_org.y = y - my_list.slc1y;
		trame_dim.x = my_list.sldim.x - 27;
		trame_dim.y = my_list.slcar.y;
		
		L_drmdef (trame);
		L_drtrame (trame_org, trame_dim, 0);
		L_string (pop_color, 2);
		
		return;
	}
	
	Point p1;
	Pos   p;
	
	const char use_small_char[] = { 0xA0, 'N', 'R'+0x80, 5 };
	L_string (use_small_char, 4);
	
	p.x = icon_x_pos[0]; p.y = y - 12;
	color_man.DrawIcon (rIconMonitor1 + rec[cell].monitor, p);
	
	p.x = icon_x_pos[1];
	color_man.DrawIcon (rIconDepth1 + find_depth (rec[cell].depth), p);
	
	p1.x = icon_x_pos[2];
	p1.y = y - 2;
	
	L_setcurs (p1);
	
	//	Use DBOX background color since we draw outside of the current
	//	scroll list.
	
	const char pop_color[]  = { 0xBE, 0x02 };
	const char back_color[] = { 0xBE, 0x01, 0xBB, 0x00, 0x00, 0x14, 0x01,
							    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ' };
	L_string (back_color, 7+9);
	
	char buffer[16];
	sprintf (buffer, "%dx%d", rec[cell].width, rec[cell].height);
	
	p1.x += 6*(9 - strlen (buffer)) / 2;
	
	L_setcurs (p1);
	L_string (buffer, strlen (buffer));
	L_string (pop_color, 2);

	L_rstgc ();
	
	p.x = icon_x_pos[3];
	color_man.DrawIcon (rec[cell].flags & 0x01 ? rIconTopNo : rIconTopYes, p);
	
	p.x = icon_x_pos[4];
	color_man.DrawIcon (rec[cell].flags & 0x02 ? rIconKeyNo : rIconKeyYes, p);
	
	p.x = icon_x_pos[5];
	color_man.DrawIcon (rec[cell].def ? rIconMarkYes : rIconMarkNo, p);
}

void
update_scroll_list (int num, const MonSelNamedRec* array, int select)
{
	my_list.slcyn = num;
	rec = array;
	
	my_list.slcys = select;
	
	if ( (num == 0) && (my_list.slcys != -1) ) {
		my_list.slcys = -1;
	}
	
	scroll_lupdate (& my_list, pdis, 0, update_func, 0);
	redraw_complement ();
}

int
get_scroll_select ()
{
	return my_list.slcys;
}

Bool
track_scroll_list (Card16 x, Card16 y, const MonSelNamedRec* array, int& sel)
{
	Point wdim, wpos;
	int   nowdo;
	
	L_getwdo (&wpos, &wdim, &nowdo);
	x -= wpos.x;
	y -= wpos.y;
	
	rec = array;
	Point p = { y, x };
	
	if (scroll_lmove (& my_list, pdis, p, 0, update_func, 0)) {
		return FALSE;
	}
	
	sel = my_list.slcys;
	redraw_complement ();
	return TRUE;
}


