/*
 *	postman.cc
 *
 *	Programme de gestion de l'environnement PostScript, appel
 *	notamment pour installer correctement le systme.
 *
 *	(C)	Copyright 1996, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 SUSCEVAZ
 */

#include <stdio.h>
#include <string.h>
#include <c++/fos.h>

#include "postman.h"

Card32 _stksize  = 10*1024;
Card32 _SMASOVER = 1;					//	en overlay par dfaut
Card8  _SMAPRIO  = 11;					//	priorit usuelle
Card8  _SMAREV   = 0;					//	rvision
Card8  _SMAVER   = 3;					//	version
Card32 _SMAUNIT  = 0x000000A3;			//	non rentrant, fentre & clavier
Card16 _SMADIS[] = {20, 2000, 20, 2000};
char   _SMAIDE[] = "(C) Copyright 1996, Pierre ARNAUD, OPaC bright ideas";

int
main (int argc, char* argv[])
{
	argc--;
	argv++;
	
	while (argc) {
		
		if (strcmp (argv[0], "-psserv-update") == 0) {
			
			//	Cre un fichier SMA_PSSERV.INFO  jour en fonction du contenu
			//	du dossier "/usr/local/lib/ghostscript/smaky".
			
			const char* src = "#mm0:";
			const char* sys = "#:";
			
			if (argc > 1) { argc--; argv++; src = argv[0]; }
			if (argc > 1) { argc--; argv++; sys = argv[0]; }
			
			update_psserv_info (src, sys);
			
			//	Force PRINTA  relire le fichier depuis le disque.
			
			FOS::Deassign ("#PSSERVLOAD");
			FOS::Deassign ("#PSSERVRELOAD");
			FOS::Assign ("#PSSERVLOAD", "@DAOLVRESSP");
			FOS::Assign ("#PSSERVRELOAD", "@DAOLERVRESSP");
			
		} else if (strcmp (argv[0], "-console") == 0) {
			
			FOS::Execute ("sma_consol", FOS_EX_ONLYONE | FOS_EX_LEAVEKEY);
			
			FOS::Assign ("#PTLK_STDOUT", "@_CONSOLE_:PTLK.STDOUT");
			FOS::Assign ("#PTLK_EMIT", "@_CONSOLE_:PTLK.EMIT");
			FOS::Assign ("#GSLOG", "@_CONSOLE_:");
			FOS::Assign ("#PPS_STDOUT", "@_CONSOLE_:PPS.STDOUT");
			FOS::Assign ("#PPS_STDERR", "@_CONSOLE_:PPS.STDERR");
			
		} else if (strcmp (argv[0], "-help") == 0) {
			
			printf ("Options supportes :\n");
			printf ("\n");
			printf ("  -psserv-update [unit [sys]] Met  jour SMA_PSSERV.INFO\n");
			printf ("  -console                     Initialise la console\n");
			printf ("  -help                        Affiche ce texte\n");
			
		}
		
		argc--;
		argv++;
	}
	
	return 0;
}

