/*
 *	uppsserv.cc
 *
 *	Met  jour le fichier SMA_PSSERV.INFO du dossier systme, en se
 *	basant sur les fichiers de description de "devices" GhostScript
 *	prsents dans le dossier "/usr/local/lib/ghostscript/smaky"...
 *
 *	(C)	Copyright 1996, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 SUSCEVAZ
 */

#include <stdio.h>
#include <string.h>
#include <c++/fos.h>

#include "postman.h"


/*
 *	Clef pour le dcodage des valeurs intressantes dans les
 *	fichiers de dfinitions *.ps :
 */

#define	TOKEN_FILE	0				//	nom du fichier
#define	TOKEN_ID	1				//	identificateur unique
#define	TOKEN_TEXT	2				//	texte descriptif
#define	TOKEN_DEV	3				//	device  utiliser

#define	NUM_TOKEN	4

static const char* psdev_token[NUM_TOKEN+1] =
{
	"/$FILE\t",
	"/$ID\t",
	"/$TEXT\t",
	"/$DEV\t",
	0
};

typedef char* PostValues[NUM_TOKEN];


/*
 *	Analyse juste une ligne du fichier PostScript de dfinition
 *	du device de sortie et tente d'extraire une valeur  partir
 *	d'une dfinition du genre :
 *
 *		"/$FILE	(GS-FILE.PS) def"
 *	
 *	Ne fait rien de particulier si une erreur de syntaxe est
 *	rencontre.
 */

static void
parse_psdev_line (char* line, const char* token[], char* value[])
{
	if ( (line[0] == '/')
	  && (line[1] == '$') ) {
		while (*token) {
			int len = strlen (*token);
			
			if (strncmp (*token, line, len) == 0) {
				
				line += len;
				
				while ( (*line == ' ')
				     || (*line == '\t') ) {
					line++;
				}
				
				if (*line++ == '(') {
					*value = line;
					while ( (*line)
					     && (*line != ')') ) {
						line++;
					}
					if (*line) {
						
						*line = 0;
						
						line = *value;
						len  = strlen (line);
						
						*value = new char[len+1];
						strcpy (*value, line);
						
						return;
					}
				}
				
				//	Erreur de syntaxe... Tant pis, on ne prend pas en
				//	compte ce champ !
				
				*value = 0;
				return;
			}
			
			token++;
			value++;
		}
	}
}


/*
 *	Passe en revue toutes les lignes d'un fichier PostScript de
 *	dfinition du device de sortie.
 */

static void
parse_psdev_file (char* psdev, const char* token[], char* value[])
{
	Bool  stop = FALSE;
	char* line = psdev;
	char* end  = 0;
	
	int index = 0;
	
	for (index = 0; index < NUM_TOKEN; index++) {
		value[index] = 0;
	}
	
	while (!stop) {
		
		end = line;
		
		while ( (*end)
		     && (*end != '\n')
		     && (*end != '\r') ) {
			end++;
		}
		
		stop   = (end[0] == 0) ? TRUE : FALSE;
		end[0] = 0;
		
		parse_psdev_line (line, token, value);
		
		line   = end + 1;
	}
}


/*
 *	Trie les donnes en fonction du numro de la clef.
 */

static void
sort_psdev_values (PostValues* values, int num)
{
	PostValues temp;
	
#ifdef DEBUG
	printf ("Trie %d descriptions.\n", num);
#endif
	
	if (num < 2) {
		return;
	}
	
	num--;
	
	for (int index = 0; index < num; index++) {
		for (int other = index+1; other <= num; other++) {
			if (strcmp (values[index][TOKEN_ID], values[other][TOKEN_ID]) > 0) {
				temp          = values[index];
				values[index] = values[other];
				values[other] = temp;
#ifdef DEBUG
				printf ("Permut %s et %s\n", values[index][TOKEN_ID], values[other][TOKEN_ID]);
#endif
			}
		}
	}
}


/*
 *	Met  jour le fichier SMA_PSSERV.INFO en fonction des
 *	donnes courantes.
 */

void
update_psserv_info (const char* src, const char* sys)
{
	FosList list;
	
	PostValues*      values = 0;
	const SmakyArgs* args   = 0;
	const char*      name   = 0;
	char             dir[200];
	char             info[200];
	int              count  = 0;
	int              index  = 0;
	
	strcpy (dir, src);
	strcat (dir, "usr:local:lib:ghostscript:smaky:");
	strcpy (info, sys);
	strcat (info, "sma_psserv.info");
	
	list.Open (dir, "*.ps");
	count = list.NumFiles ();
	
#ifdef DEBUG
	printf ("NumFiles = %d\n", list.NumFiles ());
	printf ("DirName  = %s\n", list.DirName ());
#endif
	
	if (count == 0) {
		return;
	}
	
	values = new PostValues[count];
	
	for (index = 0; index < count; index++) {
		for (int val = 0; val < NUM_TOKEN; val++) {
			values[index][val] = 0;
		}
	}
	
	index = 0;
	
	//	Il y a des fichiers PostScript de configuration dans le dossier
	//	de GhostScript. Lit chaque fichier et extrait les donnes qui
	//	sont ncessaires  la reconstruction de SMA_PSSERV.INFO !
	
	while (list.NextFile (name, args)) {
		
		char   open[200];
		char*  buffer  = new char[args->length+1];
		Card16 channel = 0;
		
		strcpy (open, dir);
		strcat (open, name);
		
		if (FOS::Open (open, FOS_OPEN_READ, channel) == 0) {
			
			Card32 size = args->length;
			FOS::Read (channel, size, buffer);
			FOS::Close (channel);
			buffer[size] = 0;
			
			parse_psdev_file (buffer, psdev_token, values[index]);
			
			if ( (values[index][TOKEN_ID])
			  && (values[index][TOKEN_FILE])
			  && (values[index][TOKEN_TEXT]) ) {
				index++;
			} else {
				count--;
			}
		}
		
		delete buffer;
	}
	
	sort_psdev_values (values, count);
	
#ifdef DEBUG
	for (index = 0; index < count; index++) {
		for (int key = 0; key < NUM_TOKEN; key++) {
			if (values[index][key]) {
				printf ("%d: %s --> %s\n", index, psdev_token[key], values[index][key]);
			}
		}
	}
#endif
	
	//	Reconstruit le fichier SMA_PSSERV.INFO dans le dossier systme.
	
	if (count) {
		SmakyArgs args;
		Card16    source = 0;
		char      open[200];
		FILE*     file   = 0;
		
		Card32    source_mode = FOS_OPEN_READ | FOS_OPEN_ARGS;
		
		strcpy (open, dir);
		strcat (open, "sma_psman.info");
		
		if (FOS::ArgsOpen (open, source_mode, args, source) == 0) {
			file = fopen (info, "wt");
			if (file) {
				Card32 size   = args.length;
				char*  buffer = new char[size];
				FOS::Read (source, size, buffer);
				FOS::Close (source);
				fwrite (buffer, size, 1, file);
				delete buffer;
				
				for (index = count-1; index >= 0; index--) {
					fprintf (file, "FOR G+%s-*.PS PRINTER=GhostScript.Smaky@%s ;%s\n",
								   values[index][TOKEN_ID],
								   values[index][TOKEN_FILE],
								   values[index][TOKEN_TEXT]);
				}
				
				fclose (file);
			}
		}
	}
	
	for (index = 0; index < count; index++) {
		for (int key = 0; key < NUM_TOKEN; key++) {
			if (values[count][key]) {
				delete values[count][key];
				values[count][key] = 0;
			}
		}
	}
	
	delete values;
}


