/*
 *		document.cc
 *
 *		Emet des commandes diverses pour dbut un document
 *		ou pour marquer une sparation de page.
 *
 *		(C) 1993-1999,	Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

extern "C" {
#include <stdlib.h>
#include <stdio.h>
}

#include "page-struct.h"

#define CENTER_PAGE		0

static const int A4_dx = 10500;
static const int A4_dy = 14850;
static const int A3_dx = 14850;
static const int A3_dy = 21000;
static const int A4_demi_dy = A4_dy >> 1;

extern unsigned char _SMAREV;
extern unsigned char _SMAVER;

static void
insert_file_in_output (const char* file_name, Output* output, Bool& failure)
{
	void* include = 0;
	long mode_chan = 0x0002;									// 2**BOPRD
	long mode = 0;												// pas de mode XFOS spcial
	int error = _xfos_open (file_name, &mode_chan, &mode);		// ouvre le fichier
	
	if (error) {
		failure = TRUE;
	} else {
		include = (void*)(mode_chan);
		char buf[101];
		long size = 100;
		
		for (;;) {
			_xfos_rdbyte (include, &size, buf);					// lit depuis le fichier..
			buf[size] = 0;
			output->Write (buf);								// ..et recopie btement
			if (size != 100) break;
		}
		
		_xfos_close (include);
	}
}

void
PagePS::NewDocument (const char* doc, const char* author, const char* for_whom, const char* date,
					 const char* for_dest, const char* epsf, const char* rules)
{
	Bool dummy = FALSE;
	Bool is_A3 = FALSE;
	Bool is_log_A3 = FALSE;
	Bool ok_A3 = getenv ("PPS_A3_OK") ? TRUE : FALSE;
	
	if ((doc == 0) || (*doc == 0)) doc = "Smaky Document";
	if ((author == 0) || (*author == 0)) author = "Smaky -> PostScript driver";
	if ((for_whom == 0) || (*for_whom == 0)) for_whom = "?";
	if ((date == 0) || (*date == 0)) date = "?";
	if ((for_dest == 0) || (*for_dest == 0)) for_dest = "?";
	
	int level = output->Level ();
	
	char procset[50];
	char procset_name[50];
	
	sprintf (procset, "procset SmakyPagePS-%d %d %d", level, _SMAREV, _SMAVER);
	sprintf (procset_name, "#:sma_psdriv-%d.ps", level);
	
	output->Write ("%!PS-Adobe-3.0\n");
	output->Write ("%%Title: ");						output->Write (doc);
	output->Write ("\n%%Creator: ");					output->Write (author);
	output->Write ("\n%%CreationDate: ");				output->Write (date);
	output->Write ("\n%%For: ");						output->Write (for_dest);
	output->Write ("\n%%Routing: ");					output->Write (for_whom);
	output->Write ("\n%%Pages: ");						output->Write ("(atend)");
	output->Write ("\n%%PageOrder: ");					output->Write ("Ascend");
	output->Write ("\n%%LanguageLevel: ");				output->Write ((level == 1) ? "1" : "2");
	output->Write ("\n%%DocumentData: ");				output->Write ((level == 1) ? "Clean7Bit"
																					: "Binary");
	output->Write ("\n%%DocumentNeededResources: ");	output->Write (procset);
	output->Write ("\n%%DocumentSuppliedResources: ");	output->Write (procset);
	output->Write ("\n%%EndComments\n");
	
	output->Write ("\n%%BeginDefaults");
	output->Write ("\n%%EndDefaults\n");
	
	output->Write ("\n%%BeginProlog");
	output->Write ("\n%%BeginResource: ");				output->Write (procset);
	output->Write ("\n");
	
	insert_file_in_output (procset_name, this->output, this->failure);
	
	if (getenv ("PPS_ERROR")) {
		insert_file_in_output ("#:sma_pserror.ps", this->output, this->failure);
	}
	
	output->Write ("\n%%EndResource");
	output->Write ("\n%%EndProlog\n");
	
	output->Write ("\n%%BeginSetup");
	output->Write ("\n% Document produced by Smaky computer with SMA_PSDRIV.CODE");
	output->Write ("\n% Driver available from EPSITEC-system SA, CH-1092 BELMONT");
	output->Write ("\nsave\n");
	
	insert_file_in_output ("#:sma_pssetup.ps", this->output, dummy);
	
	output->Write ("\n%-BeginRules\n");
	
	if (rules[0]) {
		output->Write (rules);
	}
	
	output->Write ("\n%-EndRules\n\n");
	
	if (level == 2) {

#if 0
		insert_file_in_output ("#:sma_pstray.ps", this->output, dummy);
#endif
		output->Write (this->StrokeAdjust () ? "true" : "false");
		output->Write (" setstrokeadjust\n");
		output->Write ("1 setobjectformat\n");
	}
	
	{
		char buffer[100];
		
		sprintf (buffer, "%% Page geometry   : %d x %d [mm]\n",
				 page_dx * 20/1000,
				 page_dy * 20/1000);
		output->Write (buffer);
		
		sprintf (buffer, "%% Page resolution : %d x %d [dpi]\n",
				 dpi_x, dpi_y);
		output->Write (buffer);
	}
	
	int phys_x = A4_dx;							// largeur physique en units de 20 um
	int phys_y = A4_dy;							// hauteur physique en units de 20 um
	
	if (page_dx < page_dy) {
		if ( (page_dx > (A3_dx* 9/10))
		  && (page_dx < (A3_dx*11/10))
		  && (page_dy > (A3_dy* 9/10))
		  && (page_dy < (A3_dy*11/10)) ) {
			is_A3 = TRUE;
		}
	} else {
		if ( (page_dy > (A3_dx* 9/10))
		  && (page_dy < (A3_dx*11/10))
		  && (page_dx > (A3_dy* 9/10))
		  && (page_dx < (A3_dy*11/10)) ) {
			is_A3 = TRUE;
		}
	}
	
	is_log_A3 = is_A3;
	is_A3    &= ok_A3;
	
	if (is_A3) {
		phys_x = A3_dx;
		phys_y = A3_dy;
		
		output->Write ("\n");
		output->Write ("%%BeginFeature: *PageSize A3\n");
		output->Write ("<< /PageSize [842 1190] /ImagingBBox null >> setpagedevice\n");
		output->Write ("%%EndFeature\n\n");
	}
	
	{
		/********************************************************************
		 *																	*
		 *	Dtermine la taille du papier et l'orientation de l'impression	*
		 *																	*
		 ********************************************************************/
		
		
		Bool ok = FALSE;
		
		this->is_multi_ok = FALSE;
		this->eo_page_x = 0;
		this->eo_page_y = 0;
		
		if (this->is_no_multi == FALSE) {
			
			// Essaie de mettre plus de pages sur une feuille de papier
			// en la tournant, si ncessaire...
			
			if ((page_dx <= (A4_demi_dy+A4_demi_dy/100)) && (page_dy <= (A4_dx+A4_dx/100))) {
				
				output->Write ("595 0 translate 90 rotate % 2 x A5 portrait\n");
				this->is_multi_ok = TRUE;
				
				phys_x = A4_demi_dy;
				phys_y = A4_dx;
				
				eo_page_x = phys_x;				// A5 vertical sur page A4 tourne
				eo_page_y = 0;
				ok = TRUE;
			}
			
			if ((page_dx <= (A4_dx+A4_dx/100)) && (page_dy <= (A4_demi_dy+A4_demi_dy/100))) {
				
				output->Write ("0 420 translate % 2 x A5 landscape\n");
				is_multi_ok = TRUE;
				
				phys_x = A4_dx;
				phys_y = A4_demi_dy;
				
				eo_page_x = 0;					// A5 horizontal sur page A4 non tourne
				eo_page_y = phys_y;
				ok = TRUE;
			}
		}
		
		if (!ok) {
			
			double zoom_x = (double)(phys_x) / (double)(page_dx);
			double zoom_y = (double)(phys_y) / (double)(page_dy);
			
			if ( (page_dx > page_dy)
			  && (page_dx > phys_x) ) {
				
				// Tourne la page si plus large que haut et qu'il n'y a pas
				// la place sans tourner...
				
				if (is_log_A3) {
					if (zoom_x >= 0.95) {
						output->Write ("841 0 translate 90 rotate % A3 landscape\n");
					} else {
						output->Write ("1190 0 translate 90 rotate % A3 landscape (shrink)\n");
					}
				} else {
					output->Write ("595 0 translate 90 rotate % A4 landscape\n");
				}
				
				int swap_x = phys_x;
				
				phys_x = phys_y;
				phys_y = swap_x;
				
			} else {
				
				if (is_log_A3) {
					output->Write ("% A3 portrait\n");
				} else {
					output->Write ("% A4 portrait\n");
				}
			}
			
			zoom_x = (double)(phys_x) / (double)(page_dx);
			zoom_y = (double)(phys_y) / (double)(page_dy);
			
			if ( (zoom_x < 0.95) || (zoom_y < 0.95) ) {
				
				// La page n'a pas la place sur la feuille, il faut la rduire
				// de manire  ce qu'elle y tienne...
				
				double zoom = (zoom_x < zoom_y) ? zoom_x : zoom_y;
				
				output->Send (zoom);
				output->Send (zoom);
				output->Write ("scale\n");
				
				phys_x = (int)((double)(phys_x) / zoom);
				phys_y = (int)((double)(phys_x) / zoom);
			}
			
#if CENTER_PAGE
			double shift_x = ( (phys_x - page_dx) / 2 ) * 72.0 / (25.4 * 50.0);
			double shift_y = ( (phys_y - page_dy) / 2 ) * 72.0 / (25.4 * 50.0);
			
			output->Send (shift_x);
			output->Send (shift_y);
			output->Write ("translate\n");
#endif
			
			ok = TRUE;
		}
	}
	
	output->Send (phys_x);
	output->Send (phys_y);
	output->Send (1270.0 / dpi_x);
	output->Send (1270.0 / dpi_y);
	output->Write ("init\n");
	
	output->Write ("%%EndSetup\n\n");
	
	page_count = 1;
	real_page_count = 1;
	page_setup = 0;
	page_start = 0;
	start_new_page = TRUE;
}


void
PagePS::NewPage (int num)
{
	char buffer[128];
	
	if (def_num) num = def_num;
	
	SendGlyphs ();
	
	if ((page_count & 1) && (is_multi_ok)) {
		
		// C'est une page impaire et nous avons besoin d'une autre
		// page pour pouvoir l'imprimer...
		
		output->Write ("restore grestore gsave save\n");
		output->Color (0.0, 0.0, 0.0);

		output->Send (eo_page_x);
		output->Send (eo_page_y);
		output->Write ("translate\n");
		
		page_count++;
		
	} else {
		
		sprintf (buffer, "/#copies %d def showpage\n", num);
		output->Write (buffer);
		
		output->Write ("%%PageTrailer\n");
		output->Write ("restore grestore\n");
		
		page_count++;
		real_page_count++;
		start_new_page = TRUE;
	}
}


/*
 *	Appel chaque fois qu'une page logique/physique peut ventuellement
 *	commencer. Il se peut que l'appel soit appel plus d'une fois par
 *	page, auquel cas il faut filtrer : gardons le premier et poubellisons
 *	les suivants. C'est PreparePage qui va appeler StartPage dans la
 *	grande majorit des cas.
 */

void
PagePS::StartPage ()
{
	if (page_start == page_count) return;
	
	page_start = page_count;
	
	if (start_new_page) {
		
		// Commence rellement une nouvelle page : gnre les commentaires adquats.
		
		start_new_page = FALSE;
		char buffer[128];
		sprintf (buffer, "%%%%Page: %d %d\n", page_count, real_page_count);
		output->Write (buffer);
		output->Write ("%%BeginPageSetup\n"
					   "gsave save\n"
					   "%%EndPageSetup\n\n");
		
		output->ResetColor ();
	}
	
	this->SetupPage ();
}


void
PagePS::SetupPage ()
{
	if (page_setup == page_count) return;
	
	page_setup = page_count;
	
	char buffer[500];
	
	if (screen_mul > 1) {
		
		if (screen_mul < 1) screen_mul = 1;
		if (screen_mul > 8) screen_mul = 8;
		
		sprintf (buffer, "80 %d div %f\n", screen_mul, screen_angle);
		output->Write (buffer);
		output->Write ("{ abs exch abs 2 copy add 1\n"
					   "  gt { 1 sub dup mul exch 1 sub dup mul add 1 sub }\n"
					   "     { dup mul exch dup mul add 1 exch sub } ifelse\n"
					   "} bind setscreen\n");
	}
	
	output->Send (scale_page_x);
	output->Send (scale_page_y);
	output->Write ("scale\n");
}

