
/*
 *	drawbezier.cc
 *
 *	Dessin de courbes de Bzier conformes aux dsirs de PAGE.
 *
 *	(C) 1993,  Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

extern "C" {
#include <stdlib.h>
}

#include "page-struct.h"


// Dessine une courbe de Bzier. Si le trait  utiliser est compatible
// avec les pinceaux PostScript, on utilise un `curveto'. Dans le cas
// contraire, on se fait ch'e soi-mme !

void
PagePS::DrawBezier (int xp1, int yp1, int xc1, int yc1, int xp2, int yp2, int xc2, int yc2,
		    int pen, Bool reset = FALSE)
{
    SendGlyphs ();
    
    float rset,gset,bset;
    
    rset = this->color[this->pen[pen].color].red / 65535.0;
    gset = this->color[this->pen[pen].color].green / 65535.0;
    bset = this->color[this->pen[pen].color].blue / 65535.0;
    
    output->Color (rset, gset, bset);
    
    Bool ps_dash;
    
    ps_dash = this->SelectDash (pen, FALSE);
    
    if (ps_dash) {
        if (this->pen[pen].flags & PEN_CIRCLE) {
            output->Send (this->pen[pen].width);
            output->Send (xc1); output->Send (yc1);
            output->Send (xc2); output->Send (yc2);
            output->Send (xp2); output->Send (yp2);
            output->Send (xp1); output->Send (yp1);
            output->Send (PS_ROUND_BEZIER);
            return;
        }
        
        if (this->pen[pen].flags & PEN_ELLIPSE) {
            output->Send (this->pen[pen].width);
            output->Send (this->pen[pen].height);
            output->Send (xc1); output->Send (yc1);
            output->Send (xc2); output->Send (yc2);
            output->Send (xp2); output->Send (yp2);
            output->Send (xp1); output->Send (yp1);
            output->Send (PS_ELLIP_BEZIER);
            return;
        }
        
        if ( (this->pen[pen].flags & PEN_SQUARE) && (this->page_mode == FALSE) ) {
            output->Send (this->pen[pen].width);
            output->Send (xc1); output->Send (yc1);
            output->Send (xc2); output->Send (yc2);
            output->Send (xp2); output->Send (yp2);
            output->Send (xp1); output->Send (yp1);
            output->Send (PS_SQUARE_BEZIER);
            return;
        }
        
        if ( (this->pen[pen].flags & PEN_RECT) && (this->page_mode == FALSE) ) {
            output->Send (this->pen[pen].width);
            output->Send (this->pen[pen].height);
            output->Send (xc1); output->Send (yc1);
            output->Send (xc2); output->Send (yc2);
            output->Send (xp2); output->Send (yp2);
            output->Send (xp1); output->Send (yp1);
            output->Send (PS_RECT_BEZIER);
            return;
        }
    }
    
    // Hmmm, c'est em..ant que GRA2 n'utilise pas les mmes conventions
    // que PostScript : il va falloir muler la courbe avec des DrawLine
    //  nous. Tant pis, on utilise les nombre flottants...
    
    int ax, bx, cx, ay, by, cy;
    long x, y, xx, yy;
    float t, dt;
    
    cx = 3*(xc1-xp1);
    cy = 3*(yc1-yp1);
    bx = 3*(xc2-xc1)-cx;
    by = 3*(yc2-yc1)-cy;
    ax = xp2-xp1-cx-bx;
    ay = yp2-yp1-cy-by;
    
    t = 0.0;
    dt = 0.05;
    
    x = xp1;
    y = yp1;
    
    while (t < 1.04) {
        xx = (long)(ax*t*t*t+bx*t*t+cx*t)+xp1;
        yy = (long)(ay*t*t*t+by*t*t+cy*t)+yp1;
        
        DrawLine (x, y, xx, yy, pen, reset);
        
        reset = FALSE;
        x = xx;
        y = yy;
        t += dt;
    }
}
