/*
 *	drawmonoima.cc
 *
 *	Dessine une image en couleur.
 *
 *	(C) Copyright 1993-1999,  Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

#include "page-struct.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern Bool debug;

extern void Say (const char*);
extern void Say (long);

// Dessine une image monochrome

void
PagePS::DrawMonoImage (int x1, int y1, int x2, int y2, int pdx, int pdy, float angle,
				       int w, int c, const void* image)
{
    SendGlyphs ();
    
    if ((pdx == 0) && (pdy == 0) && (w == 0) && (c == 0)) {
        
        // C'est en fait un fichier EPSF que l'on dsire imprimer.
        
        const char* epsf_name = (const char*)(image);
        FILE* file = fopen (epsf_name, "rb");
        
        if (file == 0) {
            output->Write ("% EPSF-file not available.\n");
            return;
        }
        
        char head[4];
        fread (head, 1, 4, file);
        int llx = 0, lly = 0, urx = 0, ury = 0;
        
        if ( (head[0] == '%')
          && (head[1] == '!')
          && (head[2] == 'P')
          && (head[3] == 'S') ) {
            
            // C'est bien un fichier PostScript de type reconnu.
            
            Bool ok = FALSE;
            int c;
            
            while ((c = fgetc (file)) != EOF) {
                if (c == '%') {
                    c = fgetc (file); if (c == EOF) break;
                    if (c == '%') {
                        
                        // Trouv le dbut d'un document structuring comment. On cherche
                        // dsesprment le "%%BoundingBox: llx lly urx ury"
                        
                        const char* comp = "BoundingBox:";
                        
                        for (; *comp; ) {
                            
                            c = fgetc (file); if (c == EOF) break;
                            if (c != *comp++) break;
                            
                            if (*comp == 0) {
                                
                                // Le mot clef "%%BoundingBox:" a t identifi. Recherche
                                // maintenant les 4 paramtres.
                                
                                char buffer[40];
                                char* ptr = buffer;
                                
                                while (((c = fgetc (file)) != EOF) && (c != '\n') && (c != '\r'))
                                    *ptr++ = (c == '\t') ? ' ' : c;
                                
                                *ptr = ' '; ptr = buffer;
                                
                                while (*ptr == ' ') ptr++; llx = atoi (ptr); while (*ptr++ != ' ');
                                while (*ptr == ' ') ptr++; lly = atoi (ptr); while (*ptr++ != ' ');
                                while (*ptr == ' ') ptr++; urx = atoi (ptr); while (*ptr++ != ' ');
                                while (*ptr == ' ') ptr++; ury = atoi (ptr);
                                
                                ok = TRUE;
                            }
                        }
                    }
                }
                
                if (ok) break;
            }
            
            if (c == EOF) {
                output->Write ("% Empty EPSF file...\n");
            } else {
                
                double dx = (double)(urx - llx);
                double dy = (double)(ury - lly);
                
                output->Write ("BeginEPSF\n");
                
                output->Send (0);
                output->Send (y2-y1);
                output->Send (angle);
                output->Send (x1);
                output->Send (y1);
                output->Write ("translate rotate translate\n");
                
                output->Send ((x2 - x1) / dx);
                output->Send ((y2 - y1) / dy);
                output->Write ("scale\n");
                
                output->Send (-llx);
                output->Send (lly);
                output->Write ("translate 1 -1 scale\n");
                
                output->Send (dx);
                output->Send (dy);
                output->Send (llx);
                output->Send (lly);
                output->Write ("cr\n");
                
                output->Write ("%%BeginDocument: ");
                output->Write (epsf_name); output->Write ("\n");
                
                int old_c = 0;
                int is_newline = 1;
                
                for (;;) {
                    char buf[10];
                    
                    int c = fgetc (file);
                    if (c == EOF) break;
                    
                    if ((c == '\n') || (c == '\r')) {
                        
                        output->Write ("\n");
                        is_newline = 1;
                        old_c = 0;
                        
                    } else {
                        
                        if ((c == '%') && (is_newline)) {
                            
                            old_c = '%';
                            is_newline = 0;
                            
                        } else if ((c == '%') && (old_c == '%')) {
                            
                            is_newline = 0;
                            
                            c = fgetc (file); buf[0] = c;
                            c = fgetc (file); buf[1] = c;
                            c = fgetc (file); buf[2] = c;
                            
                            if ((buf[0] == 'E') && (buf[1] == 'O') && (buf[2] == 'F'))
                                break;
                            
                            output->Write ("%%");
                            output->Write (buf, 3);
                            old_c = 0;
                            
                        } else if (old_c == '%') {
                            
                            // Trouv un commentaire non DSC, saute !
                            
                            for (;;) {
                                c = fgetc (file);
                                if ( (c == EOF)
                                  || (c == '\n')
                                  || (c == '\r') ) break;
                            }
                            
                            old_c = 0;
                            is_newline = 1;
                            
                        } else {
                            
                            buf[0] = c;
                            output->Write (buf, 1);
                            
                            old_c = 0;
                            is_newline = 0;
                        }
                    }
                }
                
                output->Write ("\n%%EndDocument\nEndEPSF\n");
            }
            
        } else {
            
            output->Write ("% Please contact the author of this software !\n");
            output->Write ("% EPSF file format not recognized...\n");
        }
        
        fclose (file);
        return;
    }
    
    float rset = this->color[c].red / 65535.0;
    float gset = this->color[c].green / 65535.0;
    float bset = this->color[c].blue / 65535.0;
    
    output->Color (rset, gset, bset);
    
    int dx = x2 - x1;
    int dy = y2 - y1;
    
    Bool odd = (pdy & 1) ? TRUE : FALSE;
    
    if (odd) pdy++;
    
    output->Send (pdx);		// largeur
    output->Send (pdy);		// hauteur
    output->Send (dx);		// largeur en points de PAGE
    output->Send (dy);		// hauteur en points de PAGE
    output->Send (angle);	// angle de rotation
    output->Send (x1);		// origine x
    output->Send (y1);		// origine y
    
    if (pdx == 2420) {
    	
    	output->Write ("imTypo\n");
    	
    	int width = (pdx + 7) >> 3;
    	
    	if (odd) pdy--;
    	
    	while (pdy--) {
    		const int     step = width / 4 + 1;
    		unsigned long copy[step];
    		memcpy (copy, image, width);
    		for (int i = 0; i < step; i++) {
    			copy[i] ^= 0xffffffff;
    		}
    	    output->Send (copy, width, FALSE);
    	    image += w;
    	}
    	
    	if (odd) {
    	    char zero[width];
    	    memset (zero, 0xff, width);
    	    output->Send (zero, width, FALSE);
	    }
	    
    } else {
	    
	    output->Write ("im\n");	// commande
        
        int width = (pdx + 7) >> 3;
    	
    	if (odd) pdy--;
    	
    	while (pdy--) {
    	    output->Send (image, width, FALSE);
    	    image += w;
    	}
    	
    	if (odd) {
    	    char zero[width];
        bzero (zero, width);
    	    output->Send (zero, width, FALSE);
    	}
    }
    
    output->Write ("\n");
}


