
/*
 *	drawpoly.cc
 *
 *	Dessin de polygones. On peut utiliser les chemins pour
 *	dfinir le pourtout, mais pas l'oprateur `makepattern'
 *	pour le remplissage (Level 1 oblige).
 *
 *	(C) 1993-1994,  Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

extern "C" {
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
}

#include "page-struct.h"

static void ProjettePsurAB (double Ax, double Ay, double Bx, double By, double& Px, double& Py);



void
PagePS::PolyOpen ()
{
    SendGlyphs ();
    
    output->Send (PS_POLYNEW);
    polybox = BBox ();
}


void
PagePS::PolyLine (int x1, int y1, int x2, int y2)
{
    output->Send (x2); output->Send (y2);
    output->Send (x1); output->Send (y1);
    output->Send (PS_POLYLINE);
    
    polybox.Add (x1, y1);
    polybox.Add (x2, y2);
}


void
PagePS::PolyBezier (int xp1, int yp1, int xc1, int yc1, int xp2, int yp2, int xc2, int yc2)
{
    output->Send (xc1); output->Send (yc1);
    output->Send (xc2); output->Send (yc2);
    output->Send (xp2); output->Send (yp2);
    output->Send (xp1); output->Send (yp1);
    output->Send (PS_POLYBEZIER);
    
    polybox.Add (xp1, yp1);
    polybox.Add (xp2, yp2);
    polybox.Add (xc1, yc1);
    polybox.Add (xc2, yc2);
}


// Remplit le polygone...

/*
 *	Limitations connues :
 *
 *	- transparence pas traite dans le cas des trames grises
 *	- lenteur pour une imprimante level 1
 *	- trames avec "pois" plus denses que 66 % pas conforme aux
 *	  sorties effectues par PAGE (pas d'inversion vido)
 *	- trames avec carrs en quinconce pas ok si > 50 %
 */

void
PagePS::PolyClose (int trame, int x1, int y1, int x2, int y2)
{
    output->Send (PS_POLYFILL);
    
    if ( (trame & 0x40000000)
      && (x1 != 32767) && (x2 != -32768)
      && (y1 != 32767) && (y2 != -32768) ) {
        polybox.x1 = x1; polybox.y1 = y1;
        polybox.x2 = x2; polybox.y2 = y2;
    }
    
    trame = trame & 0xFF;
    
    output->Send (polybox.x1); output->Send (polybox.y1);
    output->Send (polybox.x2); output->Send (polybox.y2);
    
    output->Write ("bb ");
    
    if ( (polybox.x1 == polybox.x2)
      && (polybox.y1 == polybox.y2) ) {
    	output->Write ("ic\n");
    	return;
    }
    
    float rset,gset,bset;
    float rclr,gclr,bclr;
    float pcent;
    Bool  is_degra = FALSE;
    
    rset = this->color[this->trame[trame].color_set].red / 65535.0;
    gset = this->color[this->trame[trame].color_set].green / 65535.0;
    bset = this->color[this->trame[trame].color_set].blue / 65535.0;
    
    rclr = this->color[this->trame[trame].color_clr].red / 65535.0;
    gclr = this->color[this->trame[trame].color_clr].green / 65535.0;
    bclr = this->color[this->trame[trame].color_clr].blue / 65535.0;
    
    pcent = this->trame[trame].grey_percent / 100.0;
    
    if ( (this->trame[trame].flags & TRAME_DEGLIN)
      || (this->trame[trame].flags & TRAME_DEGCIR)
      || (this->trame[trame].flags & TRAME_DEGELL)
      || (this->trame[trame].flags & TRAME_DEGCON) ) {
        
        is_degra = TRUE;
    }
    
    if ((this->trame[trame].flags & TRAME_TRANSP) == 0) {
    	
    	if ( !( (rclr == gclr) && (rclr == bclr) ) ) {
    		output->UseColor ();
    	}
        
        output->Send (rclr);
        output->Send (gclr);
        output->Send (bclr);
        output->Write ("ff ");		// efface le fond avec la couleur clear si pas transparent
    }
    
    if ( (this->trame[trame].flags & TRAME_GREY)
      && (this->trame[trame].flags & TRAME_SMLSQR)
      && (is_degra == FALSE) ) {
        
        if (this->trame[trame].flags & TRAME_TRANSP) {
            
            output->Write ("% transparent...\n");
            
        } else {
            
            float r,g,b;
            
            r = rset * pcent + rclr * (1.0 - pcent);
            g = gset * pcent + gclr * (1.0 - pcent);
            b = bset * pcent + bclr * (1.0 - pcent);
            
	    if ( !( (r == g) && (r == b) ) ) {
		output->UseColor ();
	    }
	    
            output->Send (r);
            output->Send (g);
            output->Send (b);
            output->Write ("ff ");
        }
        
    } else if ( (this->trame[trame].flags & TRAME_HACH)
             && (is_degra == FALSE) ) {
        
        output->Send (this->trame[trame].angle);
        output->Send (this->trame[trame].dist);
        output->Send (this->trame[trame].width_1);
        
        if (this->trame[trame].flags & TRAME_2ND) {
            
            if (this->trame[trame].flags & TRAME_2NDHOR) output->Send (0);
            if (this->trame[trame].flags & TRAME_2NDOBL) output->Send (this->trame[trame].angle);
            if (this->trame[trame].flags & TRAME_2NDVER) output->Send (90);
            if (this->trame[trame].flags & TRAME_2NDITA) output->Send (180-this->trame[trame].angle);
            
	    if ( !( (rset == gset) && (rset == bset) ) ) {
		output->UseColor ();
	    }
	    
            output->Send (this->trame[trame].dist);
            output->Send (this->trame[trame].width_2);
            output->Send (rset);
            output->Send (gset);
            output->Send (bset);
            output->Write ("fl2 ");
        } else {
            output->Send (rset);
            output->Send (gset);
            output->Send (bset);
            output->Write ("fl1 ");
        }
        
    } else if ( (this->trame[trame].flags & TRAME_BIGSQR)
             && (is_degra == FALSE) ) {
        
	if ( !( (rset == gset) && (rset == bset) ) ) {
	    output->UseColor ();
	}
	
        output->Send (pcent);
        output->Send (this->trame[trame].dot_size);
        output->Send (rset);
        output->Send (gset);
        output->Send (bset);
        
        if (this->trame[trame].flags & TRAME_QUINC) {
            output->Write ("fqs ");
        } else {
            output->Write ("fs ");
        }
        
    } else if ( (this->trame[trame].flags & TRAME_BIGCIR)
             && (is_degra == FALSE) ) {
        
	if ( !( (rset == gset) && (rset == bset) ) ) {
	    output->UseColor ();
	}
	
        output->Send (pcent);
        output->Send (this->trame[trame].dot_size);
        output->Send (rset);
        output->Send (gset);
        output->Send (bset);
        
        if (this->trame[trame].flags & TRAME_QUINC) {
            output->Write ("fqc ");
        } else {
            output->Write ("fc ");
        }
        
    } else if (is_degra == TRUE) {
        
        float c_r,c_g,c_b;
        float pcent;
        
        // Remplit avec un dgrad. Hum, c'est un peu plus compliqu que les autres types
        // de remplissages !
        
        short a[2] = { polybox.x1, polybox.y1 };
        short b[2] = { polybox.x2, polybox.y1 };
        short c[2] = { polybox.x2, polybox.y2 };
        short d[2] = { polybox.x1, polybox.y2 };
        
        if (this->trame[trame].deg_angle < 90) {
            
            // ok, pas besoin de tourner quoi que ce soit
            
        } else if (this->trame[trame].deg_angle < 180) {
            
            // a -> d, b -> a, c -> b, d -> c
            
            short t[2];
            
            t = d;
            d = a;
            a = b;
            b = c;
            c = t;
            
        } else if (this->trame[trame].deg_angle < 270) {
            
            // a -> c, b -> d, c -> a, d -> b
            
            short t[2];
            
            t = a; a = c; c = t;
            t = b; b = d; d = t;
            
        } else {
            
            // a -> b, b -> c, c -> d, d -> a
            
            short t[2];
            
            t = a;
            a = d;
            d = c;
            c = b;
            b = t;
        }
        
        double Ax = (double)(a[0]); double Ay = (double)(a[1]);
        double Bx = (double)(b[0]); double By = (double)(b[1]);
//      double Cx = (double)(c[0]); double Cy = (double)(c[1]);
        double Dx = (double)(d[0]); double Dy = (double)(d[1]);
        double angle = (double)(this->trame[trame].deg_angle) * M_PI / 180.0;
        double Hx = Ax + 100.0 * cos (angle);
        double Hy = Ay + 100.0 * sin (angle);
        double Px = (double)(c[0]);
        double Py = (double)(c[1]);
        
        ProjettePsurAB (Ax, Ay, Hx, Hy, Px, Py);
        
        double Qx = Ax; double Qy = Ay; ProjettePsurAB (Bx, By, Bx+Hx-Ax, By+Hy-Ay, Qx, Qy);
        double Rx = Px; double Ry = Py; ProjettePsurAB (Bx, By, Bx+Hx-Ax, By+Hy-Ay, Rx, Ry);
        double Sx = Px; double Sy = Py; ProjettePsurAB (Dx, Dy, Dx+Hx-Ax, Dy+Hy-Ay, Sx, Sy);
        double Tx = Ax; double Ty = Ay; ProjettePsurAB (Dx, Dy, Dx+Hx-Ax, Dy+Hy-Ay, Tx, Ty);
        
        double dx = hypot (Rx-Qx, Ry-Qy);
        double dy = hypot (Rx-Sx, Ry-Sy);
        
        if (this->trame[trame].flags & TRAME_TRANSP) {
            
            output->Write ("% transparent...\n");
            
        } else {
            
            output->Write ("save %\n");
            
            if (this->trame[trame].deg_style == DGTRAMEBIG) {
                
                // Change le grain de trame, temporairement, pour dessiner le dgrad. Ceci
                // n'est pas recommand par PostScript, mais ma foi c'est une ncessit dicte
                // par PAGE.
                
                char buffer[500];
                int  pt = this->trame[trame].deg_pt_size - 1;
                
                if (pt < 1) pt = 1;
                if (pt > 8) pt = 8;
                
                sprintf (buffer, "100 %d div %f\n", pt, screen_angle);
                output->Write (buffer);
                output->Write ("{ abs exch abs 2 copy add 1\n"
                               "  gt { 1 sub dup mul exch 1 sub dup mul add 1 sub }\n"
                               "     { dup mul exch dup mul add 1 exch sub } ifelse\n"
                               "} bind setscreen\n");
                
            } else if (this->trame[trame].deg_style == DGTRAMELITTLE) {
                
                // Utilise la trame par dfaut...
                
            } else if (this->trame[trame].deg_style == DGTRAMEHLINE) {
                
                char buffer[500];
                int  pt = this->trame[trame].deg_pt_size - 1;
                
                if (pt < 1) pt = 1;
                if (pt > 8) pt = 8;
                
                sprintf (buffer, "100 %d div 0\n", pt);
                output->Write (buffer);
                output->Write ("{ exch pop abs } bind setscreen\n");
                
            } else if (this->trame[trame].deg_style == DGTRAMEVLINE) {
                
                char buffer[500];
                int  pt = this->trame[trame].deg_pt_size - 1;
                
                if (pt < 1) pt = 1;
                if (pt > 8) pt = 8;
                
                sprintf (buffer, "100 %d div 0\n", pt);
                output->Write (buffer);
                output->Write ("{ pop abs } bind setscreen\n");
                
            } else if (this->trame[trame].deg_style == DGTRAMETRIAN) {
                
                char buffer[500];
                int  pt = this->trame[trame].deg_pt_size - 1;
                
                if (pt < 1) pt = 1;
                if (pt > 8) pt = 8;
                
                sprintf (buffer, "100 %d div 0\n", pt);
                output->Write (buffer);
                output->Write ("{ 1 sub abs exch 1 sub abs add 2 div 1 sub\n"
                               "} bind setscreen\n");
            }
            
            unsigned char shade[128];
            
            {
                // Calcule les chantillons de "gris" qui seront utiliss.
                
                int i;
                double d = (double)(this->trame[trame].deg_end - this->trame[trame].deg_start) / 100.0;
                double s = (double)(this->trame[trame].deg_start) / 100.0;
                
                if (this->trame[trame].flags & TRAME_BIDIR) {
                    for (i = 0; i < 64; i++) {
                        int x = (int)((d * i / 64.0 + s) * 256.0);
                        if (x < 0) x = 0; else if (x > 255) x = 255;
                        shade[i]     = 255-x;
                        shade[127-i] = 255-x;
                    }
                } else {
                    for (i = 0; i < 128; i++) {
                        int x = (int)((d * i / 128.0 + s) * 256.0);
                        if (x < 0) x = 0; else if (x > 255) x = 255;
                        shade[i] = 255-x;
                    }
                }
            }
            
            if ( (this->trame[trame].flags & TRAME_DEGELL)
              || (this->trame[trame].flags & TRAME_DEGCIR) ) {
                
                // Dgrad circulaire ou elliptique.
                
                output->Write ("gsave ");
                
                dx = (double)(polybox.x2-polybox.x1);
                dy = (double)(polybox.y2-polybox.y1);
                
                float pcx = this->trame[trame].deg_cx/100.0;
                float pcy = this->trame[trame].deg_cy/100.0;
                float rad = hypot (dx, dy);
                
                output->Send ((float)(polybox.x1)+(pcx*dx));
                output->Send ((float)(polybox.y1)+(pcy*dy));
                output->Write ("translate\n");
                
                if (pcx < 0.5) pcx = 1.0 - pcx;
                if (pcy < 0.5) pcy = 1.0 - pcy;
                
                if (this->trame[trame].flags & TRAME_DEGCIR) {
                    dx = (dx > dy) ? dx : dy;
                    dy = (dx > dy) ? dx : dy;
                    rad /= (dx > dy) ? dx : dy;
                } else {
                    rad = 1.414214;
                }
                
                output->Send (dx*pcx); output->Send (dy*pcy); output->Write ("scale\n");
                
                int i;
                
		if ( !( (rset == gset) && (rset == bset) ) ) {
		    output->UseColor ();
		}
		
                for (i = 127; i >= 0; i--) {
                    
                    pcent = 1.0 - ((float)(shade[i]) / 255.0);
                    
                    c_r = rset * pcent + rclr * (1.0 - pcent);
                    c_g = gset * pcent + gclr * (1.0 - pcent);
                    c_b = bset * pcent + bclr * (1.0 - pcent);
                    
                    output->Send ((float)(i) * rad / 127.0);
                    output->Send (c_r);
                    output->Send (c_g);
                    output->Send (c_b);
                    output->Write ("FiCir\n");
                }
                
                output->Write ("grestore\n");
                
                
            } if (this->trame[trame].flags & TRAME_DEGCON) {
                
                // Dgrad cnique.
                
                output->Write ("gsave ");
                
                dx = (double)(polybox.x2-polybox.x1);
                dy = (double)(polybox.y2-polybox.y1);
                
                float pcx = this->trame[trame].deg_cx/100.0;
                float pcy = this->trame[trame].deg_cy/100.0;
                float rad = hypot (dx, dy);
                
                output->Send ((float)(polybox.x1)+(pcx*dx));
                output->Send ((float)(polybox.y1)+(pcy*dy));
                output->Write ("translate\n");
                
                if (pcx < 0.5) pcx = 1.0 - pcx;
                if (pcy < 0.5) pcy = 1.0 - pcy;
                
                if (this->trame[trame].flags & TRAME_DEGCIR) {
                    dx = (dx > dy) ? dx : dy;
                    dy = (dx > dy) ? dx : dy;
                    rad /= (dx > dy) ? dx : dy;
                } else {
                    rad = 1.414214;
                }
                
                output->Send (dx*pcx); output->Send (dy*pcy); output->Write ("scale\n");
                output->Send (this->trame[trame].deg_angle);  output->Write ("rotate\n");
                
                int i;
                
		if ( !( (rset == gset) && (rset == bset) ) ) {
		    output->UseColor ();
		}
	
                for (i = 127; i >= 0; i--) {
                    
                    pcent = 1.0 - ((float)(shade[i]) / 255.0);
                    
                    c_r = rset * pcent + rclr * (1.0 - pcent);
                    c_g = gset * pcent + gclr * (1.0 - pcent);
                    c_b = bset * pcent + bclr * (1.0 - pcent);

                    output->Send (0); output->Send (0); output->Send (rad);
                    output->Send (180-(int)(i*180.0/127.0));
                    output->Send (180+(int)(i*180.0/127.0));
                    output->Send (c_r);
                    output->Send (c_g);
                    output->Send (c_b);
                    output->Write ("FiPie\n");
                }
                
                output->Write ("grestore\n");
                
                
            } else if (this->trame[trame].flags & TRAME_DEGLIN) {
                
                // Dgrad linaire.
                
                output->Write ("gsave ");
                
                if ( (output->Level () == 1)
                  && (is_color == FALSE) ) {
                    
                    // Pas de couleur du tout. Il faut par consquent utiliser l'image
                    // monochrome. Tant pis si cela ne correspond pas  ce que
                    // l'utilisateur voit rellement. Ce sera semblable  ce que
                    // PAGE imprime sur une imprimante standard.
                    
                    output->Send (Qx); output->Send (Qy);        output->Write ("translate\n");
                    output->Send (this->trame[trame].deg_angle); output->Write ("rotate\n");
                    output->Send (dx); output->Send (dy);        output->Write ("scale\n");
                    
                    output->Write ("128 1 8 [128 0 0 -1 0 1]\n");
                    output->Send (shade, 128, TRUE);
                    output->Write ("image\n");
                    
                } else {
                    
                    output->Send (Qx); output->Send (Qy);        output->Write ("translate\n");
                    output->Send (this->trame[trame].deg_angle); output->Write ("rotate\n");
                    output->Send (dx); output->Send (dy);        output->Write ("scale\n");
                    
                    output->Write ("128 1 8 [128 0 0 -1 0 1]\n");
                    
                    unsigned char rgb_shade[128*3];
                    int index;
                    
		    if ( !( (rset == gset) && (rset == bset) ) ) {
			output->UseColor ();
		    }
	
                    // Transforme l'indication % trame en une couleur...
                    
                    for (index = 0; index < 128; index++) {
                        
                        pcent = 1.0 - ((float)(shade[index]) / 255.0);
                        
                        c_r = rset * pcent + rclr * (1.0 - pcent);
                        c_g = gset * pcent + gclr * (1.0 - pcent);
                        c_b = bset * pcent + bclr * (1.0 - pcent);
                        
                        rgb_shade[index*3+0] = (unsigned char)(c_r * 255.0);
                        rgb_shade[index*3+1] = (unsigned char)(c_g * 255.0);
                        rgb_shade[index*3+2] = (unsigned char)(c_b * 255.0);
                    }
                    
                    output->Send (rgb_shade, 128*3, TRUE);
                    output->Write ("false 3 colorimage\n");
                }
                
                output->Write ("grestore\n");
                
            } else {
                
                output->Write ("% DrawPolyClose - unsupported shade\n");

            }
            
            output->Write ("restore %\n");
        }
    }
    
    output->Write ("ic\n");
}


// Projette le point P sur le segment AB. La seule condition requise pour
// pouvoir faire ce calcul, c'est d'avoir A != B...

static void
ProjettePsurAB (double Ax, double Ay, double Bx, double By, double& Px, double& Py)
{
    double a = ((Ax-Bx)*(Ax-Px) + (Ay-By)*(Ay-Py)) / ((Ax-Bx)*(Ax-Bx) + (Ay-By)*(Ay-By));
    Px = Ax + a * (Bx - Ax);
    Py = Ay + a * (By - Ay);
}

