
	.TITLE	EPSF.ASL

;	----------------------------------------
;		(C) 1993 - Pierre Arnaud
;	----------------------------------------

;	Source du module de librairie EPSF permettant  PAGE de
;	connatre quelques infos sur un fichier EPSF.

	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	MODULES
	.REF	EPSF

REVMAJ	= 0
REVMIN	= 2

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C)  Pierre ARNAUD et EPSITEC-system SA"
	.START	-1


; Date     Rv	Commentaire
; -----------------------------------------------------------------------------------
; 19/08/93 0.2	Optimis le cas o aucune image n'est prsente dans le fichier.
;		Rendu compatible avec les fichiers EPSF produits par ALCHISMAKY (on
;		accepte des nombres flottants en ignorant la partie fractionnaire)
; 01/08/93 0.1	Premire version.
; -----------------------------------------------------------------------------------

cEPSFASCII	= 16'25215053		; "%!PS"
cEPSFDOSBIN	= 16'C5D0D3C6		; "EPSF"


		.LOC	0

BASE:	.16	EPSF_FIRST
	.16	EPSF_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"EPSF"
	.FILL.8	(LGHLIB-APC),0
	.16	_EPSF_OPEN
	.16	_EPSF_CLOSE



;------------\\
;  EPSF_OPEN  >
;============/

; Ouvre un accs au fichier EPSF spcifi.

; in	A3.32	^nom du fichier EPSF
; out	A4.32	^dfinition du fichier OEPSF..
;	D7.16	erreur
; mod	A4.32, D7.16

_EPSF_OPEN:
	PUSHM.32 D0..D6|A0..A3|A6

	MOVE.32	SP,A6

	MOVE.32	#2**BOPRD,D3
	MOVE.32	#0,D4
	MOVE.32	#0,D5
	XFOS_	OPEN
	JUMP,NE	ERR$

	PUSH.32	D4
	MOVE.32	SP,A4
	MOVE.32	#4,D4
	XFOS_	RDMANY				; lit "%!PS" ou <C5D0D3C6>
	JUMP,NE	CLOSE$

	POP.32	D4				; D4 <-- format du fichier EPSF

	COMP.32	#cEPSFDOSBIN,D4			; format DOS binaire ?
	JUMP,EQ	DOSBIN$				; oui => mouais..

CHECK$:	COMP.32	#cEPSFASCII,D4			; format ASCII pur ?
	JUMP,EQ	ASCII$				; oui => bien..

BAD$:	MOVE.16	#1,D7
	JUMP	CLOSE$


; Identifie la section EPSF dans le fichier binaire DOS utilis par
; les applications Windows.

DOSBIN$:
	CALL	READiLONG
	MOVE.32	D4,D0				; D0 <-- position EPSF

; Pour l'instant, on ignore allgrement tout le blabla concernant
; l'environnement Windows et l'image au format TIFF.

	CLR.32	D3
	MOVE.32	D0,D4
	XFOS_	SPOS				; positionne au dbut de la section EPSF

	JUMP	CHECK$				; nouvelle tentative

; Identifie le fichier PostScript comme tant bien un fichier EPSF
; conforme...

ASCII$:	MOVE.32	#R16^TADOBE,A3			; trouve "-Adobe-"
	CALL	READIDENT
	JUMP,NE	CLOSE$

SK1$:	XFOS_	RDONE				; saute les chiffres (rvision)
	JUMP,NE	CLOSE$

	COMP.8	#"E",D3
	JUMP,NE	SK1$

	MOVE.32	#R16^TEPSF,A3
	CALL	READIDENT			; trouve .."PSF-"
	JUMP,NE	CLOSE$

; C'est bien un fichier EPSF... Youpie !

	MOVE.32	#MTYPCP,D1
	MOVE.32	#LGEPSFREC,D4
	GESMEM	?GETMEM				; alloue la mmoire
	JUMP,NE	CLOSE$

	GESMEM	?CLEARMEM

LOOP$:	CALL	FINDDSC				; trouve le prochain "%%"
	JUMP,NE	END$				; rien => erreur

	CALL	READLINE			; lit la ligne en mmoire
	JUMP,EQ	LOOP$

END$:	INC.16	D7				; si erreur => elle avait t dcrmente
	JUMP,EQ	R8^CLOSE$

	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM				; libre la mmoire

CLOSE$:	PUSH.16	D7
	XFOS_	CLOSE
	POP.16	D7

ERR$:	MOVE.32	A6,SP

	POPM.32	D0..D6|A0..A3|A6
	TEST.16	D7
	RET


TADOBE:	.ASCIZ	"-Adobe-"
TEPSF:	.ASCIZ	"PSF-"

TBBOX:	.ASCIZ	"BoundingBox:"
TCREAT:	.ASCIZ	"Creator:"
TTITLE:	.ASCIZ	"Title:"
TBEGIN:	.ASCIZ	"BeginPreview:"
TEND:	.ASCIZ	"EndPreview"
TPROL:	.ASCIZ	"EndProlog"
TEOF:	.ASCIZ	"EOF"

	.EVEN


;------------\\
;  READiLONG  >
;============/

; Lit un .32 depuis un stream INTEL...

; in	D6.32	stream
; out	D4.32	valeur lue
;	D7.16	erreur
; mod	D4.32, D7.16

READiLONG:
	PUSHM.32 D2|D3

	MOVE.32	#8,D2

	XFOS_	RDONE
	MOVE.8	D3,D4
	RR.32	D2,D4				; [ll;--;--;--]
	XFOS_	RDONE
	MOVE.8	D3,D4
	RR.32	D2,D4				; [lh;ll;--;--]
	XFOS_	RDONE
	MOVE.8	D3,D4
	RR.32	D2,D4				; [hl;lh;ll;--]
	XFOS_	RDONE
	MOVE.8	D3,D4
	RR.32	D2,D4				; [hh;hl;lh;ll]

ERR$:	POPM.32	D2|D3
	TEST.16	D7
	RET


;------------\\
;  READIDENT  >
;============/

; Lit et compare  une chane de rfrence.

; in	A3.32	^chane
;	D6.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

READIDENT:
	PUSHM.32 D3|A3

	CLR.16	D7

LOOP$:	TEST.8	{A3}				; termin ?
	JUMP,EQ	R8^EXIT$			; oui => c'est tout bon

	XFOS_	RDONE
	JUMP,NE	EXIT$

	COMP.8	{A3+},D3			; compare "-Adobe-"
	JUMP,EQ	LOOP$

	INC.16	D7

EXIT$:	POPM.32	D3|A3
	TEST.16	D7
	RET


;----------\\
;  FINDDSC  >
;==========/

; Trouve un Document Structuring Comment..

; in	D6.32	canal
; out	D7.16	-1 => termin, autre => erreur + 1
; mod	D7.16

FINDDSC:
	PUSHM.32 D3

CR$:	XFOS_	RDONE
	JUMP,NE	R8^ER$

	COMP.8	#CR,D3
	JUMP,EQ	R8^OK$
	COMP.8	#LF,D3
	JUMP,EQ	R8^OK$
	COMP.8	#"%",D3
	JUMP,EQ	R8^OKPCENT$

	JUMP	CR$

OK$:	XFOS_	RDONE
	JUMP,NE	R8^ER$

	COMP.8	#CR,D3
	JUMP,EQ	R8^OK$
	COMP.8	#LF,D3
	JUMP,EQ	R8^OK$

	COMP.8	#"%",D3
	JUMP,NE	R8^OUT$

OKPCENT$:
	XFOS_	RDONE
	JUMP,NE	R8^ER$
	COMP.8	#"%",D3
	JUMP,NE	CR$

	JUMP	R8^EXIT$			; "%%" => ok

ER$:	COMP.16	#EROUTF,D7
	JUMP,NE	R8^DEC$				; erreur => signale

OUT$:	CLR.16	D7				; hors du fichier => -1 (termin)

DEC$:	DEC.16	D7

EXIT$:	POPM.32	D3
	TEST.16	D7
	RET



;-----------\\
;  READLINE  >
;===========/

; Lit la ligne & analyse.

; in	A4.32	^variables
; out	D7.16	ok
; mod	D7.16

READLINE:
	PUSHM.32 D0|D3|A0

AGAIN$:	MOVE.32	#{A4}+OEPSFBUF,A0
	MOVE.32	#256-2,D0

LOOP$:	XFOS_	RDONE
	JUMP,NE	ER$

	COMP.8	#CR,D3
	JUMP,EQ	R8^OK$
	COMP.8	#LF,D3
	JUMP,EQ	R8^OK$

	MOVE.8	D3,{A0+}
	DEC.32	D0
	JUMP,NE	LOOP$

; Dpassement.. Mauvais signe, on recommence au prochain "%%"

	CALL	FINDDSC
	JUMP,NE	EXIT$

	JUMP	AGAIN$				; recommence

; Ligne remplie

OK$:	CLR.8	{A0}

	MOVE.32	#R16^TACT$,A0
	MOVE.32	#0,D0

LOP$:	PUSHM.32 D4|A2..A4
	MOVE.32	A0,A3
	ADD.A16	{A0}+A16^{D0},A3		; A3 <-- ^texte
	MOVE.32	#{A4}+OEPSFBUF,A4		; A4 <-- ^buffer
	MOVE.32	#R16^TERM$,A2
	LIB	?COMPSTR			; compare le buffer avec le texte
	POPM.32	D4|A2..A4
	JUMP,EQ	FOUND$

	ADD.16	#4,D0
	TEST.16	{A0}+A16^{D0}			; encore ?
	JUMP,NE	LOP$				; oui => teste option suivante

	CLR.16	D7				; pas compris...
	JUMP	EXIT$

FOUND$:	ADD.A16	{A0}+A16^{D0}+2,A0
	CALL	{A0}				; appelle la fonction
	JUMP,EQ	R8^EXIT$

ER$:	COMP.16	#EROUTF,D7
	JUMP,NE	DEC$

	CLR.16	D7

DEC$:	DEC.16	D7

EXIT$:	POPM.32	D0|D3|A0
	TEST.16	D7
	RET

TACT$:	.16	TBBOX-TACT$, doBBOX-TACT$	; "BoundingBox:"
	.16	TCREAT-TACT$, doCREAT-TACT$	; "Creator:"
	.16	TTITLE-TACT$, doTITLE-TACT$	; "Title:"
	.16	TBEGIN-TACT$, doBEGIN-TACT$	; "BeginPreview:"
	.16	TPROL-TACT$, doEOF-TACT$	; "EndProlog"
	.16	TEOF-TACT$, doEOF-TACT$		; "EOF"
	.16	0,0

TERM$:	.8	SPACE,TAB,CR,LF,EOP,0,-1
	.EVEN


; Interprte "%%BoundingBox: llx lly urx ury"

doBBOX:
	PUSHM.32 D0..D4|A0|A4

	MOVE.32	A4,A0

	MOVE.32	#{A4}+OEPSFBUF+13,A4		; A4 <-- ^premier paramtre
	CALL	GETDECint			; D4 <-- llx
	MOVE.32	D4,D0

	CALL	GETDECint			; D4 <-- lly
	MOVE.32	D4,D1

	CALL	GETDECint			; D4 <-- urx
	MOVE.32	D4,D3

	CALL	GETDECint			; D4 <-- ury

	SUB.32	D0,D3				; D3 <-- [dx] en 1/72 "
	SUB.32	D1,D4				; D4 <-- [dy] en 1/72 "

	MUL.16	#53,D3
	DIV.16	#3,D3				; D3 <-- preseque [dx] * 1270 / 72 => 0.02 mm
	MUL.16	#53,D4
	DIV.16	#3,D4				; D4 <-- preseque [dy] * 1270 / 72 => 0.02 mm

	MOVE.16	D3,{A0}+OEPSFDX
	MOVE.16	D4,{A0}+OEPSFDY

	POPM.32	D0..D4|A0|A4
	TEST.16	D7
	RET


; Interprte "%%Creator: blabla..."

doCREAT:
	PUSHM.32 A0|A1

	MOVE.32	#{A4}+OEPSFBUF+9,A0
	MOVE.32	#{A4}+OEPSFCREAT,A1

COPY$:	MOVE.8	{A0+},{A1+}
	JUMP,NE	COPY$

	POPM.32	A0|A1
	CLR.16	D7
	RET	


; Interprte "%%Title: blabla..."

doTITLE:
	PUSHM.32 A0|A1

	MOVE.32	#{A4}+OEPSFBUF+7,A0
	MOVE.32	#{A4}+OEPSFTITLE,A1

COPY$:	MOVE.8	{A0+},{A1+}
	JUMP,NE	COPY$

	POPM.32	A0|A1
	CLR.16	D7
	RET	


; Interprte "%%BeginPreview: dx dy bpp lines"

doBEGIN:
	PUSHM.32 D0..D5|A0|A4

	MOVE.32	A4,A0

	MOVE.32	#{A4}+OEPSFBUF+14,A4		; A4 <-- ^premier paramtre
	CALL	GETDECint			; D4 <-- dx
	MOVE.32	D4,D2

	CALL	GETDECint			; D4 <-- dy
	MOVE.32	D4,D3

	CALL	GETDECint			; D4 <-- bpp
	MOVE.32	D4,D0

	CLR.32	D4
	MOVE.16	D2,D4
	ADD.16	#7,D4
	SR.32	#.LOG2.8,D4
	MOVE.16	D4,{A0}+OEPSFIMWB		; largeur en bytes de l'image
	MUL.16	D3,D4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM				; alloue mmoire pour l'image
	JUMP,NE	ERR$

	GESMEM	?CLEARMEM

	MOVE.16	D2,{A0}+OEPSFIMDX
	MOVE.16	D3,{A0}+OEPSFIMDY

; D0 = nb. bits/pixel (1, 2, 4 ou 8)

	MOVE.32	A4,{A0}+OEPSFIMPTR
	SET.8	{A0}+OEPSFIMOK

	MOVE.32	#8,D1				; compteur
	MOVE.32	#2'00000001,D2			; masque
	COMP.8	#1,D0
	JUMP,EQ	R8^READ$

	MOVE.32	#4,D1				; compteur
	MOVE.32	#2'00000011,D2			; masque
	COMP.8	#2,D0
	JUMP,EQ	R8^READ$

	MOVE.32	#2,D1				; compteur
	MOVE.32	#2'00001111,D2			; masque
	COMP.8	#4,D0
	JUMP,EQ	R8^READ$

	MOVE.32	#1,D1				; compteur
	MOVE.8	#2'11111111,D2			; masque

; D0:	bits/pixel, amplitude d'un rotate
; D1:	nombre de rotates  effectuer
; D2:	masque pour extraire les bits

READ$:	MOVE.32	#7,D3				; position du bit (7  0)

LOOP$:	CALL	RDHEXBYTE			; lit un byte dans D5.8
	JUMP,NE	GIV$				; erreur => abandonne


; Place les bits lus dans la mmoire de l'image

	PUSH.32 D1

COPY$:	RL.8	D0,D5				; D5 <-- [65432107]
	MOVE.8	D5,D7
	AND.8	D2,D7				; D7 nul => mettre zro, autre => mettre un
	JUMP,EQ	R8^NXT$
	TSET.8	{A4}:D3				; allume le bit

NXT$:	DEC.8	D3
	JUMP,GE	R8^NOINC$

	MOVE.32	#7,D3
	INC.32	A4				; avance d'un byte entier
	DEC.32	D4				; un byte de moins

NOINC$:	DEC.8	D1
	JUMP,NE	COPY$

	POP.32	D1

	TEST.32	D4				; encore  lire => lit la suite
	JUMP,GT	LOOP$

	MOVE.16	#0,D7
	JUMP	ERR$


GIV$:	PUSH.16	D7
	MOVE.32	{A0}+OEPSFIMPTR,A4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM

	CLR.32	{A0}+OEPSFIMPTR
	CLR.8	{A0}+OEPSFIMOK
	POP.16	D7

ERR$:	POPM.32	D0..D5|A0|A4
	TEST.16	D7
	RET	


doEOF:
	MOVE.16	#EROUTF,D7			; atteint EOF
	RET


;------------\\
;  RDHEXBYTE  >
;============/

; Lit un byte depuis le flux hexadcimal...

; in	D6.32	canal
; out	D5.8	valeur
;	D7.16	erreur
; mod	D5.8, D7.16

RDHEXBYTE:
	PUSH.32 D3 

SK1$:	XFOS_	RDONE
	JUMP,NE	ERR$

	LIB	?MINMAJ

	COMP.8	#"0",D3
	JUMP,LT	R8^SK1$
	COMP.8	#"9",D3
	JUMP,LE	R8^OK1$
	COMP.8	#"A",D3
	JUMP,LT	R8^SK1$
	COMP.8	#"F",D3
	JUMP,GT	R8^SK1$

	SUB.8	#"A"-("9"+1),D3

OK1$:	SUB.8	#"0",D3
	MOVE.8	D3,D5

SK2$:	XFOS_	RDONE
	JUMP,NE	ERR$

	LIB	?MINMAJ

	COMP.8	#"0",D3
	JUMP,LT	R8^SK2$
	COMP.8	#"9",D3
	JUMP,LE	R8^OK2$
	COMP.8	#"A",D3
	JUMP,LT	R8^SK2$
	COMP.8	#"F",D3
	JUMP,GT	R8^SK2$

	SUB.8	#"A"-("9"+1),D3

OK2$:	SUB.8	#"0",D3
	SWAP.8	D5
	OR.8	D3,D5

ERR$:	POP.32	D3
	TEST.16	D7
	RET


;------------\\
;  GETDECint  >
;============/

; Cherche un dcimal entier sign. Fait automatiquement la conversion
; BCD en binaire. Les limites sont +/- 99'999'999. Accpte tout comme
; terminateur (ce qui n'est pas dans "+-'0123456789"). Saute le ".num"
; qui suit..

; in	A4.32	^chane de caractres
; out	A4.32	^plus loin
;	D4.32	nombre sign entier
;	D7.16	ok/erreur (1 = c'est pas un nombre, 2 = c'est trop grand)
; mod	A4.32, D4.32, D7.16

GETDECint:
	PUSHM.32 D3|D5

	CLR.32	D4
	MOVE.32	#7,D5			; maximum de 8 chiffres

SK$:	MOVE.8	{A4+},D3		; saute les espaces
	COMP.8	#SPACE,D3
	JUMP,EQ	SK$
	COMP.8	#TAB,D3
	JUMP,EQ	SK$

	COMP.8	#"+",D3
	JUMP,EQ	R8^PLUS$
	COMP.8	#"-",D3
	JUMP,NE	R8^DO$
	TSET.32	D5:#31			; nombre ngatif..

PLUS$:	MOVE.8	{A4+},D3		; cherche le signe aprs "+" ou "-"

DO$:	TEST.32	D5:#30			; dj vu un chiffre ?
	JUMP,BC	R8^CHIF$		; non => alors ce doit tre un chiffre
	COMP.8	#"'",D3
	JUMP,NE	R8^CHIF$		; passe au car. suivant
	MOVE.8	{A4+},D3		; chiffre qui suit

CHIF$:	SUB.8	#"0",D3			; est-ce de 0  9 ?
	JUMP,LT	R8^OK$
	COMP.8	#9,D3
	JUMP,GT	R8^OK$
	TSET.32	D5:#30			; on a atteint un chiffre !
	SL.32	#4,D4
	OR.8	D3,D4			; ajoute le BCD sur les bits [0..3]

NEXT$:	MOVE.8	{A4+},D3
	DJ.16,NMO D5,DO$		; suite si les 8 chiffres pas couls

	COMP.8	#"'",D3
	JUMP,NE	R8^CHIF2$		; teste s'il suit un chiffre
	MOVE.8	{A4+},D3

CHIF2$:	SUB.8	#"0",D3
	JUMP,LT	R8^OK$			; ok, on a trouv le terminateur
	COMP.8	#9,D3
	JUMP,GT	R8^OK$			; ok, c'est pas un chiffre

	MOVE.16	#2,D7			; nombre trop grand !!!
	JUMP	R8^ERR$

OK$:	TEST.32	D5:#30			; a-t-on au moins un chiffre ?
	JUMP,BS	R8^END$			; oui => bientt fin du travail
	MOVE.16	#1,D7			; non => pas un nombre
	JUMP	R8^ERR$

END$:	LIB	?BCDBIN			; transforme en un binaire
	TEST.32	D5:#31
	JUMP,BC	R8^ERR$			; termine si signe "+"

	NEG.32	D4			; autrement, inverse le signe

ERR$:	MOVE.8	{A4}-1,D3
	COMP.8	#".",D3
	JUMP,NE	R8^EXIT$

SK1$:	MOVE.8	{A4+},D3
	COMP.8	#"0",D3
	JUMP,LT	R8^EX1$
	COMP.8	#"9",D3
	JUMP,LE	SK1$

EX1$:	DEC.32	A4

EXIT$:	POPM.32	D3|D5
	TEST.16	D7			; test pour EQ/NE
	RET




;-------------\\
;  EPSF_CLOSE  >
;=============/

; Ferme un accs au fichier EPSF.

; in	A4.32	^dfinition du fichier OEPSF..
; out	D7.16	erreur
; mod	D7.16

_EPSF_CLOSE:
	PUSHM.32 D1|A0|A4

	MOVE.32	A4,A0

	MOVE.32	#MTYPCP,D1
	MOVE.32	{A0}+OEPSFIMPTR,A4
	COMP.A16 #0,A4
	JUMP,EQ	R8^NEXT$

	GESMEM	?GIVMEM

NEXT$:	MOVE.32	A0,A4
	GESMEM	?GIVMEM


ERR$:	POPM.32	D1|A0|A4
	TEST.16	D7
	RET

END_MODULE:

	.END
