
/*
 *	level1.cc
 *
 *	Gnre du code PostScript pour une imprimante level 1.
 *
 *	(C) Copyright 1993-1998,  Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>


#include "page-struct.h"


// Emet un nombre entier.

void
OutputLevel1::Send (int i)
{
    char buffer[20];
    sprintf (buffer, "%d ", i);
    Write (buffer);
}


// Emet un nombre flottant.

void
OutputLevel1::Send (float f)
{
    char buffer[40];
    sprintf (buffer, "%f ", f);
    Write (buffer);
}


// Emet une chane de caractres

void
OutputLevel1::Send (const char* string)
{
    int size = strlen (string);
    char* buffer = new char[size+2+1];
    
    if (buffer == 0) {
        Write ("(--memory full--)");
        return;
    }
    
    strcpy (buffer, "(");
    strcat (buffer, string);
    strcat (buffer, ")");
    
    Write (buffer);
    delete buffer;
}


// Emet une chane hexadcimale

void
OutputLevel1::Send (const void* string, int size, Bool brackets)
{
    if (brackets) Write ("<");
    
    while (size--) {
        unsigned char c = *((const char*)(string))++;
        int log = c & 0x0F;
        int hig = c >> 4;
        char buffer[4];
        
        buffer[0] = hig + (hig < 10 ? '0' : ('a' - 10));
        buffer[1] = log + (log < 10 ? '0' : ('a' - 10));
        
        Write (buffer, 2);
    }
    
    if (brackets) Write (">\n"); else Write ("\n");
}




// Emet une des commandes internes effectuant une des oprations
// graphique de base.

void
OutputLevel1::Send (PSops op)
{
    switch (op) {
        case PS_ROUND_LINE:
            Write ("rl\n");
            break;
        
        case PS_ELLIP_LINE:
            Write ("el\n");
            break;
        
        case PS_SQUARE_LINE:
            Write ("sl\n");
            break;
        
        case PS_RECT_LINE:
            Write ("Rl\n");
            break;
        
        case PS_MISC_LINE:
            Write ("ml\n");
            break;
        
        case PS_ROUND_BEZIER:
            Write ("rb\n");
            break;
        
        case PS_ELLIP_BEZIER:
            Write ("eb\n");
            break;
        
        case PS_SQUARE_BEZIER:
            Write ("sb\n");
            break;
        
        case PS_RECT_BEZIER:
            Write ("Rb\n");
            break;
        
        case PS_POLYNEW:
            Write ("pn\n");
            break;
        
        case PS_POLYLINE:
            Write ("pl\n");
            break;
        
        case PS_POLYBEZIER:
            Write ("pb\n");
            break;
        
        case PS_POLYFILL:
            Write ("pf\n");
            break;
        
        default:
            Write ("% bug in driver software !\n");
    }
}

