
/*
 *	level2.cc
 *
 *	Gnre du code PostScript pour une imprimante level 2.
 *	Youpie, a c'est gnial !!!
 *
 *	(C) 1993,  Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

extern "C" {
#include <stdlib.h>
#include <stdio.h>
}

#include "page-struct.h"


// Emet un nombre entier.

void
OutputLevel2::Send (int i)
{
    if ((i <= 127) && (i >= -128)) {
        
        char buffer[8];
        buffer[0] = 136;		// entier de 1 byte
        buffer[1] = i;
        Write (buffer, 2);
        
    } else if ((i <= 32767) && (i >= -32768)) {
        
        char buffer[8];
        buffer[1] = 134;		// entier de 2 bytes, poids fort d'abord
        *((short*)(&buffer[2])) = i;
        Write (buffer+1, 3);
        
    } else {
        
        char buffer[8];
        buffer[1] = 132;		// entier de 4 bytes, poids fort d'abord
        *((long*)(&buffer[2])) = i;
        Write (buffer+1, 5);
        
    }
}


// Emet un nombre flottant.

void
OutputLevel2::Send (float f)
{
    char buffer[8];
    buffer[1] = 138;			// flottant IEEE 32 bit, poids fort d'abord
    *((float*)(&buffer[2])) = f;
    
    Write (buffer+1, 5);
}


// Emet une chane de caractres

void
OutputLevel2::Send (const char* string)
{
    int size = strlen (string);
    
    if (size < 256) {
        
        char buffer[8];
        buffer[0] = 142;		// string court <= 255 caractres
        buffer[1] = size;
        Write (buffer, 2);
        Write (string, size);
        
    } else {				// string long
        
        char buffer[8];
        buffer[1] = 143;
        *((short*)(&buffer[2])) = size;
        Write (buffer+1, 3);
        Write (string, size);
    }
}


// Emet une chane hexadcimale

void
OutputLevel2::Send (const void* string, int size, Bool brackets)
{
    if (size < 256) {
        if (brackets) {
            char buffer[8];
            buffer[0] = 142;		// string court <= 255 caractres
            buffer[1] = size;
            Write (buffer, 2);
        }
        Write (string, size);
        
    } else {				// string long
        
        if (brackets) {
            char buffer[8];
            buffer[1] = 143;
            *((short*)(&buffer[2])) = size;
            Write (buffer+1, 3);
        }
        Write (string, size);
    }
}





// Emet une des commandes internes effectuant une des oprations
// graphique de base.

void
OutputLevel2::Send (PSops op)
{
    switch (op) {
        case PS_ROUND_LINE:
            Write ("rl\n");
            break;
        
        case PS_ELLIP_LINE:
            Write ("el\n");
            break;
        
        case PS_SQUARE_LINE:
            Write ("sl\n");
            break;
        
        case PS_RECT_LINE:
            Write ("Rl\n");
            break;
        
        case PS_MISC_LINE:
            Write ("ml\n");
            break;
        
        case PS_ROUND_BEZIER:
            Write ("rb\n");
            break;
        
        case PS_ELLIP_BEZIER:
            Write ("eb\n");
            break;
        
        case PS_SQUARE_BEZIER:
            Write ("sb\n");
            break;
        
        case PS_RECT_BEZIER:
            Write ("Rb\n");
            break;
        
        case PS_POLYNEW:
            Write ("pn\n");
            break;
        
        case PS_POLYLINE:
            Write ("pl\n");
            break;
        
        case PS_POLYBEZIER:
            Write ("pb\n");
            break;
        
        case PS_POLYFILL:
            Write ("pf\n");
            break;
        
        default:
            Write ("% bug in driver software !\n");
    }
}

