/*
 *		library.cc
 *
 *		Module de "librairie" utilisable depuis l'extrieur pour
 *		gnrer du PostScript.
 *
 *		(C) 1993-1999,	Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

extern "C" {
#include <stdlib.h>
#include <stdio.h>
extern int F_dir (const char* directory);
}

#include "page-struct.h"
#include "ppslibrary.h"


// Initialise le module de librairie.

short
PagePS_Open (long mode, short dpix, short dpiy, short sizex, short sizey,
			 const char* file, const char* info, const char* epsf,
			 const char* rules, PagePS** inst)
{
	PagePS* pps = new PagePS ();
	Output* out = 0;
	
	if (pps == 0) {
		*inst = pps;
		return 1;
	}
	
	F_dir ("#psspool:");
	
	if ( (mode & 0x01)
	  && (out = ((mode & 0x40) ? (new OutputLevel1 ((long)(file)))
							   : (new OutputLevel1 ((const char*)(file)))) ) ) {
		if (!out->Ok ()) {
			delete out;
			out = 0;
		}
		
		if (mode & 0x04) pps->IsColor (TRUE);
		if (mode & 0x08) pps->PageMode (TRUE);
		
		pps->StrokeAdjust (FALSE);
	}
	
	if ((mode & 0x02) && (out = ((mode & 0x40) ? (new OutputLevel2 ((long)(file)))
											   : (new OutputLevel2 ((const char*)(file)))) ) ) {
		if (!out->Ok ()) {
			delete out;
			out = 0;
		}
		
		if (mode & 0x08) pps->PageMode (TRUE);
		if (mode & 0x10) pps->StrokeAdjust (FALSE);
	}
	
	if (out == 0) {
		delete pps;
		*inst = 0;
		return 2;
	}
	
	if (mode & 0x20) pps->DefaultNumPage (mode >> 16);
	if (mode & 0x80) pps->SetNoMulti ();
	
	char double_null[2] = { 0, 0 };
	
	if ((mode & 0x100) == 0) epsf = double_null;
	if ((mode & 0x200) == 0) rules = double_null;
	
	pps->SetResolution (dpix, dpiy);
	pps->SetPageSize (sizex, sizey);
	
	const char* doc      = info; if (info) while (*info++);
	const char* author   = info; if (info) while (*info++);
	const char* for_whom = info; if (info) while (*info++);
	const char* date     = info; if (info) while (*info++);
	const char* for_dest = info; if (info) while (*info++);
	
	pps->SetOutput (out);
	pps->NewDocument (doc, author, for_whom, date, for_dest, epsf, rules);
	
	if (pps->HadFailure ()) {
		delete pps;
		delete out;
		*inst = 0;
		return 3;
	}
	
	*inst = pps;
	return 0;
}


short
PagePS_Close (PagePS* pps)
{
	Output* out = pps->GetOutput ();
	delete pps;
	return 0;
}


short
PagePS_Page (PagePS* pps, long num)
{
	pps->PreparePage ();
	pps->NewPage (num);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_InitPage (PagePS* pps, long mode, short x, short y, long mul, long angle)
{
	Bool  screen = FALSE;
	Bool  page	 = (mode & 0x01) ? TRUE : FALSE;
	
	float ang	 = angle / 65536.0;
	float sx	 = x / 1000.0;
	float sy	 = y / 1000.0;
	
	pps->TurnPage (page);
	pps->ScalePage (sx, sy);
	
	if (mode & 0x02) { pps->NewGlyphMode (TRUE); }
	if (mode & 0x04) { pps->ScreenParam (mul, ang); screen = TRUE; }
	if (mode & 0x08) { pps->PageMode (TRUE); }

#if 0
	if ( (screen == TRUE) || (sx != 1.0) || (sy != 1.0) ) {
		pps->SetupPage ();
	}
#endif
	return 0;
}

short
PagePS_InitPen (PagePS* pps, const PenDesc* desc, int i)
{
	pps->InitPenDesc (desc, i);
	return 0;
}


short
PagePS_InitTrame (PagePS* pps, const TrameDesc* desc, int i)
{
	pps->InitTrameDesc (desc, i);
	return 0;
}


short
PagePS_InitColor (PagePS* pps, const ColorDesc* desc, int i)
{
	pps->InitColorDesc (desc, i);
	return 0;
}


short
PagePS_DrLine (PagePS* pps, short x, short y, short dx, short dy, int pen)
{
	Bool reset = (pen & 0x80000000) == 0;
	pen &= 0x0000FFFF;
	pps->PreparePage ();
	pps->DrawLine (x, y, dx, dy, pen, reset);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrBezier (PagePS* pps, short p1x, short p1y, short c1x, short c1y,
				 short c2x, short c2y, short p2x, short p2y, int pen)
{
	Bool reset = (pen & 0x80000000) == 0;
	pen &= 0x0000FFFF;
	pps->PreparePage ();
	pps->DrawBezier (p1x, p1y, c1x, c1y, p2x, p2y, c2x, c2y, pen, reset);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrPolyOpen (PagePS* pps)
{
	pps->PreparePage ();
	pps->PolyOpen ();
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrPolyLine (PagePS* pps, short x, short y, short dx, short dy)
{
	pps->PolyLine (x, y, dx, dy);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrPolyBezier (PagePS* pps, short p1x, short p1y, short c1x, short c1y,
					 short c2x, short c2y, short p2x, short p2y)
{
	pps->PolyBezier (p1x, p1y, c1x, c1y, p2x, p2y, c2x, c2y);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrPolyClose (PagePS* pps, int trame, int x1, int y1, int x2, int y2)
{
	trame &= 0x400000FF;
	pps->PolyClose (trame, x1, y1, x2, y2);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrGlyph (PagePS* pps, short x, short y, short dx, short dy,
				short color, short width, long id1, long id2, const void* image,
				const void* glyph)
{
	if (pps->NewGlyphMode () == FALSE) glyph = 0;
	pps->PreparePage ();
	pps->DrawGlyph (x, y, dx, dy, width, color, id1, id2, image, glyph);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrMonoImage (PagePS* pps, short x1, short y1, short x2, short y2, short pdx, short pdy,
					long angle, short color, short width, const void* image)
{
	float ang = angle / 65536.0;
	pps->PreparePage ();
	pps->DrawMonoImage (x1, y1, x2, y2, pdx, pdy, ang, width, color, image);
	return (pps->HadFailure ()) ? 1 : 0;
}


short
PagePS_DrColorImage (PagePS* pps, short bpp, short width, short x1, short y1,
					 short x2, short y2, short pdx, short pdy, long angle,
					 const void* clut, const void* image)
{
	float ang = angle / 65536.0;
	pps->PreparePage ();
	pps->DrawColorImage (x1, y1, x2, y2, pdx, pdy, ang, bpp, width, clut, image);
	return (pps->HadFailure ()) ? 1 : 0;
}

void
PagePS::PageMode (Bool x)
{
	page_mode = getenv ("PPS_PAGEMODE") ? x : FALSE;
}
