
/*
 *	ntrelbar.h
 *
 *	Interface avec les botes  rendez-vous du noyau
 *	temps rel.
 *
 *	(C) 1993,  Pierre ARNAUD, CH-1437 SUSCEVAZ
 */

#ifndef _NTRELBAR_H_
#define _NTRELBAR_H_

/********************************************************************************
 *										*
 *	Le principe de la communication par BAR est assez simple.		*
 *										*
 *	Serveur:	NtrelAcceptBar		(bloque)			*
 *	Client:		NtrelOfferBar		(bloque si pas d'accept)	*
 *	Client:	   -1->	NtrelEndOfferBar	(bloque)			*
 *	Serveur:	NtrelAcceptBar    -1->	(sortie de l'appel)		*
 *	Serveur:   -2-> NtrelEndAcceptBar					*
 *	Client:		NtrelEndOfferBar  -2->	(sortie de l'appel)		*
 *										*
 ********************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

typedef void* NtrelBar;

extern int NtrelCreBar (const char* name, NtrelBar* bar);
extern int NtrelKillBar (NtrelBar bar);
extern int NtrelAcceptBar (NtrelBar bar, void** ptr);
extern int NtrelEndAcceptBar (NtrelBar bar, void* ptr);
extern int NtrelOfferBar (NtrelBar bar);
extern int NtrelEndOfferBar (NtrelBar bar, void* in_ptr, void** out_ptr);

#ifdef __cplusplus
}
#endif

#endif

