/*
 *		output.cc
 *
 *		Routines de bas niveau pour mettre des caractres vers
 *		un fichier quelconque. Implmente un petit buffer.
 *
 *		(C) 1993-1998,	Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "page-struct.h"

static void* xfos_debug = 0;
static long  xfos_count = 0;

static void
OpenDebugChannel ()
{
	const char* dbgfile_name = getenv ("PPS_DBGFILE");
	
	if (dbgfile_name) {
		long attr_chan = 0x27FF;			// DEFATT
		long mode = 0x0004;					// 2**BDELETE
		int error = _xfos_create (dbgfile_name, &attr_chan, &mode);
		xfos_debug = (error) ? 0 : (void*)(attr_chan);
		xfos_count = 0;
	}
}

static void
CloseDebugChannel ()
{
	if (xfos_debug) {
		asm volatile ( "movel #3,d0\n\t"		// XFOS__TRUNC
					   "movel %0,d6\n\t"		// canal XFOS
					   ".word 0xA30F"			// XFOS_ EXTEND
					 :
					 : "g" (xfos_debug)
					 : "d0", "d6", "d7" );

		_xfos_close (xfos_debug);
	}
}


Output::Output (const char* name)
{
	long attr_chan = 0x27FF;			// DEFATT
	long mode = 0x0004;					// 2**BDELETE
	int error = _xfos_create (name, &attr_chan, &mode);
	this->file = (error) ? 0 : (void*)(attr_chan);
	this->or = this->og = this->ob = -1.0;
	this->show_buffer[0] = 0;
	this->show_len = 0;
	this->do_close = TRUE;
	this->is_color = FALSE;
	
	OpenDebugChannel ();
}

Output::Output (long channel)
{
	file = (void*)(channel);
	or = og = ob = -1.0;
	show_buffer[0] = 0;
	show_len = 0;
	do_close = FALSE;
	
	OpenDebugChannel ();
}


Output::~Output ()
{
	if (file) {
		asm volatile ( "movel #3,d0\n\t"		// XFOS__TRUNC
					   "movel %0,d6\n\t"		// canal XFOS
					   ".word 0xA30F"			// XFOS_ EXTEND
					 :
					 : "g" (file)
					 : "d0", "d6", "d7" );
	}
	
	if (do_close && file) {
		_xfos_close (file);
	}
	
	CloseDebugChannel ();
}


void
Output::RealEmitShow ()
{
	if (xfos_debug) {
		char buffer[100];
		long count = 0;
		sprintf (buffer, "%05d: emit-show\r", xfos_count++);
		count = strlen (buffer);
		_xfos_wrbyte (xfos_debug, &count, buffer);
	}
	
	this->show_len = 0;
	this->Send (this->show_buffer);
	this->Send (this->show_ox);
	this->Send (this->show_oy);
	this->Write ("S\n", -2);
}


Bool
Output::Write (const void* data, int size)
{
	if (size >= 0) EmitShow (); else size = -size;
	if (file == 0) return FALSE;
	
	long count = size;
	int error = _xfos_wrbyte (file, &count, data);
	
	if (xfos_debug) {
		char buffer[100];
		long count = 0;
		sprintf (buffer, "%05d: wr %d [", xfos_count++, size);
		count = strlen (buffer);
		_xfos_wrbyte (xfos_debug, &count, buffer);
		count = size;
		_xfos_wrbyte (xfos_debug, &count, data);
		count = 2;
		_xfos_wrbyte (xfos_debug, &count, "]\r");
	}
	
	return (error) ? FALSE : TRUE;
}


Bool
Output::Write (const char* s)
{
	return Write (s, strlen (s));
}


void
Output::Color (float r, float g, float b)
{
	if ((r == or) && (g == og) && (b == ob))
		return;
	
	or = r;
	og = g;
	ob = b;
	
	EmitShow ();
	
	if ( (r == 1.0) && (g == 1.0) && (b == 1.0) ) {
		Write ("cW ", -3);
		return;
	}
	
	if ( (r == 0.0) && (g == 0.0) && (b == 0.0) ) {
		Write ("cB ", -3);
		return;
	}
	
	if ( (r == g)
	  && (r == b) ) {
		
		Send (r);
		Write ("cG ", -3);
		
	} else {
		
		Send (r);
		Send (g);
		Send (b);
		
		Write ("c ", -2);
		
		this->is_color = TRUE;
	}
}

void
Output::Show (const char* text, int x, int y, float w, int dx)
{
	if (xfos_debug) {
		char buffer[100];
		long count = 0;
		sprintf (buffer, "%05d: show (%d,%d) w=%f dx=%d\r", xfos_count++, x, y, w, dx);
		count = strlen (buffer);
		_xfos_wrbyte (xfos_debug, &count, buffer);
	}
	
	int len = strlen (text);
	
	if ( ((len + this->show_len + 1) > sizeof (this->show_buffer))
	  || (text[0] == ' ') ) {
		EmitShow ();
	}
	
	if (text[0] == ' ') return;
	
	if (this->show_len == 0) {
		strcpy (this->show_buffer, text);
		this->show_ox = x;
		this->show_oy = y;
		this->show_len = len;
		this->show_w = w;
		this->show_dx = dx;
		this->show_num = 1;
		return;
	}
	
	strcpy (this->show_buffer+this->show_len, text);
	this->show_len += len;
	this->show_w   += w;
	this->show_dx  += dx;
	this->show_num++;
}

void
Output::ResetColor ()
{
	or = 0.0;
	og = 0.0;
	ob = 0.0;
}

