
	.TITLE	PAGEPS.ASL

;	----------------------------------------
;	 (C) Copyright 1993-1999, Pierre ARNAUD
;	----------------------------------------

;	Source du module de librairie PAGEPS mettant  disposition
;	une interface entre le monde assembleur et le serveur de
;	conversion PAGE -> PostScript (nomm SMA_PSDRIV.CODE).

	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	PAGEPS
	.REF	MON

REVMAJ	= 2
REVMIN	= 4

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C)  Pierre ARNAUD et EPSITEC SA"
	.START	-1


;	Dfinition des commandes disponibles
;	------------------------------------

PPS_ABORT_CMD		= -1

PPS_OPEN_CMD		= 0
PPS_CLOSE_CMD		= 1
PPS_PAGE_CMD		= 2
PPS_INITPEN_CMD		= 3
PPS_INITTRAME_CMD	= 4
PPS_INITCOLOR_CMD	= 5
PPS_DRLINE_CMD		= 6
PPS_DRBEZIER_CMD	= 7
PPS_DRPOLYOPEN_CMD	= 8
PPS_DRPOLYLINE_CMD	= 9
PPS_DRPOLYBEZIER_CMD	= 10
PPS_DRPOLYCLOSE_CMD	= 11
PPS_DRGLYPH_CMD		= 12
PPS_DRMONOIMAGE_CMD	= 13
PPS_DRCOLORIMAGE_CMD	= 14

; 	Constantes diverses
;	-------------------

WAITKILLDEL	= 5			; attend max 5 secondes sur BAR pour tuer


;	Variables globales
;	------------------

		.LOC	0

OvarSEM:	.BLK.32	1		; ^smaphore d'exclusion
OvarBAR:	.BLK.32	1		; ^BAR pour communiquer

OvarINI:	.BLK.8	1		; TRUE => initialis
		.EVEN

OvarCOUNT:	.BLK.32	1		; compteur d'utilisations
OvarCACHE:	.BLK.32	1		; compteur pour PPS_CACHE
LGVAR:


;	Variables associes  un canal
;	------------------------------


		.LOC	0

OcanVAR:	.BLK.32	1		; ^variables globales
OcanPPS:	.BLK.32	1		; canal PPS associ
LGCAN:

		.LOC	0

BASE:	.16	PPS_FIRST
	.16	PPS_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"PAGEPS"
	.FILL.8	(LGHLIB-APC),0
	.16	_PPS_OPEN
	.16	_PPS_CLOSE
	.16	_PPS_PAGE
	.16	_PPS_INITPEN
	.16	_PPS_INITTRAME
	.16	_PPS_INITCOLOR
	.16	_PPS_DRLINE
	.16	_PPS_DRBEZIER
	.16	_PPS_DRPOLYOPEN
	.16	_PPS_DRPOLYLINE
	.16	_PPS_DRPOLYBEZIER
	.16	_PPS_DRPOLYCLOSE
	.16	_PPS_DRGLYPH
	.16	_PPS_DRMONOIMAGE
	.16	_PPS_DRCOLORIMAGE
	.16	_PPS_CONTROL


;-----------\\
;  PPS_OPEN  >
;===========/

; Dbut d'une impression PostScript. Ecrit le fichier PostScript
; dont le nom est spcifi en entre.

; in	D2.32	mode
;		 #2**BPPSLEV1, gnre du PostScript level 1
;		 #2**BPPSLEV2, gnre du PostScript level 2
;		 #2**BPPSCOLOR, si BPPSLEV1 signale une imprimante couleur
;		 #2**BPPSPAGEMODE, trait(ill)s comme dans PAGE		 --NEW--
;		 #2**BPPSNOADJUST, supprime "stroke adjust" (si level 2) --NEW--
;		 #2**BPPSNUMPAGE, nombre de tirages dans D2 [31..16]	 --NEW--
;		 #2**BPPSXFOSCAN, canal XFOS (D6) au lieu du nom (A3)	 --NEW--
;		 #2**BPPSNOMULTI, une seule page par feuille		 --NEW--
;		 #2**BPPSEPSF, possde des fichiers EPSF		 --NEW--
;		 #2**BPPSRULES, rgles dans fichier PostScript		 --NEW--
;	D2	[31..16] nombre de tirages si D2:#BPPSNUMPAGE
;	D3.32	rsolution de l'imprimante [y;x]	[dpi]
;	D4.32	dimensions d'une page [dy;dx]		[obj]
;	D6.32	canal XFOS au lieu du nom de fichier si D2:#BPPSXFOSCAN
;	A1.32	^rgles PostScript termines par <0> si D2:#BPPSRULES
;	A2.32	^table des fichiers EPSF  inclure : "nom<0>nom<0>..<0>nom<0><0>" si D2:#BPPSEPSF
;	A3.32	^nom du fichier PostScript
;	A4.32	^chane du type "nom du document<0>logiciel<0>nom rseau<0>date<0><0>"
; out	A2.32	canal PostScript
;	D7.16	erreur
; mod	D7.16, A2.32

_PPS_OPEN:
	PUSHM.32 D1|D2|D4|A0|A1|A3|A4|A6	; 8 argument !!!

.if 0
	pushm.32 a3|a4
	move.32	a4,a3
	mon	?aftim
	.ascize	"<CR>PpsOpen: "
	mon	?aftext
	mon	?afcr, ?aftext
	mon	?afcr, ?aftext
	mon	?afcr, ?aftext
	popm.32	a3|a4
.endif

	MOVE.32	#{SP}+8*4+4,A0		; ^ PC sauv sur la pile

	PUSHM.32 A2|A3|A4

	MOVE.32	{A0},A4
	FOS	?IDENT			; A3 <-- ^nom du programme appelant
	JUMP,NE	NOPAGE$

	MOVE.32	#R16^NMPAGE,A4
	MOVE.32	#R16^CPTERM,A2
	LIB	?CPSTRING		; est-ce PAGE.CODE ?
	JUMP,NE	NOPAGE$			; non => suite
	TSET.32	D2:#BPPSPAGEMODE	; oui => met le mode "PAGE"

NOPAGE$:
	POPM.32	A2|A3|A4

	CALL	OPENcomMEM		; retourne les variables globales (A6)
	JUMP,NE	EXIT$			; erreur => abandonne

	TEST.32	D2:#BPPSXFOSCAN
	JUMP,BC	R8^NOFOS$

	MOVE.32	D6,A3			; A3 <-- canal FOS  utiliser

NOFOS$:	PUSH.32	A1			; ^rgles (si elles existent)
	PUSH.32	A2			; ^liste des noms EPSF
	PUSH.32	A4			; ^noms
	PUSH.32	A3			; ^fichier output/canal XFOS
	PUSH.32	D4
	PUSH.32	D3
	PUSH.32	D2
	PUSH.32	#PPS_OPEN_CMD

	MOVE.32	#MTYPCP,D1
	MOVE.32	#LGCAN,D4
	GESMEM	?GETMEM			; mmoire pour le canal intermdiaire
	JUMP,NE	KILL$

	GESMEM	?CLEARMEM
	MOVE.32	A6,{A4}+OcanVAR

	MOVE.32	SP,A0
	CALL	SEND
	JUMP,EQ	R8^OK$

	PUSH.16	D7
	GESMEM	?GIVMEM
	POP.16	D7

KILL$:	PUSH.16	D7
	CALL	CLOSEcomMEM
	POP.16	D7
	JUMP	R8^ERR$

OK$:	MOVE.32	{A0}+2,{A4}+OcanPPS
	MOVE.32	A4,A2

ERR$:	MOVE.32	#{SP}+8*4,SP

EXIT$:	POPM.32	D1|D2|D4|A0|A1|A3|A4|A6
	TEST.16	D7
	RET



;------------\\
;  PPS_CLOSE  >
;============/

; Fin d'une impression PostScript. Termine le document.

; in	A2.32	canal PostScript
; out	D7.16	erreur
; mod	D7.16

_PPS_CLOSE:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_CLOSE_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	CALL	CLOSEcomMEM

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;-----------\\
;  PPS_PAGE  >
;===========/

; Fin de la page courante ou commande tendue INITPAGE !

; in	A2.32	canal PostScript
;	D4.32	nombre de copies (en principe 1)
; OU :
; in	A2.32	canal PostScript
;	D2.32	mode
;		 #2**BPPSpROT, tourne de 90 degrs le contenu de la page
;		 #2**BPPSpPAGEMODE, trait(ill)s compatibles avec PAGE
;		 #2**BPPSpSCREEN, change la dfinition de la trame PostScript
;		 #2**BPPSpNGLYPH, active la nouvelle interface de DRGLYPH
;	D3.32	chelle [y;x] (facteur 1000 => 1:1)
;	D4.32	#0
;	D5.32	grossissement de trame (1..n) si D2:#BPPSpSCREEN
;	D6.32	angle de trame [deg] si D2:#BPPSpSCREEN
; ET :
; out	D7.16	erreur
; mod	D7.16

_PPS_PAGE:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D6
	PUSH.32	D5
	PUSH.32	D3
	PUSH.32	D2
	PUSH.32	D4
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_PAGE_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;--------------\\
;  PPS_INITPEN  >
;==============/

; Initialise un pinceau.

; in	A2.32	canal PostScript
;	A4.32	^dfinition du pinceau
;	D4.32	numro du pinceau (0..39)
; out	D7.16	erreur
; mod	D7.16

_PPS_INITPEN:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D4
	PUSH.32	A4
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_INITPEN_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;----------------\\
;  PPS_INITTRAME  >
;================/

; Initialise une trame.

; in	A2.32	canal PostScript
;	A4.32	^dfinition de la trame
;	D4.32	numro de la trame (0..39)
; out	D7.16	erreur
; mod	D7.16

_PPS_INITTRAME:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D4
	PUSH.32	A4
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_INITTRAME_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;----------------\\
;  PPS_INITCOLOR  >
;================/

; Initialise une couleur.

; in	A2.32	canal PostScript
;	A4.32	^dfinition de la couleur
;	D4.32	numro de la couleur (0..39)
; out	D7.16	erreur
; mod	D7.16

_PPS_INITCOLOR:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D4
	PUSH.32	A4
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_INITCOLOR_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;-------------\\
;  PPS_DRLINE  >
;=============/

; Impression d'une ligne droite.

; in	A2.32	canal PostScript
;	D3.32	dpart [y;x]		[obj]
;	D4.32	arrive [y;x]		[obj]
;	D2.32	numro du pinceau (0..39)
; out	D7.16	erreur
; mod	D7.16

_PPS_DRLINE:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D2
	PUSH.32	D4
	PUSH.32	D3
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRLINE_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;---------------\\
;  PPS_DRBEZIER  >
;===============/

; Impression d'une courbe de Bzier.

; in	A2.32	canal PostScript
;	D3.32	P1 [y;x]		[obj]
;	D4.32	C1 [y;x]		[obj]
;	D5.32	C2 [y;x]		[obj]
;	D6.32	P2 [y;x]		[obj]
;	D2.32	numro du pinceau (0..39)
; out	D7.16	erreur
; mod	D7.16

_PPS_DRBEZIER:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D2
	PUSH.32	D6
	PUSH.32	D5
	PUSH.32	D4
	PUSH.32	D3
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRBEZIER_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;-----------------\\
;  PPS_DRPOLYOPEN  >
;=================/

; Dbut de dfinition d'un polygone rempli.

; in	A2.32	canal PostScript
; out	D7.16	erreur
; mod	D7.16

_PPS_DRPOLYOPEN:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRPOLYOPEN_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;-----------------\\
;  PPS_DRPOLYLINE  >
;=================/

; Dfinition d'une droite supplmentaire pour un
; polygone rempli.

; in	A2.32	canal PostScript
;	D3.32	dpart [y;x]		[obj]
;	D4.32	arrive [y;x]		[obj]
; out	D7.16	erreur
; mod	D7.16

_PPS_DRPOLYLINE:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D4
	PUSH.32	D3
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRPOLYLINE_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;-------------------\\
;  PPS_DRPOLYBEZIER  >
;===================/

; Dfinition d'une courbe de Bzier supplmentaire
; pour un polygone rempli.

; in	A2.32	canal PostScript
;	D3.32	P1 [y;x]		[obj]
;	D4.32	C1 [y;x]		[obj]
;	D5.32	C2 [y;x]		[obj]
;	D6.32	P2 [y;x]		[obj]
; out	D7.16	erreur
; mod	D7.16

_PPS_DRPOLYBEZIER:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D6
	PUSH.32	D5
	PUSH.32	D4
	PUSH.32	D3
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRPOLYBEZIER_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;------------------\\
;  PPS_DRPOLYCLOSE  >
;==================/

; Impression d'un polygone rempli.

; in	A2.32	canal PostScript
;	D2.8	numro de la trame (0..39)
;	D2.32	mode
;		 #2**BPPSBBOX, spcifie la bbox dans D3/D4
;	D3.32	P1 [y;x] sommet/gauche bbox (si D2:#BPPSBBOX)	[obj]
;	D4.32	P2 [y;x] infrieur/droit bbox (si D2:#BPPSBBOX)	[obj]
; out	D7.16	erreur
; mod	D7.16

_PPS_DRPOLYCLOSE:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	D4
	PUSH.32	D3
	PUSH.32	D2
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRPOLYCLOSE_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;--------------\\
;  PPS_DRGLYPH  >
;==============/

; Imprime une image monochrome transparente (un caractre, par
; exemple) en utilisant un cache interne. Les `id' passs sont
; des valeurs quelconques utilises comme clef pour le mcanisme
; de cache d'impression.
;
; ATTENTION:	Il faut que "dx := 8 * largeur en bytes" pour
;		assurer un fonctionnement correct.

; in	A2.32	canal PostScript
;	D2.32	[couleur;largeur en bytes]
;	D3.32	position du sommet [y;x]	[obj]
;	D4.32	taille de l'image [dy;dx]	[pix]
;	D5.32	id de la famille de l'image
;	D6.32	id de l'image dans la famille considre
;	A4.32	^image monochrome
;	A3.32	^record de desc. de glyphe
; out	D7.16	erreur
; mod	D7.16

_PPS_DRGLYPH:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	A3
	PUSH.32	A4
	PUSH.32	D6
	PUSH.32	D5
	PUSH.32	D4
	PUSH.32	D3
	PUSH.32	D2
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRGLYPH_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;------------------\\
;  PPS_DRMONOIMAGE  >
;==================/

; Imprime une image monochrome transparente. Fonctionne de faon
; similaire  DRGLYPH, mais sans le mcanisme de cache.

; in	A2.32	canal PostScript
;	D2.32	[couleur;largeur en bytes]
;	D3.32	position du sommet P1 [y;x]	[obj]
;	D4.32	position du sommet P2 [y;x]	[obj]
;	D5.32	taille de l'image [dy;dx]	[pix]
;	D6.32	angle de rotation frac.		[deg]
;	A4.32	^image monochrome
; out	D7.16	erreur
; mod	D7.16

_PPS_DRMONOIMAGE:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	A4
	PUSH.32	D6
	PUSH.32	D5
	PUSH.32	D4
	PUSH.32	D3
	PUSH.32	D2
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRMONOIMAGE_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET



;-------------------\\
;  PPS_DRCOLORIMAGE  >
;===================/

; Imprime une image couleur opaque de n bit/pixel. Les cas
; suivants sont traits  l'heure actuelle :
;
; n=1	image monochrome opaque
; n=4	image avec CLUT usuelle (comme .COLOR)
; n=24	image au format ..<r><g><b><r><g><b>..
; n=32	image au format ..<ignor><r><g><b><ignor><r><g><b>..

; in	A2.32	canal PostScript
;	D2.32	[bit/pixel;largeur en bytes]
;	D3.32	position du sommet P1 [y;x]	[obj]
;	D4.32	position du sommet P2 [y;x]	[obj]
;	D5.32	taille de l'image [dy;dx]	[pix]
;	D6.32	angle de rotation frac.		[deg]
;	A3.32	^CLUT (si n=4)
;	A4.32	^image couleur 32 bit/pixel
; out	D7.16	erreur
; mod	D7.16

_PPS_DRCOLORIMAGE:
	PUSHM.32 A0|A1|A6

	MOVE.32	SP,A1

	PUSH.32	A4
	PUSH.32	A3
	PUSH.32	D6
	PUSH.32	D5
	PUSH.32	D4
	PUSH.32	D3
	PUSH.32	D2
	MOVE.32	{A2}+OcanVAR,A6
	PUSH.32	{A2}+OcanPPS
	PUSH.32	#PPS_DRCOLORIMAGE_CMD

	MOVE.32	SP,A0
	CALL	SEND

	MOVE.32	A1,SP

	POPM.32	A0|A1|A6
	TEST.16	D7
	RET




;-------------\\
;  OPENcomMEM  >
;=============/

; Retourne un pointeur aux variables globales. Lance le programme
; SMA_PSDRIV.CODE s'il n'est pas encore en excution.

; in	-
; out	A6.32	^variables globales
;	D7.16	erreur
; mod	A6.32, D7.16

OPENcomMEM:
	PUSHM.32 D3|D4|A3|A4|A5

	MOVE.32	#R16^BASE,A4
	MOVE.32	#LGVAR+2**31,D4
	FOS	?GETcomMEM
	JUMP,NE	ERR$

	NTREL	?LOCK			; verrouille l'accs aux variables
	JUMP,NE	ERR$

	MOVE.32	A4,A6
	MOVE.32	A5,{A6}+OvarSEM

	TEST.8	{A6}+OvarINI		; initialis ?
	JUMP,T	R8^INIT$		; oui => rien de plus

	MOVE.32	#0,D4
	MOVE.32	#R16^NMBAR,A3
	NTREL	?CREBAR			; cre le BAR  rendez-vous
	JUMP,EQ	R8^NEW$			; ok => nouveau, pas de SMA_PSDRIV en fonction

	MOVE.32	A5,{A6}+OvarBAR

	COMP.16	#ERBARE,D7		; BAR existe dj ?
	JUMP,EQ	R8^INIT$		; oui => c'est tout bon
	JUMP	R8^EXIT$		; non => erreur

; Excute SMA_PSDRIV.CODE ... lequel se chargera d'utiliser la bote 
; rendez-vous...

NEW$:	MOVE.32	A5,{A6}+OvarBAR		; mmorise BAR

	MOVE.32	#R16^NMPSD,A3
	SUB.32	A5,A5
	MOVE.32	#2**BEXONLYONE+2**BEXSNORM+1,D4
	FOS	?NEXECUTE		; excution normale sans prendre le clavier (max. 1 fois)
	JUMP,NE	R8^EXIT$		; erreur => aie !

INIT$:	INC.32	{A6}+OvarCOUNT		; 1 de plus !
	SET.8	{A6}+OvarINI		; ok, initialis
	CLR.16	D7

EXIT$:	PUSH.16	D7
	MOVE.32	{A6}+OvarSEM,A5
	NTREL	?UNLOCK
	POP.16	D7

ERR$:	POPM.32	D3|D4|A3|A4|A5
	TEST.16	D7
	RET




;--------------\\
;  CLOSEcomMEM  >
;==============/

; Libre la mmoire commune. Ne dtruit pas le BAR, car
; c'est en fait au programme PSDRIV de le faire. Si on
; se rend compte que PSDRIV n'existe plus (?) on le fait
; quand-mme.

; in	A6.32	^variables globales
; out	-
; mod	D7.16

CLOSEcomMEM:
	PUSHM.32 D4|A4|A5

	CLR.16	D7
	TEST.8	{A6}+OvarINI
	JUMP,F	ERR$

	MOVE.32	{A6}+OvarSEM,A5
	NTREL	?LOCK
	JUMP,NE	ERR$

	DEC.32	{A6}+OvarCOUNT		; encore utilis ?
	JUMP,NE	R8^EXIT$		; oui => ne fait rien

	MOVE.32	#WAITKILLDEL*50,D4
	NTREL	?MODTIM			; attente maximum

	MOVE.32	{A6}+OvarBAR,A5
	NTREL	?OFFERBAR		; y a-t-il quelqu'un ?
	JUMP,NE	NOBODY$			; non => tue le BAR

	PUSH.32	#PPS_ABORT_CMD
	MOVE.32	SP,A4
	NTREL	?ENDOFFERBAR		; dialogue synchrone pour dire que c'est fini
	ADD.A16	#4,SP
	JUMP	R8^END$

NOBODY$:
	NTREL	?KILLBAR		; tue le bar (a peut faire mal !!!)

END$:	NTREL	?SETTIM
	CLR.8	{A6}+OvarINI		; plus initialis du tout

EXIT$:	MOVE.32	{A6}+OvarSEM,A5
	NTREL	?UNLOCK

ERR$:	POPM.32	D4|A4|A5
	TEST.16	D7
	RET



;-------\\
;  SEND  >
;=======/

; Envoie un message de faon synchrone. Il s'agit l d'un
; dialogue, en fait.

; in	A0.32	^message
;	A6.32	^variables globales
; out	A0.32	^rponse
;	D7.16	ok/erreur
; mod	A0.32, D7.16

SEND:
	PUSHM.32 D4|A4|A5

	MOVE.32	#-1,D4
	NTREL	?MODTIM			; transaction avec time-out infini !

	MOVE.32	{A6}+OvarBAR,A5
	NTREL	?OFFERBAR
	JUMP,NE	R8^ERR$
	MOVE.32	A0,A4
	NTREL	?ENDOFFERBAR
	JUMP,NE	R8^ERR$

	MOVE.32	A4,A0
	MOVE.16	{A0},D7

ERR$:	PUSH.16	D7
	NTREL	?SETTIM
	POP.16	D7
	POPM.32	D4|A4|A5
;	TEST.16	D7
	RET


;--------------\\
;  PPS_CONTROL  >
;==============/

; Contrle le fonctionnement de la librairie.

; in	D0.16	opration
;		 #PPS_CACHE, cache & dmarre SMA_PSDRIV.CODE
;		 #PPS_UNCACHE, libre SMA_PSDRIV.CODE
; out	D7.16	erreur
; mod	D7.16

_PPS_CONTROL:
	PUSHM.32 D4|A4|A6

	COMP.16	#PPS_CACHE,D0
	JUMP,EQ	CACHE$

	COMP.16	#PPS_UNCACHE,D0
	JUMP,EQ	UNCACHE$

	MOVE.16	#1,D7
	JUMP	ERR$

CACHE$:	CALL	OPENcomMEM		; charge SMA_PSDRIV.CODE si ce n'est pas dj le cas
	JUMP,NE	ERR$

	INC.32	{A6}+OvarCACHE		; un cache de plus
	JUMP	ERR$

UNCACHE$:
	MOVE.32	#R16^BASE,A4
	MOVE.32	#LGVAR+2**31,D4
	FOS	?GETcomMEM		; A4 <-- ^mmoire commune
	JUMP,NE	ERR$

	MOVE.16	#1,D7

	TEST.32	{A6}+OvarCACHE		; peut-on dcacher ?
	JUMP,F	ERR$			; non => erreur

	DEC.32	{A6}+OvarCACHE		; un cache de moins

	MOVE.32	A4,A6
	CALL	CLOSEcomMEM		; libre la mmoire une fois pour le CACHE

ERR$:	POPM.32	D4|A4|A6
	TEST.16	D7
	RET


NMPSD:	.ASCII	"sma_psdriv -bar "
NMBAR:	.ASCIZ	"#:psdriv_rq"
NMPAGE:	.ASCIZ	"page.code"
CPTERM:	.8	0,CR,-1
	.EVEN

END_MODULE:
	.END
