/*
 *	pageps.cc
 *
 *	Classe permettant de transformer des requtes de Page en
 *	un fichier PostScript.
 *
 *	(C) Copyright 1993-1999,  Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
 */


extern "C" {
#include <stdio.h>
}

#include "page-struct.h"


PagePS::PagePS ()
{
    output = 0;
    failure = FALSE;
    dash.pos = dash.num = dash.len = 0;
    dash.pen = -1;
    is_color = FALSE;		// par dfaut pas en couleur
    page_mode = FALSE;		// par dfaut pas de traits compatibles avec PAGE
    new_glyph_mode = FALSE;	// par dfaut pas de glyphes "modernes"
    is_no_multi = FALSE;	// permet plus d'une page par feuille par dfaut
    stroke_adjust = TRUE;	// par dfaut enclenche "strokeadjust"
    last_dash_pen = -1;
    null_dash = TRUE;
    dash_pos = 0.0;
    last_dash_pos = 0.0;
    page_count = 0;
    def_num = 0;
    screen_mul = 0;
    screen_angle = 45;
    scale_page_x = 1.0;
    scale_page_y = 1.0;
    turn_page = FALSE;
    glyph_font_ok = FALSE;
    glyph_font_cache = 0;
}

PagePS::~PagePS ()
{
    if (output) {
        
        char buffer[128];
        
        if ( ((page_count & 1) == 0) && (is_multi_ok) ) {
            
            // On a commenc une page paire, mais elle est vide.
            // Il faut tout de mme l'imprimer !
            
            int num = def_num ? : 1;
            
            sprintf (buffer, "/#copies %d def showpage\n", num);
            output->Write (buffer);
            
            real_page_count++;
            
            output->Write ("%%PageTrailer\n"
				           "restore grestore\n"
				           "%%Trailer\n");
        }
        
        sprintf (buffer, "%%%%Pages: %d\n", real_page_count - 1);
        output->Write (buffer);
        output->Write ("restore\n");
        output->Write ("%ColorHint: ");
        output->Write (output->IsColorUsed () ? "color\n" : "mono\n");
        output->Write ("%%EOF\n");
		delete output;
		output = 0;
    }
    
    this->KillFontCache ();
}

void
PagePS::InitPenDesc (const PenDesc* desc, int i)
{
    if ((i >= 0) && (i < MAXPEN)) pen[i] = *desc;
}

void
PagePS::InitTrameDesc (const TrameDesc* desc, int i)
{
    if ((i >= 0) && (i < MAXTRAME)) trame[i] = *desc;
}

void
PagePS::InitColorDesc (const ColorDesc* desc, int i)
{
    if ((i >= 0) && (i < MAXCOLOR)) color[i] = *desc;
}

