
/*
 *		pps.h
 *
 *		Dfinition des messages qui peuvent tre envoys au
 *		serveur PPS.
 *
 *		(C) 1993,  Pierre ARNAUD, CH-1437 SUSCEVAZ
 */

#ifndef _PPS_H_
#define _PPS_H_

typedef struct PPS_AnswerRec {
	short		error;					/* erreur								*/
} *PPS_Answer;


typedef struct PPS_OpenRec {
	int			command;				/* commande OPEN						*/
	long		mode;					/* mode d'ouverture						*/
	short		dpi_y, dpi_x;			/* rsolution					  [dpi] */
	short		dy, dx;					/* dimensions de la page		  [obj] */
	const char*	ps_file_name;			/* nom du fichier						*/
	const char*	about;					/* "doc<0>auteur<0>dest<0>date<0><0>"	*/
	const char*	epsf;					/* "nom<0>nom<0>..<0>nom<0><0>"			*/
	const char*	rules;					/* rgles/rglages PostScript			*/
} *PPS_Open;

typedef struct PPS_OpenAnswerRec {
	short		error;					/* erreur								*/
	void*		channel;				/* canal PPS							*/
} *PPS_OpenAnswer;


typedef struct PPS_CloseRec {
	int			command;				/* commande CLOSE						*/
	void*		channel;				/* canal PPS							*/
} *PPS_Close;


typedef struct PPS_PageRec {
	int			command;				/* commande PAGE						*/
	void*		channel;				/* canal PPS							*/
	int			num_pages;				/* nombre de pages						*/
} *PPS_Page;


typedef struct PPS_InitPageRec {
	int			command;				/* commande PAGE						*/
	void*		channel;				/* canal PPS							*/
	int			reserved;				/* rserv --- toujours 0				*/
	int			mode;					/* mode									*/
	short		scale_y, scale_x;		/* chelle pour la page (1000 => 1:1)	*/
	long		screen_mul;				/* facteur multiplicatif de la trame	*/
	long		screen_angle;			/* angle de la trame [deg]				*/
} *PPS_InitPage;


typedef struct PPS_InitPenRec {
	int			command;				/* commande INITPEN						*/
	void*		channel;				/* canal PPS							*/
	PenDesc*	pen;					/* description du pinceau				*/
	int			num;					/* numro du pinceau					*/
} *PPS_InitPen;


typedef struct PPS_InitTrameRec {
	int			command;				/* commande INITTRAME					*/
	void*		channel;				/* canal PPS							*/
	TrameDesc*	trame;					/* description de la trame				*/
	int			num;					/* numro de la trame					*/
} *PPS_InitTrame;


typedef struct PPS_InitColorRec {
	int			command;				/* commande INITCOLOR					*/
	void*		channel;				/* canal PPS							*/
	ColorDesc*	color;					/* description de la couleur			*/
	int			num;					/* numro de la couleur					*/
} *PPS_InitColor;


typedef struct PPS_DrLineRec {
	int			command;				/* commande DRLINE						*/
	void*		channel;				/* canal PPS							*/
	short		p1y, p1x;				/* point de dpart				  [obj] */
	short		p2y, p2x;				/* point d'arrive				  [obj] */
	int			pen;					/* pinceau								*/
} *PPS_DrLine;


typedef struct PPS_DrBezierRec {
	int			command;				/* commande DRBEZIER					*/
	void*		channel;				/* canal PPS							*/
	short		p1y, p1x;				/* point de dpart				  [obj] */
	short		c1y, c1x;				/* point de contrle 1			  [obj] */
	short		c2y, c2x;				/* point de contrle 2			  [obj] */
	short		p2y, p2x;				/* point d'arrive				  [obj] */
	int			pen;					/* pinceau								*/
} *PPS_DrBezier;


typedef struct PPS_PolyOpenRec {
	int			command;				/* commande POLYOPEN					*/
	void*		channel;				/* canal PPS							*/
} *PPS_PolyOpen;


typedef struct PPS_PolyLineRec {
	int			command;				/* commande POLYLINE					*/
	void*		channel;				/* canal PPS							*/
	short		p1y, p1x;				/* point de dpart				  [obj] */
	short		p2y, p2x;				/* point d'arrive				  [obj] */
} *PPS_PolyLine;


typedef struct PPS_PolyBezierRec {
	int			command;				/* commande POLYBEZIER					*/
	void*		channel;				/* canal PPS							*/
	short		p1y, p1x;				/* point de dpart				  [obj] */
	short		c1y, c1x;				/* point de contrle 1			  [obj] */
	short		c2y, c2x;				/* point de contrle 2			  [obj] */
	short		p2y, p2x;				/* point d'arrive				  [obj] */
} *PPS_PolyBezier;


typedef struct PPS_PolyCloseRec {
	int			command;				/* commande POLYCLOSE					*/
	void*		channel;				/* canal PPS							*/
	int			trame;					/* trame								*/
	short		y1, x1;					/* bbox: sommet gauche			  [obj] */
	short		y2, x2;					/* bbox: infrieur droit		  [obj] */
} *PPS_PolyClose;


typedef struct PPS_DrGlyphRec {
	int			command;				/* commande DRGLYPH						*/
	void*		channel;				/* canal PPS							*/
	short		color;					/* couleur								*/
	short		width;					/* largeur en bytes						*/
	short		y, x;					/* sommet suprieur gauche		  [obj] */
	short		dy, dx;					/* dimensions en pixels			  [pix] */
	long		id_1;					/* id. de la famille					*/
	long		id_2;					/* id. de l'image dans la famille		*/
	void*		image;					/* image monochrome						*/
	void*		glyph;					/* glyph info (record)					*/
} *PPS_DrGlyph;


typedef struct PPS_DrMonoImageRec {
	int			command;				/* commande DRMONOIMAGE					*/
	void*		channel;				/* canal PPS							*/
	short		color;					/* couleur								*/
	short		width;					/* largeur en bytes						*/
	short		p1y, p1x;				/* sommet suprieur gauche		  [obj] */
	short		p2y, p2x;				/* sommet infrieur droite		  [obj] */
	short		dy, dx;					/* dimensions en pixels			  [pix] */
	long		angle;					/* angle de rotation frac.		  [deg] */
	void*		image;					/* image monochrome						*/
} *PPS_DrMonoImage;


typedef struct PPS_DrColorImageRec {
	int			command;				/* commande DRCOLORIMAGE				*/
	void*		channel;				/* canal PPS							*/
	short		depth;					/* bit/pixel							*/
	short		width;					/* largeur en bytes						*/
	short		p1y, p1x;				/* sommet suprieur gauche		  [obj] */
	short		p2y, p2x;				/* sommet infrieur droite		  [obj] */
	short		dy, dx;					/* dimensions en pixels			  [pix] */
	long		angle;					/* angle de rotation frac.		  [deg] */
	void*		clut;					/* CLUT si depth = 4					*/
	void*		image;					/* image couleur en n bit/pixel			*/
} *PPS_DrColorImage;


#endif

