/*
 *	psdriv.cc
 *
 *	Le programme SMA_PSDRIV.CODE est un serveur synchrone
 *	s'occupant de la traduction de requtes PAGE en code
 *	compatible PostScript.
 *
 *	(C) Copyright 1993-1999,  Pierre ARNAUD et EPSITEC-system SA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <c++/fos.h>

#include "page-struct.h"
#include "pps.h"
#include "ntrelbar.h"
#include "ppslibrary.h"

// Dfinitions pour l'en-tte du binaire

unsigned long _stksize  = 10*1024;				// pile
unsigned long _SMASOVER = 1;					// utilise entre OVERLAY de prfrence
unsigned char _SMAPRIO  = 11;					// priorit leve (utilise que pour l'init.)
unsigned char _SMAREV   = 6;					// rvision
unsigned char _SMAVER   = 4;					// version
unsigned long _SMAUNIT  = 0x00000000;			// 0x000000A0 => binaire GNU (no cache)
unsigned short _SMADIS[] = {20, 600, 20, 500};	// petite fentre
char _SMAIDE[] = "(C) Copyright 1993-1999, Pierre ARNAUD, OPaC bright ideas";

extern Bool debug;

Bool   debug = FALSE;
static Card16 ch_out = 0;
static Card16 ch_err = 0;
static const Card32 mode_pipe = FOS_OPEN_WRITE|FOS_OPEN_EXTEND|FOS_OPEN_APPEND|FOS_OPEN_CREATE;
static const Card32 mode_disp = FOS_OPEN_WRITE;

enum ReportType
{
    REPORT_ERROR,
    REPORT_DEBUG,
    REPORT_INFO
};


Card16
NtrelModTim (Card16 timeout)
{
	Card16 oldtimeout;
	
	asm ( "movew %1,d4		\n\t"
		  ".long 0x4E44005A	\n\t"
		  "movew d4,%0		\n\t"
		: "=g" (oldtimeout)
		: "g" (timeout)
		: "d4", "d7" );
	
	return oldtimeout;
}

/*
 *  Envoie un message d'informations  l'application prvue  cet
 *  effet (pour autant qu'elle existe).
 */

void
report_msg (ReportType type, const char* msg, Card32 job = 0)
{
	char   buffer[500];
	Card32 size = 0;
	
    switch (type) {
        
        case REPORT_ERROR:
            if (ch_err) {
            	sprintf (buffer, "PsDriv:[%d] %s\n", job, msg);
            	size = strlen (buffer);
            	FOS::Write (ch_err, size, buffer);
            }
            break;
        
        case REPORT_DEBUG:
        case REPORT_INFO:
            if (ch_out) {
            	sprintf (buffer, "PsDriv:[%d] %s\n", job, msg);
            	size = strlen (buffer);
            	FOS::Write (ch_out, size, buffer);
            }
            break;
    }
}



// Variables globales

NtrelBar bar;

enum PpsCmd {
    CMD_ABORT = -1,
    CMD_OPEN = 0,
    CMD_CLOSE = 1,
    CMD_PAGE = 2,
    CMD_INITPEN = 3,
    CMD_INITTRAME = 4,
    CMD_INITCOLOR = 5,
    CMD_DRLINE = 6,
    CMD_DRBEZIER = 7,
    CMD_DRPOLYOPEN = 8,
    CMD_DRPOLYLINE = 9,
    CMD_DRPOLYBEZIER = 10,
    CMD_DRPOLYCLOSE = 11,
    CMD_DRGLYPH = 12,
    CMD_DRMONOIMAGE = 13,
    CMD_DRCOLORIMAGE = 14,
};


static Bool
ServerLoop ()
{
    void* cmd;
    int error;
    Bool ok;
    
    Card16 otim = NtrelModTim (0xFFFF);
    
    int count = 0;
    int id = 0;
    int last_count = 0;
    int last_id = 0;
    int page_count = 0;
    
    ok = TRUE;
    
    while (ok) {
	NtrelModTim (0xFFFF);
        error = NtrelAcceptBar (bar, &cmd);
        
        if (error) {
            char buffer[100];
            sprintf (buffer, "ACCEPT: %s", strerror (error));
            report_msg (REPORT_ERROR, buffer);
            break;
        }
        
        if (debug) {
            char buffer[100];
            const char* cmd_act = "?";
            const char* cmd_names[] = {
                "ABORT", "OPEN", "CLOSE", "PAGE", "INITPEN", "INITTRAME", "INITCOLOR",
                "DRLINE", "DRBEZIER", "DRPOLYOPEN", "DRPOLYLINE", "DRPOLYBEZIER", "DRPOLYCLOSE",
                "DRGLYPH", "DRMONOIMAGE", "DRCOLORIMAGE", 0 };
            
            int num = *((PpsCmd*)(cmd)) + 1;
            
            if (num < (CMD_DRCOLORIMAGE+2)) cmd_act = cmd_names[num];
            sprintf (buffer, "[%s]", cmd_act);
            report_msg (REPORT_DEBUG, buffer);
        }
        
        switch (*((PpsCmd*)(cmd))) {
            case CMD_ABORT:
                NtrelEndAcceptBar (bar, 0);
                return TRUE;
            
            case CMD_OPEN:
                {
                    char buffer[200];
                    PPS_Open arg = (PPS_Open) cmd;
                    PagePS* pps = 0;
                    PPS_OpenAnswerRec ans;
                    
                    sprintf (buffer, "Cre `%s' (info=`%s'/mode=%04x)",
                    	     (arg->mode & 0x40) ? "XFOS" : arg->ps_file_name,
                             arg->about, arg->mode);
                    report_msg (REPORT_INFO, buffer, ++id);
                    
                    if ((arg->mode & 0x07) == 0) arg->mode |= 0x01; /* bug PRINTA, 9 sept.93 */
                    
                    ans.error = PagePS_Open (arg->mode, arg->dpi_x, arg->dpi_y,
		                    			     arg->dx, arg->dy, arg->ps_file_name,
		                    			     arg->about, arg->epsf, arg->rules, &pps);
                    
                    ans.channel = pps;
                    
                    if (pps) {
                        
                        pps->id = id;
                        pps->count = 0;
                        
                    } else {
                        
                        // Pas pu instancier PagePS...
                        
                        sprintf (buffer, "Erreur interne=%04x", (unsigned short)(ans.error));
                        report_msg (REPORT_ERROR, buffer, id);
                    }
                    
                    error = NtrelEndAcceptBar (bar, &ans);
                    page_count = 1;
                }
                
                break;
            
            case CMD_CLOSE:
                {
                    char buffer[100];
                    PPS_Close arg = (PPS_Close) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    sprintf (buffer, "Termin, %d page(s)",
                             pps->page_count-1);
                    report_msg (REPORT_INFO, buffer, pps->id);
                    
                    ans.error = PagePS_Close (pps);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_PAGE:
                {
                    PPS_Page arg = (PPS_Page) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    if (arg->num_pages == -1) {
                        PPS_InitPage ini = (PPS_InitPage)(cmd);
                        
                        ans.error = PagePS_InitPage (pps, ini->mode, ini->scale_x, ini->scale_y,
                        			     ini->screen_mul, ini->screen_angle);
                    } else {
                        char buffer[100];
                        sprintf (buffer, "Emet page %d",
                                 pps->page_count);
                        report_msg (REPORT_INFO, buffer, pps->id);
	                ans.error = PagePS_Page (pps, arg->num_pages);
                    }
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_INITPEN:
                {
                    PPS_InitPen arg = (PPS_InitPen) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    ans.error = PagePS_InitPen (pps, arg->pen, arg->num);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_INITTRAME:
                {
                    PPS_InitTrame arg = (PPS_InitTrame) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    ans.error = PagePS_InitTrame (pps, arg->trame, arg->num);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_INITCOLOR:
                {
                    PPS_InitColor arg = (PPS_InitColor) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    ans.error = PagePS_InitColor (pps, arg->color, arg->num);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRLINE:
                {
                    PPS_DrLine arg = (PPS_DrLine) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    ans.error = PagePS_DrLine (pps, arg->p1x, arg->p1y,
                    			       arg->p2x, arg->p2y, arg->pen);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRBEZIER:
                {
                    PPS_DrBezier arg = (PPS_DrBezier) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    ans.error = PagePS_DrBezier (pps, arg->p1x, arg->p1y,
                    			         arg->c1x, arg->c1y, arg->c2x, arg->c2y,
                    			         arg->p2x, arg->p2y, arg->pen);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRPOLYOPEN:
                {
                    PPS_PolyOpen arg = (PPS_PolyOpen) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    ans.error = PagePS_DrPolyOpen (pps);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRPOLYLINE:
                {
                    PPS_PolyLine arg = (PPS_PolyLine) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    ans.error = PagePS_DrPolyLine (pps, arg->p1x, arg->p1y,
                    				   arg->p2x, arg->p2y);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRPOLYBEZIER:
                {
                    PPS_PolyBezier arg = (PPS_PolyBezier) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    ans.error = PagePS_DrPolyBezier (pps, arg->p1x, arg->p1y,
                    				     arg->c1x, arg->c1y, arg->c2x, arg->c2y,
                    				     arg->p2x, arg->p2y);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRPOLYCLOSE:
                {
                    PPS_PolyClose arg = (PPS_PolyClose) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    ans.error = PagePS_DrPolyClose (pps, arg->trame, arg->x1, arg->y1, arg->x2, arg->y2);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRGLYPH:
                {
                    PPS_DrGlyph arg = (PPS_DrGlyph) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    ans.error = PagePS_DrGlyph (pps, arg->x, arg->y,
                    				arg->dx, arg->dy, arg->color, arg->width,
                    				arg->id_1, arg->id_2, arg->image, arg->glyph);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRMONOIMAGE:
                {
                    char buffer[150];
                    PPS_DrMonoImage arg = (PPS_DrMonoImage) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    if (debug) {
                        sprintf (buffer, "(w=%d/dx=%d/dy=%d)", arg->width,
                                 arg->dx, arg->dy);
                        report_msg (REPORT_DEBUG, buffer, pps->id);
                    }
                    
                    ans.error = PagePS_DrMonoImage (pps, arg->p1x, arg->p1y,
                    				    arg->p2x, arg->p2y, arg->dx, arg->dy,
                    				    arg->angle, arg->color, arg->width, arg->image);
                    
                    if (debug) {
                    	sprintf (buffer, "ans.error=%d", ans.error);
                    	report_msg (REPORT_DEBUG, buffer);
                    }
                    
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            case CMD_DRCOLORIMAGE:
                {
                    char buffer[150];
                    PPS_DrColorImage arg = (PPS_DrColorImage) cmd;
                    PPS_AnswerRec ans;
                    PagePS* pps = (PagePS*)(arg->channel);
                    page_count = pps->page_count;
                    
                    last_id = pps->id;
                    last_count = pps->count++;
                    count++;
                    
                    if (debug) {
                        sprintf (buffer, "(d=%d/w=%d/dx=%d/dy=%d)",
                                 arg->depth, arg->width,
                                 arg->dx, arg->dy);
                        report_msg (REPORT_DEBUG, buffer, last_id);
                    }
                    
                    ans.error = PagePS_DrColorImage (pps, arg->depth,
                    			arg->width, arg->p1x, arg->p1y,
                    			arg->p2x, arg->p2y,
                    			arg->dx, arg->dy,
                    			arg->angle, arg->clut,
                    			arg->image);
                    error = NtrelEndAcceptBar (bar, &ans);
                }
                
                break;
            
            default:
                {
                    char buffer[150];
                    sprintf (buffer, "Commande inconnue : %d", *((PpsCmd*)(cmd)));
                    report_msg (REPORT_ERROR, buffer, last_id);
                }
                break;
        }
        
        if (count > 32) {
           char buffer[100];
           count = 0;
           sprintf (buffer, "Page %d, %d obj.", page_count, last_count);
           report_msg (REPORT_INFO, buffer, last_id);
        }
    }
    
    NtrelModTim (otim);
    
    return FALSE;
}

extern Bool g_smart_text;


// Programme principal

int
main (int argc, char** argv)
{
	int err;
	
	err = 1;
	if (err) err = FOS::Open ("#PPS_STDOUT", mode_pipe, ch_out);
	if (err) err = FOS::Open ("#DISPLAY", mode_disp, ch_out);
	if (err) ch_out = 0;
	
	err = 1;
	if (err) err = FOS::Open ("#PPS_STDERR", mode_pipe, ch_err);
	if (err) err = FOS::Open ("#DISPLAY", mode_disp, ch_err);
	if (err) ch_err = 0;
	
    if (getenv ("PPS_DEBUG"))    debug = TRUE;
    if (getenv ("PPS_SLOWTEXT")) g_smart_text = FALSE;
    
    if ( (argc != 3)
      || (strcmp ("-bar", argv[1])) ) {
        
        // pas lanc par le module de librairie => signale erreur
        
        char buffer[200];
        sprintf (buffer, "Dsol, %s ne peut pas tre dmarr manuellement.", argv[0]);
        report_msg (REPORT_ERROR, buffer);
        return 1;
    }
    
    Bool kill_bar;
    
    err = NtrelCreBar (argv[2], &bar);
    
    if ((err != 0) && (err != 0xFFFF8161)) {
        char buffer[200];
        sprintf (buffer, "Problme avec le BAR %s", argv[2]);
        report_msg (REPORT_ERROR, buffer);
        return err;
    }
    
    kill_bar = ServerLoop ();
    
    if (kill_bar) {
        NtrelKillBar (bar);
    }
    
    return 0;
}

