/*
 *	fos.cc
 *	
 *	Interface pour le File Operating System du Smaky.
 *
 *	(C)	 Copyright 1993-1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fos.h"

int
FOS::What (const char* name, Card16& type)
{
	Card16 er;
  	
	asm volatile ( "movel %2,a3\n\t"
  				   ".long 0x4e45005e\n\t"
  				   "movew d3,%0\n\t"
  				   "movew d7,%1"
  				 : "=m" (type), "=g" (er)
  				 : "p" (name)
  				 : "a3", "d3", "d7" );
	
	return er;
}



int
FOS::Open (const char* name, Card32 mode, Card16& can)
{
	Card16 er;
	
	asm volatile ( "movel %2,a3\n\t"
				   "movel %3,d3\n\t"
				   ".long 0x4e45004a\n\t"
				   "movew d6,%0\n\t"
				   "movew d7,%1"
				 : "=m" (can), "=g" (er)
				 : "p" (name), "g" (mode)
				 : "a3", "d3", "d6", "d7" );
	
	return er;
}


#if 0
int
FOS::ArgsOpen (const char* name, Card32 mode, SmakyArgs& args, Card16& can)
{
	Card16 er;
	
	mode |= FOS_OPEN_ARGS;
	
	asm volatile ( "movel %2,a3\n\t"
				   "movel %3,d3\n\t"
				   "movel %4,a4\n\t"
				   ".long 0x4e45004a\n\t"
				   "movew d6,%0\n\t"
				   "movew d7,%1"
				 : "=m" (can), "=g" (er)
				 : "p" (name), "g" (mode), "p" (&args)
				 : "a3", "a4", "d3", "d6", "d7" );
	
	return er;
}
#endif


int
FOS::Close (Card16 can)
{
	Card16 er;
	
	asm volatile ( "movew %1,d6\n\t"
				   ".long 0x4e450005\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (can)
				 : "d6", "d7" );
	
	return er;
}

#if 0
int
FOS::CloseMDC (Card16 can, const SmakyDate& datim)
{
	Card16 er;
	
	Card32 hhmmss = (datim.hour << 16) | (datim.minute << 8) | (datim.second);
	Card32 jjmmaa = (datim.day  << 16) | (datim.month  << 8) | (datim.year);
	
	asm volatile ( "movew %1,d6\n\t"
				   "movel %2,d3\n\t"
				   "movel %3,d4\n\t"
				   ".long 0x4e45002b\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (can), "g" (hhmmss), "g" (jjmmaa)
				 : "d3", "d4", "d6", "d7" );
	
	return er;
}
#endif

int
FOS::Read (Card16 can, Card32& size, void* buffer)
{
	Card16 er;
	
	asm volatile ( "movew %2,d6\n\t"
				   "movel %1,d4\n\t"
				   "movel %3,a4\n\t"
				   ".long 0x4e450001\n\t"
				   "movel d4,%1\n\t"
				   "movew d7,%0\n\t"
				 : "=g" (er), "=g" (size)
				 : "g" (can), "g" (buffer)
				 : "d4", "d6", "d7", "a4" );
	
	return er;
}


int
FOS::Write (Card16 can, Card32& size, const void* buffer)
{
	Card16 er;
	
	asm volatile ( "movew %2,d6\n\t"
				   "movel %1,d4\n\t"
				   "movel %3,a4\n\t"
				   ".long 0x4e450002\n\t"
				   "movel d4,%1\n\t"
				   "movew d7,%0\n\t"
				 : "=g" (er), "=g" (size)
				 : "g" (can), "g" (buffer)
				 : "d4", "d6", "d7", "a4" );
	
	return er;
}


int
FOS::SetPos (Card16 can, Card32 pos)
{
	Card8 high = (pos == 0xFFFFFFFF) ? 0xFF : 0x00;
	Card16 er;
	
	asm volatile ( "moveb %1,d3\n\t"
				   "movel %2,d4\n\t"
				   "movew %3,d6\n\t"
				   ".long 0x4e450004\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (high), "g" (pos), "g" (can)
				 : "d3", "d4", "d6", "d7" );
	
	return er;
}


int
FOS::GetPos (Card16 can, Card32& pos)
{
	Card8 high = 0;
	Card16 er;
	
	asm volatile ( "movew %3,d6\n\t"
				   ".long 0x4e450003\n\t"
				   "movew d7,%0\n\t"
				   "moveb d3,%1\n\t"
				   "movel d4,%2"
				 : "=g" (er), "=g" (high), "=g" (pos)
				 : "g" (can)
				 : "d3", "d4", "d6", "d7" );
	
	if (high) pos = 0xFFFFFFFF;
	
	return er;
}


int
FOS::Trunc (Card16 can)
{
	Card16 er;
	
	asm volatile ( "movew %1,d6\n\t"
				   ".long 0x4e450035\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (can)
				 : "d6", "d7" );
	
	return er;
}


int
FOS::Create (const char* name, Card32 attr)
{
	Card16 er;
  	
	asm volatile ( "moveql #0,d4\n\t"
				   "movel %1,d3\n\t"
				   "movel %2,a3\n\t"
  				   ".long 0x4e450006\n\t"
  				   "movew d7,%0"
  				 : "=g" (er)
  				 : "g" (attr), "p" (name)
  				 : "a3", "d3", "d4", "d7" );
	
	return er;
}


int
FOS::Delete (const char* name)
{
	Card16 er;
  	
	asm volatile ( "movel %1,a3\n\t"
  				   ".long 0x4e450007\n\t"
  				   "movew d7,%0"
  				 : "=g" (er)
  				 : "p" (name)
  				 : "a3", "d7" );
	
	return er;
}


int
FOS::Install (const char* log, const char* phys, const char* param)
{
	Card16 er;
	Card32 id = 0;
	
	asm volatile ( "movel %1,d3\n\t"
				   "movel %2,a3\n\t"
				   "movel %3,a4\n\t"
				   "movel %4,a2\n\t"
				   ".long 0x4e450018\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (id), "g" (log), "g" (phys), "g" (param)
				 : "d3", "d7", "a2", "a3", "a4" );
	
	return er;
}


int
FOS::Deinstall (const char* name)
{
	Card16 er;
	Card32 id = 0;
	
	asm volatile ( "movel %1,d3\n\t"
				   "movel %2,a3\n\t"
				   ".long 0x4e450019\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (id), "g" (name)
				 : "d3", "d7", "a3" );
	
	return er;
}



int
FOS::Execute (const char* exec, Card32 mode)
{
	Card16 er;
	
	asm volatile ( "movel %1,a3\n\t"
				   "movel a5,a4\n\t"
				   "subl a5,a5\n\t"
				   "movel %2,d4\n\t"
				   ".long 0x4E450038\n\t"
				   "movel a4,a5\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (exec), "g" (mode)
				 : "d3", "d4", "d7", "a3", "a4" );
	
	return er;
}


int
FOS::Cache (const char* name)
{
	Card16 er;
	
	asm volatile ( "movel %1,a3\n\t"
				   ".long 0x4E45002C\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (name)
				 : "d7", "a3" );
	
	return er;
}

int
FOS::XCache (const char* newname, const char* oldname)
{
	Card16 er;
	
	asm volatile ( "movel %1,a3\n\t"
				   "movel %2,a4\n\t"
				   ".long 0x4E450044\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (newname), "g" (oldname)
				 : "d7", "a3", "a4" );
	
	return er;
}


int
FOS::Assign (const char* log, const char* phys)
{
	Card16 er;
	Card32 id = 0;
	
	asm volatile ( "movel %1,d3\n\t"
				   "movel %2,a3\n\t"
				   "movel %3,a4\n\t"
				   ".long 0x4e45001A\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (id), "g" (log), "g" (phys)
				 : "d3", "d7", "a3", "a4" );
	
	return er;
}


int
FOS::Deassign (const char* name)
{
	Card16 er;
	Card32 id = 0;
	
	asm volatile ( "movel %1,d3\n\t"
				   "movel %2,a3\n\t"
				   ".long 0x4e45001B\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (id), "g" (name)
				 : "d3", "d7", "a3" );
	
	return er;
}

int
FOS::CDir (const char* name, Card32 hash)
{
	Card16 er;
	
	asm volatile ( "movel %1,d3\n\t"
				   "movel %2,a3\n\t"
				   ".long 0x4e450021\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (hash), "g" (name)
				 : "d3", "d7", "a3" );
	
	return er;
}


