/*
 *
 *	fos.h - Interface pour le File Operating System du Smaky.
 *
 *	(C) 1992-1995  Pierre ARNAUD & EPSITEC-system SA
 *
 */

#ifndef _FOS_H_
#define _FOS_H_

#include "portable.h"

#define	FOS_OPEN_EXCL		0x00000001
#define	FOS_OPEN_READ		0x00000002
#define	FOS_OPEN_WRITE		0x00000004
#define	FOS_OPEN_EXTEND		0x00000008
#define	FOS_OPEN_EXCL_WR	0x00000010
#define	FOS_OPEN_CODE		0x00000020
#define	FOS_OPEN_NDIR		0x00000040
#define	FOS_OPEN_SYS		0x00000080
#define	FOS_OPEN_ARGS		0x00000100
#define	FOS_OPEN_CREATE		0x00000800
#define	FOS_OPEN_OPEN		0x00001000
#define	FOS_OPEN_APPEND		0x00002000
#define	FOS_OPEN_RSTATUS	0x00004000
#define	FOS_OPEN_PRE		0x00008000
#define	FOS_OPEN_NODIR		0x00040000
#define	FOS_OPEN_GENERAL	0x00080000
#define	FOS_OPEN_MMUNIT		0x00100000

#define	FOS_EX_ONLYONE		(1<<18)
#define	FOS_EX_FORCEKEY		(0)
#define	FOS_EX_LEAVEKEY		(1)

class FOS
{
public:
	static int What (const char* name, Card16& type);
	static int Open (const char* name, Card32 mode, Card16& can);
//	static int ArgsOpen (const char* name, Card32 mode, SmakyArgs& args, Card16& can);
	static int Close (Card16 can);
//	static int CloseMDC (Card16 can, const SmakyDate& datim);
	static int Read (Card16 can, Card32& size, void* buffer);
	static int Write (Card16 can, Card32& size, const void* buffer);
	static int SetPos (Card16 can, Card32 pos);
	static int GetPos (Card16 can, Card32& pos);
	static int Trunc (Card16 can);
	static int Create (const char* name, Card32 attr);
	static int Delete (const char* name);
	static int Install (const char* log, const char* phys, const char* param);
	static int Deinstall (const char* name);
	static int Execute (const char* exec, Card32 mode);
//	static int WaitExecute (const char* exec);
	static int Cache (const char* name);
	static int XCache (const char* newname, const char* oldname);
	static int Assign (const char* log, const char* phys);
	static int Deassign (const char* log);
	static int CDir (const char* name, Card32 hash);
};

#endif

