/*
 *	cc -O -Wall jfif2ps.c -o jfif2ps.code -lxp
 *
 *	(C) Copyright 1994, Pierre ARNAUD, CH-1437 SUSCEVAZ
 *	    All Rights Reserved.
 */

#include <filer.h>
#include <stdio.h>
#include <stdlib.h>

static int data_precision;
static int image_height;
static int image_width;
static int num_components;

static const int A4_DY = 836;
static const int A4_DX = 595;
static const int MARGIN = 20;

static int
find_header (FILE* file)
{
    int c, high, low, size;
    
    for (;;) {
        c = fgetc (file);
        if (c == EOF) return -1;
        if (c == 0xFF) {
            c = fgetc (file);
            
            if (c == 0xC0) {
                
                /* SOF marker found ! */
                
                high = fgetc (file);
                low = fgetc (file);
                size = (high << 8) + low;
                
                data_precision = fgetc (file);
                
                high = fgetc (file);
                low = fgetc (file);
                image_height = (high << 8) + low;
                
                high = fgetc (file);
                low = fgetc (file);
                image_width = (high << 8) + low;
                
                num_components = fgetc (file);
                
                return 0;
            }
        }
    }
    
    return 1;
}


static int
output_PS_image (FILE* input, FILE* output, int x, int y, int dx, int dy, int angle)
{
    char* buffer = malloc (1000);
    
    if (buffer == 0) return 1;
    
    fprintf (output, "%%!\n");
    fprintf (output, "gsave\n");
    if (num_components == 1) fprintf (output, "/DeviceGray setcolorspace\n");
    if (num_components == 3) fprintf (output, "/DeviceRGB setcolorspace\n");
    
    fprintf (output, "%d %d translate %d rotate %d %d scale\n", x, y, angle, dx, dy);
    fprintf (output, "<< /ImageType 1\n"
    		     "   /Width %d\n"
    		     "   /Height %d\n"
    		     "   /ImageMatrix [ %d 0 0 -%d 0 %d ]\n"
    		     "   /DataSource currentfile << >> /DCTDecode filter\n"
    		     "   /BitsPerComponent %d\n"
    		     "   /Decode [%s]\n"
    		     "   /Interpolate true\n"
    		     ">> image\n",
    		     image_width, image_height,
    		     image_width, image_height, image_height,
    		     data_precision,
    		     (num_components == 1) ? "0 1" : "0 1 0 1 0 1"
    		     );
    
    for (;;) {
        size_t size;
        
        size = fread (buffer, 1, 1000, input);
        fwrite (buffer, 1, size, output);
        
        if (size != 1000) break;
    }
    
    fprintf (output, "%\n");
    fprintf (output, "grestore showpage\n");
    
    free (buffer);
    return 0;
}


int
main (int argc, char** argv)
{
    FILE* input;
    FILE* output;
    
    int x,y,dx,dy,angle;
    double ratio;
    
    if (argc != 3) {
        fprintf (stderr, "usage: %s input_jpeg_file output_ps_file\n", argv[0]);
        return 1;
    }
    
    input = fopen (argv[1], "rb");
    if (input == 0) return 1;
    
    if (find_header (input)) return 1;
    fclose (input);
    
    input = fopen (argv[1], "rb");
    output = fopen (argv[2], "wb");
    if (output == 0) return 1;
    
    ratio = (double)(image_width)/(double)(image_height);
    
    if (ratio > 1.0) {
        
        x = A4_DX - MARGIN;
        y = MARGIN;
        angle = 90;
        dx = A4_DY - 2 * MARGIN;
        dy = (int)((double)(dx) / ratio);
        
        if (dy >= A4_DX) {
            dy = A4_DX - 2 * MARGIN;
            dx = (int)((double)(dy) * ratio);
        }
        
    } else {
        
        x = MARGIN;
        y = MARGIN;
        angle = 0;
        dx = A4_DX - 2 * MARGIN;
        dy = (int)((double)(dx) / ratio);
        
        if (dy >= A4_DY) {
            dy = A4_DY - 2 * MARGIN;
            dx = (int)((double)(dy) * ratio);
        }
    }
    
    if (output_PS_image (input, output, x, y, dx, dy, angle)) return 1;
    
    fclose (input);
    fclose (output);
    return 0;
}
