

typedef char ATSocket;
typedef char ATHardAddr;
typedef short ATNetwork;


struct ATPrnAddr {

    ATSocket	socket;			// port associ
    ATHardAddr	hard_address;		// adresse hardware sur le rseau
    ATNetwork	network;		// numro du rseau
};


/*
 *  Dfinition d'une imprimante AppleTalk du rseau.
 */

struct ATPrnDef {
    
    ATPrnAddr	address;		// adresse sur le rseau
    
    char	name[32];		// nom de l'imprimante
    char	type[32];		// type de l'imprimante
    char	zone[32];		// zone (sur le rseau)
};


/*
 *  Reprsentation d'une liste d'imprimantes. Une instance
 *  de cette classe peut tre obtenue par l'entremise de
 *  ATPrintMan::OpenList.
 */

class ATPrnList {
    
    friend class ATPrintMan;
    
    ATPrnList ();
    virtual ~ATPrnList ();
    
public:
    virtual int GetNum ();
    virtual Bool GetNth (int num, ATPrnDef& printer);
};


class ATPrnConn {
    
    friend class ATPrintMan;
    
public:
    virtual 
};


/*
 *  Gestionnaire d'imprimantes AppleTalk.
 */

class ATPrintMan {
    
    NtrelBar	nbp_gate;
    NtrelBar	pap_gate;
    
    
    virtual ATPrnList* OpenList (const char* name, const char* type, const char* zone);
    virtual void CloseList (ATPrnList*);
    
    virtual Bool RegisterName (ATSocket, const char* name, const char* type);
    virtual Bool ConfirmName (const ATPrnDef&);
    
    virtual ATPrnConn* OpenConnection (const ATPrnAddr&);
    virtual void CloseConnection (ATPrnConn*);
};


