|
|	Some more NTREL calls.
|
|	(C) 1992,  Pierre ARNAUD, OPaC, CH-1437 SUSCEVAZ
|
|	Use of the M68000 registers :
|
|	a6: frame register
|	d0: function return
|	d2-d7, a2-a5: register variables
|	d0-d1, a0-a1: free (without save)
|	long = int = 32 bits, short = 16 bits, char = 8 bits

|
|	entry points
|
	.globl _NTR_Cresem__F11NTR_SemTypePPv
	.globl _NTR_Killsem__FPv
	.globl _NTR_Lock__FPv
	.globl _NTR_Unlock__FPv
	.globl _NTR_Signev__FPv
	.globl _NTR_Ssignev__FPv
	.globl _NTR_Waitev__FPv
	.globl _NTR_Delms__Fs
	.globl _NTR_Dels__Fs
	.globl _NTR_Settim__Fs
	.globl _NTR_Gettim__Fv
	.globl _NTR_Modtim__Fs
	.globl _NTR_Gettpt__Fv
	.globl _NTR_Gettimems__Fv
	.globl _NTR_Cretask__FlPVFv_vPCcsPvPT4PsT4l
	.globl _NTR_Abort__Fv;
	.globl _NTR_Wfabdesc__Fv;

	.globl _NTR_Crebal__FiPPv
	.globl _NTR_Killbal__FPv
	.globl _NTR_Givms__FPvT0l11NTR_BalMode
	.globl _NTR_Getms__FPvPT0PlP11NTR_BalMode

|
|	NTR constants
|

L_NTR_CRESEM	=	0x4E44000A
L_NTR_KILLSEM	=	0x4E44000D
L_NTR_LOCK	=	0x4E440043
L_NTR_UNLOCK	=	0x4E440044
L_NTR_SIGNEV	=	0x4E440042
L_NTR_SSIGNEV	=	0x4E440059
L_NTR_WAITEV	=	0x4E440041

L_NTR_SETTIM	=	0x4E440005
L_NTR_GETTPT	=	0x4E440006
L_NTR_GETTIM	=	0x4E44001A
L_NTR_MODTIM	=	0x4E44005A
L_NTR_GETTIMEMS	=	0x4E440080
L_NTR_ABORT	=	0x4E440001
L_NTR_WFABDESC	=	0x4E440040

L_NTR_DELMS	=	0x4E440008
L_NTR_DELS	=	0x4E440009


|	define some offsets (L_FPPn = First Parameter Pushing n registers)

L_FPP2		=	12		| 2 x reg + 1 x ret.add.
L_FPP3		=	16
L_FPP4		=	20
L_FPP5		=	24
L_FPP6		=	28
L_FPP7		=	32

	.text

|
| int
| NTR_Cresem (NTR_SemType type, NTR_SemDesc* sema)
|
	.proc
_NTR_Cresem__F11NTR_SemTypePPv:
	moveml	d7/d4/a5,sp@-
	movel	sp@(L_FPP3+0),d4	| ^type du smaphore
	movel	sp@(L_FPP3+4),a0	| ^sur desc. du smaphore
	.long	L_NTR_CRESEM
	extl	d7
	movel	d7,d0
	movel	a5,a0@			| stocke le desc. du smaphore
	moveml	sp@+,d7/d4/a5
	rts


|
| int
| NTR_Killsem (NTR_SemDesc sema)
|
	.proc
_NTR_Killsem__FPv:
	moveml	d7/a5,sp@-
	movel	sp@(L_FPP2+0),a5	| desc. du smaphore
	.long	L_NTR_KILLSEM
	extl	d7
	movel	d7,d0
	moveml	sp@+,d7/a5
	rts


|
| int
| NTR_Lock (NTR_SemDesc sema)
|
	.proc
_NTR_Lock__FPv:
	moveml	d7/a5,sp@-
	movel	sp@(L_FPP2+0),a5	| desc. du smaphore
	.long	L_NTR_LOCK
	extl	d7
	movel	d7,d0
	moveml	sp@+,d7/a5
	rts


|
| int
| NTR_Unlock (NTR_SemDesc sema)
|
	.proc
_NTR_Unlock__FPv:
	moveml	d7/a5,sp@-
	movel	sp@(L_FPP2+0),a5	| desc. du smaphore
	.long	L_NTR_UNLOCK
	extl	d7
	movel	d7,d0
	moveml	sp@+,d7/a5
	rts


|
| int
| NTR_Signev (NTR_SemDesc sema)
|
	.proc
_NTR_Signev__FPv:
	moveml	d7/a5,sp@-
	movel	sp@(L_FPP2+0),a5	| desc. du smaphore
	.long	L_NTR_SIGNEV
	extl	d7
	movel	d7,d0
	moveml	sp@+,d7/a5
	rts


|
| int
| NTR_Ssignev (NTR_SemDesc sema)
|
	.proc
_NTR_Ssignev__FPv:
	moveml	d7/a5,sp@-
	movel	sp@(L_FPP2+0),a5	| desc. du smaphore
	.long	L_NTR_SSIGNEV
	extl	d7
	movel	d7,d0
	moveml	sp@+,d7/a5
	rts


|
| int
| NTR_Waitev (NTR_SemDesc sema)
|
	.proc
_NTR_Waitev__FPv:
	moveml	d7/a5,sp@-
	movel	sp@(L_FPP2+0),a5	| desc. du smaphore
	.long	L_NTR_WAITEV
	extl	d7
	movel	d7,d0
	moveml	sp@+,d7/a5
	rts


|
| void
| NTR_Delms (short)
|
	.proc
_NTR_Delms__Fs:
	moveml	d4/d7,sp@-
	movel	sp@(L_FPP2+0),d4	| temps d'attente
	.long	L_NTR_DELMS
	moveml	sp@+,d4/d7
	rts


|
| void
| NTR_Dels (short)
|
	.proc
_NTR_Dels__Fs:
	moveml	d4/d7,sp@-
	movel	sp@(L_FPP2+0),d4	| temps d'attente
	.long	L_NTR_DELS
	moveml	sp@+,d4/d7
	rts


|
| int
| NTR_Settim (short)
|
	.proc
_NTR_Settim__Fs:
	moveml	d4/d7,sp@-
	movel	sp@(L_FPP2+0),d4	| time-out
	.long	L_NTR_SETTIM
	extl	d7
	movel	d7,d0
	moveml	sp@+,d4/d7
	rts


|
| int
| NTR_Gettim ()
|
	.proc
_NTR_Gettim__Fv:
	moveml	d4/d7,sp@-
	.long	L_NTR_GETTIM
	extl	d4
	movel	d4,d0
	moveml	sp@+,d4/d7
	rts


|
| int
| NTR_Gettimems ()
|
	.proc
_NTR_Gettimems__Fv:
	moveml	d4/d5/d7,sp@-
	.long	L_NTR_GETTIMEMS
	movel	d4,d0
	moveml	sp@+,d4/d5/d7
	rts


|
| int
| NTR_Modtim (short)
|
	.proc
_NTR_Modtim__Fs:
	moveml	d4/d7,sp@-
	movel	sp@(L_FPP2+0),d4	| time-out
	.long	L_NTR_MODTIM
	extl	d4
	movel	d4,d0
	moveml	sp@+,d4/d7
	rts


|
| int
| NTR_Gettpt ()
|
	.proc
_NTR_Gettpt__Fv:
	moveml	d7/a4,sp@-
	.long	L_NTR_GETTPT
	movel	a4,d0
	moveml	sp@+,d7/a4
	rts

|
| int NTR_Cretask (long stack_size, volatile void (*func_ptr)(), const char* name, short priority,
|		   NTR_SemDesc abort_sem, NTR_TaskPtr* task_ptr, NTR_TaskNum* task_num,
|		   void* param_ptr, long param_value);

_NTR_Cretask__FlPVFv_vPCcsPvPT4PsT4l:
	link a6,#0
	moveml #0xc38,sp@-
	movel d7,d0			| save D7
	movel a6@(8),d5
	movel a6@(12),a5
	movel a6@(16),a3
	movew a6@(22),d4
	movel a6@(24),a2
	movel a6@(36),a1
	movel a6@(40),d1
	.long 0x4E450000		| NTREL ?CRETASK
	movel a6@(28),a0
	movel a4,a0@
	movel a6@(32),a0
	movew d4,a0@
	movel d0,a0
	movew d7,d0
	extl d0				| error to return...
	movel a0,d7			| restore D7
	moveml a6@(-20),#0x1c30
	unlk a6
	rts

|
| volatile
| NTR_Abort ()
|
	.proc
_NTR_Abort__Fv:
	.long	L_NTR_ABORT
	rts


|
| int
| NTR_Wfabdesc ()
|

_NTR_Wfabdesc__Fv:
	movel	d7,d1
	.long	L_NTR_WFABDESC
	movew	d7,d0
	extl	d0
	movel	d1,d7
	rts



_NTR_Crebal__FiPPv:
	link a6,#0
	moveml #0x900,sp@-
	movel a6@(12),a0
	movel a6@(8),d4
	.long 0x4e440014
	movew d7,d0
	movel a5,a0@
	extl d0
	moveml a6@(-8),#0x90
	unlk a6
	rts



_NTR_Killbal__FPv:
	link a6,#0
	movel d7,sp@-
	movel a6@(8),a5
	.long 0x4e440017
	movew d7,d0
	extl d0
	movel a6@(-4),d7
	unlk a6
	rts



_NTR_Givms__FPvT0l11NTR_BalMode:
	link a6,#0
	moveml #0x1908,sp@-
	movel a6@(8),a5
	movel a6@(12),a4
	movel a6@(16),d4
	movel a6@(20),d3
	.long 0x4e440037
	movew d7,d0
	extl d0
	moveml a6@(-16),#0x1098
	unlk a6
	rts



_NTR_Getms__FPvPT0PlP11NTR_BalMode:
	link a6,#0
	moveml #0x1928,sp@-
	movel a6@(12),a0
	movel a6@(16),a1
	movel a6@(20),a2
	movel a6@(8),a5
	movel a0@,a4
	movel a1@,d4
	movel a2@,d3
	.long 0x4e440045
	movew d7,d0
	moveb d3,a2@(3)
	movel a4,a0@
	movel d4,a1@
	extl d0
	moveml a6@(-20),#0x1498
	unlk a6
	rts
