
/*
 *	ntrelbar.c
 *
 *	Interface avec les botes  rendez-vous du noyau
 *	temps rel.
 *
 *	(C) 1993,  Pierre ARNAUD, CH-1437 SUSCEVAZ
 */

#include "ntrelbar.h"

int
NtrelCreBar (const char* name, NtrelBar* bar)
{
    short error;
    
    asm (	"moveq #0,d4\n\t"
    		"movel %2,a3\n\t"
    		"movel a5,d1\n\t"
    		".long 0x4E44007A\n\t"
    		"exg   a5,d1\n\t"
    		"movel d1,%0\n\t"
    		"movew d7,%1\n\t"
    	: "=g" (*bar), "=g" (error)
    	: "g" (name)
    	: "d1", "d4", "d7", "a3");
    
    return error;
}

int
NtrelKillBar (NtrelBar bar)
{
    short error;
    
    asm (	"movel %1,d1\n\t"
    		"exg   a5,d1\n\t"
    		".long 0x4E44007B\n\t"
    		"exg   a5,d1\n\t"
    		"movew d7,%0\n\t"
    	: "=g" (error)
    	: "g" (bar)
    	: "d1", "d7");
    
    return error;
}

int
NtrelAcceptBar (NtrelBar bar, const void** ptr)
{
    short error;
    
    asm (	"movel %2,d1\n\t"
    		"exg   a5,d1\n\t"
    		".long 0x4E44007D\n\t"
    		"exg   a5,d1\n\t"
    		"movel a4,%0\n\t"
    		"movew d7,%1\n\t"
    	: "=g" (*ptr), "=g" (error)
    	: "g" (bar)
    	: "d1", "d7", "a4");
    
    return error;
}

int
NtrelEndAcceptBar (NtrelBar bar, const void* ptr)
{
    short error;
    
    asm (	"movel %1,d1\n\t"
    		"movel %2,a4\n\t"
    		"exg   a5,d1\n\t"
    		".long 0x4E44007F\n\t"
    		"exg   a5,d1\n\t"
    		"movew d7,%0\n\t"
    	: "=g" (error)
    	: "g" (bar), "g" (ptr)
    	: "d1", "d7", "a4");
    
    return error;
}

int
NtrelOfferBar (NtrelBar bar)
{
    short error;
    
    asm (	"movel %1,d1\n\t"
    		"exg   a5,d1\n\t"
    		".long 0x4E44007C\n\t"
    		"exg   a5,d1\n\t"
    		"movew d7,%0\n\t"
    	: "=g" (error)
    	: "g" (bar)
    	: "d1", "d7");
    
    return error;
}

int
NtrelEndOfferBar (NtrelBar bar, const void* in_ptr, const void** out_ptr)
{
    short error;
    
    asm (	"movel %2,d1\n\t"
    		"movel %3,a4\n\t"
    		"exg   a5,d1\n\t"
    		".long 0x4E44007E\n\t"
    		"exg   a5,d1\n\t"
    		"movel a4,%0\n\t"
    		"movew d7,%1\n\t"
    	: "=g" (*out_ptr), "=g" (error)
    	: "g" (bar), "g" (in_ptr)
    	: "d1", "d7", "a4");
    
    return error;
}

int
NtrelGetPSelR (NtrelSelRec** rec)
{
    short error;
    
    asm (	".long 0x4E440081\n\t"
    		"movel a3,%0\n\t"
    		"movew d7,%1\n\t"
    	: "=g" (*rec), "=g" (error)
    	: 
    	: "d7", "a3");
    
    return error;
}

int
NtrelSelectSync (long* index, const void** result)
{
    short error;
    
    asm (	".long 0x4E440082\n\t"
    		"movel a4,%0\n\t"
    		"movel d3,%1\n\t"
    		"movew d7,%2\n\t"
    	: "=g" (*result), "=g" (*index), "=g" (error)
    	: 
    	: "d3", "d7", "a4");
    
    return error;
}

