
/*
 *	ntrelbar.h
 *
 *	Interface avec les botes  rendez-vous du noyau
 *	temps rel.
 *
 *	(C) 1993,  Pierre ARNAUD, CH-1437 SUSCEVAZ
 */

#ifndef _NTRELBAR_H_
#define _NTRELBAR_H_

#include "portable.h"

typedef void* NtrelBar;

typedef Card8 SelType;

#define    SEL_OFFER	0		/* primitive offer sur BAR		*/
#define    SEL_ACCEPT	2		/* primitive accept sur BAR		*/
#define    SEL_WAITEV	4		/* primitive wait sur smaphore		*/
#define    SEL_LOCK	6		/* primitive lock sur smaphore		*/


struct NtrelSel {
    Card32	index;			/* index de la slection		*/
    SelType	type;			/* type de la slection			*/
    Card8	r_1;
    const void*	id;			/* identificateur de BAR ou smaphore	*/
    const void*	p1;			/* paramtre 1				*/
    const void*	p2;			/* paramtre 2				*/
};


struct NtrelSelRec {
    Card16	nb_sel;			/* nombre de slections			*/
    Card16	r_1;
    Card32	wait_until;		/* attente (temps absolu ou -1)		*/
    Card32	r_2;
    NtrelSel	recs[10];		/* table des records de slection	*/
};



extern int NtrelCreBar (const char* name, NtrelBar* bar);
extern int NtrelKillBar (NtrelBar bar);
extern int NtrelAcceptBar (NtrelBar bar, const void** ptr);
extern int NtrelEndAcceptBar (NtrelBar bar, const void* ptr);
extern int NtrelOfferBar (NtrelBar bar);
extern int NtrelEndOfferBar (NtrelBar bar, const void* in_ptr, const void** out_ptr);
extern int NtrelGetPSelR (NtrelSelRec** rec);
extern int NtrelSelectSync (long* index, const void** result);

extern long NTR_Gettimems ();
extern short NTR_Modtim (short);
extern void NTR_Settim (short);

inline long NtrelGetTimeMs () { return NTR_Gettimems (); }

#endif
