#include <stdio.h>
#include <string.h>
#include <filer.h>

typedef char Bool;
enum __bool { FALSE, TRUE };

#include "ntrelbar.h"
#include "nbpdefs.h"
#include "papdefs.h"

static const MY_FLOW_QUANTUM	= 8;
static const SMALL_DELTA_T	= 10;		/* 1/5 seconde */
static const STATUS_DELTA_T	= 50;		/* 1 seconde */
unsigned long _stksize = 64*1024;

int
read_buffer (FILE* file, int buf_size, int* read_size, char* buffer)
{
    static int count = 0;
    
    if (count++) {
        *read_size = 0;
        *buffer = 0;
        return 1;
    }
    
    strcpy (buffer, "(Hello) = flush\n");
    *read_size = strlen ("(Hello) = flush\n");
    return 1;
}


/*
 *  Fonction "impression" utilise par le soft `printtalk'. Elle
 *  fait tout le travail :
 *
 *  1. Ouverture de la connexion avec l'imprimante.
 *  2. Dialogue :
 *     - Ecriture de donnes.
 *     - Lecture de rponses.
 *     - Lecture de statuts.
 *  3. Fermeture de la connexion.
 *
 *  De plus, cette fonction propage plus loin les informations
 *  pour que le programme SMA_PSSERV.CODE sache ce qu'il en est.
 */

int
truc ()
{
    NBPCommand	cmd_nbp;
    NtrelBar	nbp_gate;
    NBPElem	list_nbp_answers[30];
    
    int		i, n;
    const void*	dummy;
    
    short	prn_network;
    char	prn_node;
    char	prn_socket;
    
    FILE*	file = 0;
    char	file_buffer[4096];
    
    PAPCommand	cmd_pap;
    PAPCommand	stat_cmd;
    char	status_pap[258];
    
    NtrelBar	pap_gate;
    long	erreur = 0;
    NtrelBar	pap_in;
    NtrelBar	pap_out;
    
    Bool	ok, stop, fatal_error;
//    char	pap_data[4098];
    int		quantum;
    
    PAPReadInfo	data_read;
    char	string_read[4098];
    PAPCommand	cmd_read;
    
    NtrelCreBar (NBP_COMMAND_GATE, &nbp_gate);
    NtrelCreBar (PAP_COMMAND_GATE, &pap_gate);
    
    cmd_nbp.command = NBP_LOOK_UP;
    cmd_nbp.list = list_nbp_answers;
    cmd_nbp.nb_max_rep = 30;
    cmd_nbp.nb_rempli = 0;
    cmd_nbp.nb_essais = 0;
    cmd_nbp.timeout_essai = 0;
    
    strcpy (cmd_nbp.name.object, "=");
    strcpy (cmd_nbp.name.type, "LaserWriter");
    strcpy (cmd_nbp.name.zone, "");
    
    NtrelOfferBar (nbp_gate);
    NtrelEndOfferBar (nbp_gate, &cmd_nbp, &dummy);
    
    if (cmd_nbp.error) {
        printf ("Erreur NBP : %d\n", cmd_nbp.error);
        return 1;
    };
    
    if (cmd_nbp.nb_rempli == 0) {
        printf ("Personne ne satisfait  la condition de recherche\n");
        return 1;
    }
    
    for (i = 0; i < cmd_nbp.nb_rempli; i++) {
        printf ("%3d : %s.%s@%s\n", i, cmd_nbp.list[i].object,
        	cmd_nbp.list[i].type, cmd_nbp.list[i].zone);
    }
    
    printf ("\nQuel numro choisissez-vous ? ");
    scanf ("%d", &n);
    
    if ((n < 0) || (n >= cmd_nbp.nb_rempli)) {
        printf ("Pas dans la liste.\n");
        return 1;
    }
    
    prn_network = cmd_nbp.list[n].network;
    prn_node = cmd_nbp.list[n].hard_address;
    prn_socket = cmd_nbp.list[n].socket;
    
    cmd_pap.command = PAP_OPEN_CONN;
    cmd_pap.u.open_conn.dest_net = prn_network;
    cmd_pap.u.open_conn.dest_node = prn_node;
    cmd_pap.u.open_conn.dest_socket = prn_socket;
    cmd_pap.u.open_conn.flow_quantum = MY_FLOW_QUANTUM;
    cmd_pap.u.open_conn.status_open = status_pap;
    
    NtrelOfferBar (pap_gate);
    NtrelEndOfferBar (pap_gate, &cmd_pap, &dummy);
    
    if (cmd_pap.error) {
        printf ("Erreur PAP  l'ouverture : %d\n", cmd_pap.error);
        return 1;
    }
    
    pap_in = cmd_pap.u.open_conn.in_gate;
    pap_out = cmd_pap.u.open_conn.out_gate;
    
    ok = FALSE;
    stop = FALSE;
    fatal_error = FALSE;
    
    for (; (stop == FALSE) && (ok == FALSE);) {
        short what;
        
        NtrelAcceptBar (pap_out, (const void**)(&erreur));
        NtrelEndAcceptBar (pap_out, 0);
        
        what = erreur;
        
        if (what == 305) {
            printf ("%s\n", (*status_pap) ? "..." : status_pap);
        } else if (what == 303) {
            printf ("Connection ouverte\n");
            ok = TRUE;
        } else {
            printf ("Erreur PAP fatale : %d\n", what);
            stop = TRUE;
        }
    }
    
    if (ok) {
        
        stop = FALSE;
        
        quantum = cmd_pap.u.open_conn.flow_quantum <? MY_FLOW_QUANTUM;
        
        if (quantum < 1) {
            printf ("L'imprimante n'accepte pas de donnes.\n");
        } else {
            
            int i = 0;
            Bool status_pending = FALSE;
            Bool write_pending = FALSE;
            Bool read_pending = FALSE;
            Bool to_write = FALSE;
            Bool demande_status = FALSE;
            long prochain_status = NtrelGetTimeMs () + STATUS_DELTA_T;
            Bool fin_envoi = FALSE;
            Bool impr_terminee = FALSE;
            Bool un_status_recu = FALSE;
            Bool accepted = FALSE;
            
            cmd_read.command = PAP_READ;
            cmd_read.u.read.read_info = &data_read;
            cmd_read.u.read.read_info->read_data = string_read;
            cmd_read.u.read.read_info->flow_quantum_read = MY_FLOW_QUANTUM;
            
            Bool eof_recu = FALSE;
            int eof;
            
            for (;;) {
                
                if ((!write_pending) && (!fin_envoi)) {
                    
                    int size = 0;
                    eof = read_buffer (file, quantum*512, &size, file_buffer);
                    
                    cmd_pap.command = PAP_WRITE;
                    cmd_pap.eof = (eof ? 1 : 0);
                    cmd_pap.u.write.length_wr_data = size;
                    cmd_pap.u.write.write_data = file_buffer;
                    
                    write_pending = TRUE;
                    to_write = TRUE;
                }
                
                if (prochain_status < NtrelGetTimeMs ()) {
                    
                    stat_cmd.command = PAP_GET_STATUS;
                    stat_cmd.u.get_status.status_get = status_pap;
                    
                    demande_status = TRUE;
                    
                    prochain_status = NtrelGetTimeMs () + STATUS_DELTA_T;
                }
                
                Bool c1, c2, c3;
                long index = 0;
                
                c1 = (to_write && !fin_envoi);
                c2 = (!read_pending);
                c3 = (demande_status && !status_pending);
                
                {
                    NtrelSelRec* rec;
                    NtrelGetPSelR (&rec);
                    
                    const void* result = 0;
                    erreur = 0;
                    
                    rec->nb_sel = 1;
                    rec->wait_until = NtrelGetTimeMs () + SMALL_DELTA_T;
                    rec->recs[0].index = 0;
                    rec->recs[0].type = SEL_ACCEPT;
                    rec->recs[0].id = pap_out;
                    
                    if (c1 || c2 || c3) {
                        rec->nb_sel++;
                        rec->recs[1].index = 1;
                        rec->recs[1].type = SEL_OFFER;
                        rec->recs[1].id = pap_in;
                    }
                    
                    accepted = FALSE;
                    
                    if (NtrelSelectSync (&index, &result) == 0) {
                        
                        if (index == 0) {
                            NtrelEndAcceptBar (pap_out, 0);
                            erreur = (long)result;
                            accepted = TRUE;
                        }
                    }
                }
                
                if (accepted) {
                    short what = erreur;
                    if (what == 305) {
                        if (*status_pap)
                            printf ("status: %s\n", status_pap);
                        status_pending = FALSE;
                        if (fin_envoi) un_status_recu = TRUE;
                    } else if (what == 308) {
                        write_pending = FALSE;
                    } else if (what == 307) {
                        printf ("L'imprimante ne veut pas donner son statut.\n");
                        status_pending = FALSE;
                    } else if (what == 322) {
                        read_pending = FALSE;
                        printf ("Reu de l'imprimante : ");
                        if (cmd_read.u.read.read_info->eof_read) eof_recu = TRUE;
                        if (cmd_read.u.read.read_info->length_rd_data > 0) {
                            string_read[cmd_read.u.read.read_info->length_rd_data] = 0;
                            printf ("%s\n", string_read);
                        }
                    } else if (what == 321) {
                        printf ("L'imprimante dlire !!!\n");
                        read_pending = FALSE;
                    } else {
                        printf ("PAP a rendu une erreur : %d\n", what);
                        stop = TRUE;
                    }
                } else if (index == 1) {
                    if (c1) {
                        NtrelEndOfferBar (pap_in, &cmd_pap, &dummy);
                        to_write = FALSE;
                        if (cmd_pap.error) {
                            printf ("PAP refuse d'crire: %d\n", cmd_pap.error);
                        } else {
                            i += quantum;
                            printf ("%5d Kbytes transfrs.\n", i/2);
                        }
                    } else if (c2) {
                        NtrelEndOfferBar (pap_in, &cmd_read, &dummy);
                        if (cmd_read.error) {
                            printf ("PAP refuse de lire: %d\n", cmd_read.error);
                        } else {
                            read_pending = TRUE;
                        }
                    } else if (c3) {
                        NtrelEndOfferBar (pap_in, &stat_cmd, &dummy);
                        if (stat_cmd.error == 0) {
                            status_pending = TRUE;
                            demande_status = FALSE;
                        }
                    }
                }
                
                if (eof_recu) impr_terminee = TRUE;
                if (stop || impr_terminee) break;
                printf (".");
            }
            
            printf ("Fin de la communication\n");
            
            erreur = 0;
            
            if (!fatal_error) {
                printf ("Je ferme la connexion.\n");
                
                cmd_pap.command = PAP_CLOSE_CONN;
                ok = FALSE;
                
                while (!ok) {
                    NtrelSelRec* rec;
                    
                    NtrelGetPSelR (&rec);
                    
                    long index = 0;
                    const void* result = 0;
                    
                    erreur = 0;
                    
                    rec->nb_sel = 2;
                    rec->wait_until = -1;
                    rec->recs[0].index = 0;
                    rec->recs[0].type = SEL_ACCEPT;
                    rec->recs[0].id = pap_out;
                    rec->recs[1].index = 1;
                    rec->recs[1].type = SEL_OFFER;
                    rec->recs[1].id = pap_in;
                    
                    NtrelSelectSync (&index, &result);
                    
                    switch (index) {
                        case 1:
                            ok = TRUE;
                            NtrelEndOfferBar (pap_in, &cmd_pap, &dummy);
                            break;
                            
                        case 0:
                            NtrelEndAcceptBar (pap_out, 0);
                            break;
                    }
                }
                
                if (cmd_pap.error) {
                    printf ("erreur PAP %d\n", cmd_pap.error);
                }
            }
        }
    }
    
    return 0;
}


int
main ()
{
    return truc ();
}
