
/*
 *	smakyprint.c
 *
 *	Interface avec les mcanismes PRINT pour connatre les
 *	caractristiques de l'imprimante physique courante.
 *
 *	(C) 1993,  Pierre ARNAUD, CH-1437 SUSCEVAZ
 */


#include <sys/types.h>
#include <filer.h>

#include "smakyprint.h"

enum Bool { FALSE, TRUE };

Bool
printer_resol_and_margins (u_long& resol, u_long& width, u_long& height)
{
    char status[LGPRI0];
    printer_status_t* s = (printer_status_t*)(status);
    const char* printer_name = "#PHYS_PRINT:";
    short error, fos;
    
    asm volatile ( "movew #0x4000,d3\n\t"
    		   "movel %2,a3\n\t"
    		   ".long 0x4e45004a\n\t"
    		   "movew d6,%0\n\t"
    		   "movew d7,%1"
    		 : "=g" (fos), "=g" (error)
    		 : "g" (printer_name)
    		 : "d3", "d6", "d7", "a3" );
    
    if (error) return FALSE;
    
    asm volatile ( "movew %1,d6\n\t"
    		   "movel %2,a4\n\t"
    		   "moveq #64,d4\n\t"
    		   ".long 0x4e45001e\n\t"
    		   ".long 0x4e450005\n\t"
    		   "movew d7,%0"
    		 : "=g" (error)
    		 : "g" (fos), "g" (s)
    		 : "d4", "d6", "d7", "a4" );
    
    if (error) return FALSE;
    
    double dot_size = s->um_x;
    
    dot_size /= 10000.0;		// taille en [mm]
    dot_size /= 25.4;			// taille en [inch]
    
    resol = (u_long)((1.0 / dot_size) + 0.5);
    width = (s->width_page - s->hard_margin_left - s->hard_margin_right) & 0xFFFFFFF0;
    height = (s->height_page - s->hard_margin_upper - s->hard_margin_lower) & 0xFFFFFFFE;
    return TRUE;
}
