/*
 *	nbpdefs.h
 *
 *
 *	(C) Copyright 1993-1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 Suscvaz
 */

#include <c++/portable.h>

#define NBP_LISTELEM_NUM	30

struct NBPAddress {
    Card8			socket;
    Card8			node;
    Card16			network;
};


struct NBPElem {
    NBPAddress		address;
    Card8			enumerator;
    Card8			dummy_1;
    char			object[34];
    char			type[34];
    char			zone[34];
};


typedef Card8 NBPComm;

#define	NBP_REGISTER_NAME	(NBPComm)(0)
#define	NBP_REMOVE_NAME		(NBPComm)(1)
#define	NBP_LOOK_UP			(NBPComm)(2)
#define	NBP_CONFIRM_NAME	(NBPComm)(3)
#define	NBP_SUICIDE			(NBPComm)(4)


struct NBPCommand {
    Card16			nb_essais;
    Card32			timeout_essai;
    NBPElem			name;
    NBPComm			command;
    Card8			dummy;
    Card16			nb_max_rep;
    Card16			nb_rempli;
    NBPElem*		list;
    Card16			error;
};


