/*
 *	papdefs.h
 *
 *	(C) Copyright 1993-1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 Suscvaz
 */

#include <c++/portable.h>

#define PAP_CONN_OPEN		303
#define PAP_STATUS_AVAIL	305
#define PAP_STATUS_NO_RESP	307
#define PAP_DATA_WRITTEN	308
#define PAP_READ_GARBAGE	321
#define PAP_DATA_READ		322

#define	PAP_COMMAND_GATE	"#:PAPCommand"


struct PAPReadInfo {
    
    Card8			eof_read;
    Card8			dummy_1;
    
    Card16			length_rd_data;
    Card16			flow_quantum_read;
    const char*		read_data;
};


typedef Card8 PAPCommandEnum;

    
#define	PAP_OPEN_CONN	(PAPCommandEnum)(0)
#define	PAP_ABORT_OPEN	(PAPCommandEnum)(1)
#define	PAP_GET_STATUS	(PAPCommandEnum)(2)
#define	PAP_CLOSE_CONN	(PAPCommandEnum)(3)
#define	PAP_WRITE		(PAPCommandEnum)(4)
#define	PAP_READ		(PAPCommandEnum)(5)
#define	PAP_PROC_END	(PAPCommandEnum)(6)
#define	PAP_SUICIDE		(PAPCommandEnum)(7)


struct PAPGates {
    Card32		in;
    Card32		out;
};


struct PAPCommandOpenConn {
    
    PAPGates		io_gates;
    Card16			dest_net;
    Card8			dest_node;
    Card8			dest_socket;
    Card16			flow_quantum;
    const char*		status_open;
};


struct PAPCommandGetStatus {
    
    const char*		status_get;
};


struct PAPCommandWrite {
    
    Card16			length_wr_data;
    const char*		write_data;
};


struct PAPCommandRead {
    
    PAPReadInfo*	read_info;
};



struct PAPCommand {
    
    PAPCommandEnum	command;
    Card8			eof;
    
    union {
        PAPCommandOpenConn open_conn;
        PAPCommandGetStatus get_status;
        PAPCommandWrite write;
        PAPCommandRead read;
    } u;
    
    Card16			error;
};


