/*
 *		ppd.h
 *
 *		Dfinition des structures utilises pour la description d'une
 *		imprimante PostScript.
 *
 *		(C) 1993-1995,  Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#ifndef _PPD_H_
#define _PPD_H_

#include <c++/portable.h>

struct PPD_GenInfo;
struct PPD_ResDPI;
struct PPD_InTray;
struct PPD_OutBin;
struct PPD_Font;

typedef Card8  PPD_Option;				/* option YES/NO, plus compact qu'un "enum"				*/
typedef Card32 PPD_Id;					/* identificateur de PPD								*/

#define	PPD_NO		FALSE				/* option pas supporte									*/
#define	PPD_YES		TRUE				/* option supporte										*/



/*
 *	Informations gnrales au sujet d'une imprimante PostScript. Il
 *	faut commencer par demander ces infos avant de vouloir connatre
 *	les autres dtails.
 */

struct PPD_GenInfo {
	
	Card16		struct_size;			/* taille de la structure								*/
	Card16		ps_level;				/* niveau PostScript (1 ou 2)							*/
	
	Card16		num_resol;				/* nombre de rsolutions disponibles					*/
	Card16		num_trays;				/* nombre de bacs  papier en entre					*/
	Card16		num_bins;				/* nombre de rceptacles en sortie						*/
	Card16		num_fonts;				/* nombre de fontes										*/
	
	Card16		throughput;				/* nombre de pages/minute du moteur						*/
	Card32		free_vm;				/* quantit de mmoire disponible						*/
	
	char		rs_file_name[16];		/* nom du fichier de ressources associ  l'imprimante	*/
	char		model_name[32];			/* nom du modle en clair								*/
	
	PPD_Option	is_color;				/* YES => imprimante couleur							*/
	PPD_Option	has_man_feed;			/* YES => alimentation manuelle possible				*/
	PPD_Option	print_down;				/* YES => sait imprimer les documents "face dessous"	*/
	PPD_Option	print_up;				/* YES => sait imprimer les documents "face dessus"		*/
	
};


/*
 *	Information dtaille : rsolution de l'imprimante.
 */

struct PPD_ResDPI {
	
	Card16		dpi_x;					/* rsolution [x] en points/pouce						*/
	Card16		dpi_y;					/* rsolution [y] en points/pouce						*/
	
};


/*
 *	Information dtaille : dfinition d'un bac  papier.
 */

struct PPD_InTray {
	
	Card16		struct_size;			/* taille de la structure								*/
	short		num;					/* numro du bac physique (interne)						*/
	
	char		tray_name[32];			/* nom du bac											*/
	char		media_name[32];			/* nom du mdia dans le bac								*/
	char		media_color[32];		/* couleur du mdia dans le bac							*/
	char		media_type[32];			/* type du mdia dans le bac							*/
	
	Card16		media_weight;			/* poids du mdia en grammes/m2							*/
	Card32		media_x;				/* largeur du mdia en diximes de [mm]					*/
	Card32		media_y;				/* hauteur du mdia en diximes de [mm]					*/
	
	Card32		left_margin;			/* marge physique gauche en diximes de [mm]			*/
	Card32		right_margin;			/* marge physique droite en diximes de [mm]			*/
	Card32		upper_margin;			/* marge physique suprieure en diximes de [mm]		*/
	Card32		lower_margin;			/* marge physique infrieure en diximes de [mm]		*/
	
	Card8		r, g, b;				/* composantes RGB correspondant  la couleur du mdia	*/
	char		dummy;					/* remplissage											*/
	
};


/*
 *	Information dtaille : dfinition d'un rceptacle de sortie.
 */

struct PPD_OutBin {
	
	Card16		struct_size;			/* taille de la structure								*/
	Card16		num;					/* numro du bac physique (interne)						*/
	
	char		bin_name[32];			/* nom du rceptacle de sortie							*/
	
};


/*
 *	Information dtaille : dfinition d'une fonte.
 */

struct PPD_Font {
	
	Card16		struct_size;			/* taille de la structure								*/
	
	char		afm_name[16];			/* nom du fichier AFM associ							*/
	char		font_name[48];			/* nom de la fonte										*/
	
};


/*
 *	Dfinition des fonctions permettant d'accder aux caractristiques
 *	d'une imprimante.
 */

extern PPD_Id ppd_open (const char* server);
extern void ppd_close (PPD_Id);

extern int ppd_select (PPD_Id, int num, PPD_GenInfo* buffer);
extern int ppd_getresol (PPD_Id, int num, PPD_ResDPI* buffer);
extern int ppd_gettray (PPD_Id, int num, PPD_InTray* buffer);
extern int ppd_getbin (PPD_Id, int num, PPD_OutBin* buffer);
extern int ppd_getfont (PPD_Id, int num, PPD_Font* buffer);

extern int ppd_setresol (PPD_Id, int num, const char** ps_code);
extern int ppd_settray (PPD_Id, int num, const char** ps_code);
extern int ppd_setbin (PPD_Id, int num, const char** ps_code);
extern int ppd_setmanfeed (PPD_Id, PPD_Option manual, const char** ps_code);
extern int ppd_setprintup (PPD_Id, PPD_Option print_up, const char** ps_code);

extern int ppd_deftray (PPD_Id, const PPD_InTray* buffer);

#endif
