/*
 *	ppminit.cc
 *
 *	Initialisation des composants lis au PostScript Printer Manager.
 *
 *	(C)	 Copyright 1993-1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include <stdlib.h>

#include "misc.h"
#include <c++/fos.h>
#include <c++/ntrel.h>


static NtrBar* gate = 0;



/*
 *	Initialise le gate de communication avec le serveur
 *	des noms sur Appletalk.
 */

NtrBar*
ppm_init_atalk ()
{
	if (gate) {
		return gate;
	}
	
	if (getenv ("LTALK") == 0) {
		
		report_msg (REPORT_INFO, "Installe AppleTalk");
		
		FOS::Deinstall ("#PP");
		FOS::Deinstall ("#PR");
		FOS::Install ("#LTALK", "$LTALK_0", 0);
		
		if (getenv ("LTALK") == 0) {
			report_msg (REPORT_ERROR, "#LTALK: n'a pas pu tre install !");
			return 0;
		}
		
		FOS::Cache ("PRUNETALK.CODE");
		FOS::Cache ("SMA_PSNMAC.CODE");
		FOS::Execute ("PRUNETALK", FOS_EX_ONLYONE + FOS_EX_LEAVEKEY);
		FOS::XCache ("SMACK.CODE", "SMA_PSNMAC.CODE");
		
		report_msg (REPORT_INFO, "Dmarre PruneTalk");
		
		Ntr::Dels (15);
	}
	
	//	Accde  la BAR pour le Name Binding Protocol.
	
	gate = new NtrBar ("#:NBPCommand", 1);
	if (gate->GetError ()) {
		report_msg (REPORT_ERROR, "PruneTalk pas oprationnel !");
		delete gate;
		gate = 0;
	}
	
	return gate;
}


