#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern int errno;

#include <c++/fos.h>
#include <c++/ntrel.h>

#include "misc.h"
#include "ppm.h"
#include "ppm_atalk.h"
#include "printcon.h"

// cc1plus ppmatalk.ii -quiet -dumpbase ppmatalk.cc -m68020 -O2 -Wall -version -fomit-frame-pointer -o ppmatalk.s

unsigned long _stksize   = 10*1024;						// pile
unsigned long _SMASOVER  = 1;							// utilise entre OVERLAY de prfrence
unsigned char _SMAPRIO   = 13;							// priorit leve (utilise que pour l'init.)
unsigned char _SMAREV    = 4;							// rvision
unsigned char _SMAVER    = 1;							// version
unsigned long _SMAUNIT   = 0x00000000;					// binaire GNU => 0x0080 (no cache)
unsigned short _SMADIS[] = {20, 600, 20, 400};			// petite fentre

char _SMAIDE[] = "(C) 1993-2000  Pierre ARNAUD, OPaC bright ideas";


extern Bool  no_gs;
extern Bool  no_message;
extern Bool  use_ctrl_D;
extern Bool  force_040A;

extern void send_clock_message (const char* text, const char* network, const char* title);
extern void ppm_loop_printing (int& open);


int
main (int argc, char** argv)
{
	PPMan		ppm;
	PPM_PrnName	printer;
	JobDef		job;
	
	Bool  stop   = FALSE;
	int   open   = 0;
	int   result = 0;
	char* file   = 0;
	
	if (FOS::Assign ("#PTLK_RUNS", "@KLASTSP")) {
		report_msg (REPORT_ERROR, "Dj en excution");
		return 0;
	}
	
	char msg[200];
	sprintf (msg, "Rvision %d.%d", _SMAREV, _SMAVER);
	report_msg (REPORT_INFO, msg);
	
//	FOS::CDir ("#MM0:TMP:", 10);
//	FOS::CDir ("#MM0:PSSPOOL:", 10);
//	FOS::Execute ("rm #psspool:*.ps", FOS_EX_LEAVEKEY);
	FOS::Execute ("rm /tmp/gs_*", FOS_EX_LEAVEKEY);
	
//	if (getenv ("PSSPOOL") == 0) {
//		FOS::Assign ("#PSSPOOL:", "#MM0:PSSPOOL:");
//	}
	
	while (!stop) {
		
		Ntr::Dels (1);
		
		no_gs      = getenv ("PSTALK_NOGS") ? TRUE : FALSE;
		no_message = getenv ("PSTALK_NOMSG") ? TRUE : FALSE;
		use_ctrl_D = getenv ("PSTALK_NOCTR") ? FALSE : TRUE;
		force_040A = getenv ("PSTALK_040A") ? TRUE : FALSE;
		
		if (PPMan::IsStopRequested ()) {
			putenv ("PSTALK_ABORT");
		}
		
		ppm_loop_printing (open);
		
		printer.name[0] = 0;
		printer.type[0] = 0;
		printer.zone[0] = 0;
		printer.comm[0] = 0;
		job.file        = 0;
		file            = 0;
		
		if (PPMServer::PrintDocument (printer, file)) {
			
			if ( (result = ppm.PrintFile (&printer, file, &job)) == 0) {
				
				if (job.file == 0) {
					goto end_of_print;
				}
				
				open = 1;
				
				while (open) {
					ppm_loop_printing (open);
				}
				
				fclose (job.file);
				
end_of_print:	FOS::Delete (file);
				const char* title = job.job.title;
				const char* last  = title;
				
				while (*last++) {
					if ( (last[-1] == ':')
					  || (last[-1] == '/') ) {
						title = last;
					}
				}
				
				send_clock_message ("Fin d'impression", job.job.routing, title);
				{ char message[256];
				  sprintf (message, "Fin d'impression de `%s'", title);
				  report_msg (REPORT_INFO, message); }
				
			} else if (result == -1) {
				
				goto end_of_print;
				
			} else {
				
				FOS::Delete (file);
				const char* title = job.job.title;
				const char* last = title;
				
				while (*last++) {
					if ( (last[-1] == ':')
					  || (last[-1] == '/') ) {
						title = last;
					}
				}
				send_clock_message ( (result == 2) ? "Imprimante pas trouve"
												   : "Problme  l'impression",
									job.job.routing, title);
				{ char message[256];
				  sprintf (message, "Impression avorte de `%s'", title);
				  report_msg (REPORT_INFO, message); }
			}
			
			delete file;
		}
		
		stop = getenv ("PTLK_STOP") ? TRUE : FALSE;
	}
	
	report_msg (REPORT_INFO, "Fin d'excution.");
	
	putenv ("PTLK_RUNS");
	putenv ("PTLK_STOP");
	return 0;
}

