/*
 *	ppmutils.cc
 *
 *	Routines utilitaires diverses.
 *
 *	(C)	Copyright 1993-1996, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 SUSCEVAZ
 */

#include <string.h>

#include "misc.h"
#include <c++/fos.h>

#define	FILE_NAME_OUT	"#PTLK_STDOUT"
#define	FILE_NAME_EMIT	"#PTLK_EMIT"

static Card16 ch_out  = 0;
static Card16 ch_emit = 0;
static const Card32 mode_pipe = FOS_OPEN_WRITE | FOS_OPEN_EXTEND | FOS_OPEN_APPEND | FOS_OPEN_CREATE;
static const Card32 mode_disp = FOS_OPEN_WRITE;


/*
 *	Extrait le paramtre qui suit `pattern' dans le buffer `src'
 *	et sauve son contenu dans `dest' en copiant jusqu' la fin
 *	de la ligne.
 */

void
extract (char* dest, const char* src, const char* pattern)
{
	const char* found = strstr (src, pattern);
	char        c     = 0;
	
	if (found) {
		
		found += strlen (pattern);
		
		while ( ((c = *found++))
		     && ((c == ' ') || (c == '\t')) ) {
			
			/* skip */
		}
		
		if (c) {
			
			found--;
			
			while ( (c = *found++)
			     && (c != '\n')
			     && (c != '\r') ) {
				*dest++ = c;
			}
		}
	}
	
	dest[0] = 0;
}


/*
 *  Envoie un message d'informations  l'application prvue  cet
 *  effet (pour autant qu'elle existe).
 */

void
report_msg (ReportType type, const char* msg)
{
	if (ch_out == 0) {
		
		int err = 1;
		
		if (err) err = FOS::Open (FILE_NAME_OUT, mode_pipe, ch_out);
		if (err) err = FOS::Open ("#DISPLAY", mode_disp, ch_out);
		
		if (err) {
			ch_out = 0;
			return;
		}
	}
	
	const char* text = "PSTalk: ";
	Card32      size = strlen (msg) + strlen (text) + 1;
	char*       buf  = new char[size];
	
	strcpy (buf, text);
	strcat (buf, msg);
	strcat (buf, "\n");
	
	FOS::Write (ch_out, size, buf);
	
	delete buf;
}


/*
 *	Retourne le canal du fichier d'mission de donnes, s'il
 *	existe.
 */

Card16
get_report_file ()
{
	if (ch_emit == 0) {
		
		int err = 1;
		
		if (err) err = FOS::Open (FILE_NAME_EMIT, mode_pipe, ch_emit);
		if (err) err = FOS::Open ("#DISPLAY", mode_disp, ch_emit);
		
		if (err) {
			ch_emit = 0;
		}
	}
	
	return ch_emit;
}

