/*
 *	ppm_atalk.h
 *
 *	Interface du PostScript Printer Manager avec le rseau
 *	Appletalk (ou le Prunetalk du Smaky).
 *
 *	(C)  Copyright 1993-1995, Pierre ARNAUD, CH-1437 SUSCEVAZ
 */

#ifndef _PPM_ATALK_H_
#define _PPM_ATALK_H_

#include <c++/portable.h>
#include "nbpdefs.h"
#include "papdefs.h"

class NtrSel;


/*
 *  Dfinition d'un travail (job).
 */

struct JobDef {
    PPM_Job			job;					// dfinition du travail en cours
    Card32			num;					// numro du travail
    Card32			user_id;				// identificateur de l'utilisateur
    Card32			user_machine;			// machine de l'utilisateur
    Card32			user_gate;				// gate de l'utilisateur
    FILE*			file;					// fichier associ
};



/*
 *  Gestionnaire d'impression PostScript : PostScript Printer Manager.
 *  Il se charge des oprations haut niveau.
 */

class PPMan {
    
	static Card32	num_documents;
	static Card32	num_queries;
	static Card32	num_others;
	static Card32	job_file_num;
	
protected:
    NBPElem			list[NBP_LISTELEM_NUM];
    Int32			count;
    
protected:
    NBPElem* FindPrinter (const PPM_PrnName* name);
    Bool CheckPrinter (const NBPElem* elem);
    
    Bool ParsePostScript (const PPM_PrnName* printer, const char* name, JobDef* job, int& error);
    Bool PrintPostScriptStream (const PPM_PrnName* printer, const char* name, JobDef* job, int& error);
    Bool PrintGhostScript (const PPM_PrnName* printer, const char* name, JobDef* job, int& error);
	
public:
    static Bool IsStopRequested ();
    
public:
    PPMan ();
    ~PPMan ();
    
    void UpdatePrinterList ();
    
    int GetNumPrinter ();
    Bool GetPrinterInfo (int num, PPM_PrnName* name);
    
    int PrintFile (const PPM_PrnName* printer, const char* file, JobDef* job);
};





class PPMServer {
    
	static PPMServer* list_first;
	static PPMServer* list_last;
	
    PPM_Request		request;
    
    PPMServer*		next;
    PPMServer*		prev;
    
private:
    static void Emit (JobDef* job, PPM_Answer& answer);
    
public:
    PPMServer (PPM_Request* rq);
    ~PPMServer ();
    
    static void AllSelect (NtrSel* sel);
    static void AllAfterSelect (Card32 index, Card32 req);
    
    static void EmitStartJob (JobDef* job);
    static void EmitEndJob (JobDef* job);
    static void EmitStatus (JobDef* job, const char* text);
    static void EmitMessage (JobDef* job, const char* text);
    static void EmitError (JobDef* job, const char* text);
    static void EmitOutput (JobDef* job, const void* data, long size);
    
    static Bool PrintDocument (PPM_PrnName& printer, char*& file);
};

#endif

