/*
 *		printcon.h
 *
 *		Connexion avec une imprimante via Appletalk.
 *
 *		(C)	 Copyright 1993, Pierre ARNAUD, CH-1437 SUSCEVAZ
 */

#ifndef _PRINTCON_H_
#define _PRINTCON_H_

#include <c++/portable.h>

#define MAX_PRINTCON	4

class NtrSel;

/*
 *	Dfinition d'une connexion (gates  utiliser, buffers divers,
 *	fichier  utiliser, informations diverses).
 */

class PrintCon {
	
	struct PPMpending {
	
		Bool		status_pending;
		Bool		write_pending;
		Bool		read_pending;
		Bool		to_write;
		Bool		demande_status;
		Bool		fin_envoi;
		Bool		impr_terminee;
		Bool		un_status_recu;
		
		Card32		prochain_status;
	};
	
private:
	static NtrBar*   pap_gate;
	static PrintCon* printcons[MAX_PRINTCON];
	
protected:
	PAPGates		gates;
	char			status[258];
	PAPCommand		cmd_pap;
	PAPCommand		stat_cmd;
	PAPCommand		cmd_read;
	PAPReadInfo 	data_read;
	
	Card32			quantum;
	Card32			written;
	
	Bool			eof;
	Bool			closed;
	Bool			eof_recu;
	Bool			not_open_yet;
	Bool			not_ready_yet;
	
	Int32			sel_in_num;
	Int32			sel_out_num;
	Int32			sel_open_num;
	
	PPMpending		pending;
	char			string_read[4098];
	char			buffer[4098];							// dpend de MY_FLOW_QUANTUM
	FILE*			file;									// fichier depuis lequel se fait la lecture
	JobDef*			job;									// dfinition du job
	
protected:
	PrintCon (FILE* f, JobDef* job);
	
	void Init (const NBPAddress* address);
	
	void CheckWrite ();
	void CheckStatus ();
	void Select (NtrSel* rec);
	void AfterSelect (Card32 index, Card32 value);
	int ReadBuffer (Card32& size);
	
public:
	static int  Open (FILE* file, JobDef* job, const NBPAddress* address);
	static void Abort (int num);
	
	static void AllCheckWrite ();
	static void AllCheckStatus ();
	static void AllSelect (NtrSel* rec);
	static void AllAfterSelect (Card32 index, Card32 value, int& num_open);
};

#endif

