/*
 *	config.cxx
 *
 *	Configuration system for SMA_SMAKY
 *
 *	(C) Copyright 1995,  Erik BRUCHEZ
 */

#include "config.h"
#include "lookman.h"
#include "activityspy.h"
#include "clock.h"
#include "waitkeys.h"
#include "softkeys.h"
#include "fos.h"

extern ActivitySpy	activity_spy;
extern Clock		clock;

static const ConfigSet default_set = {
	
	//	Header
	
	CONFIG_MAGIC,
	CONFIG_VERSION,
	CONFIG_LENGTH,
	
	//	Activity spying
	
	GRAPH_MODE_BAR,
	HISTO_MODE_NORMAL,
	GRAPH_MODE_HISTOGRAM,
	HISTO_MODE_DYNAMICAL,
	FALSE,
	
	10,
	1, 6,
	1, 3,
	1,
	2, 3,

	//	Clock
	
	TRUE,
	4,
	{ CLOCK_NORM, CLOCK_DIR, CLOCK_MEM, CLOCK_CPU,
	  (ClockMode)(0), (ClockMode)(0), (ClockMode)(0), (ClockMode)(0),
	  (ClockMode)(0), (ClockMode)(0), (ClockMode)(0), (ClockMode)(0) },

	//	Color
	
	FALSE,
	
	//	Miscellaneous
	
	TRUE,
	
	//	Soft-keys: automatic pop-up
	
	FALSE, FALSE, FALSE, FALSE
};


Configurator::Configurator ()
{
	this->config = default_set;
	
	Card16 channel;
	
	if (Fos::Open (CONFIG_FILE_NAME, FOS_OPRD, &channel) == 0) {
		Card32 length = CONFIG_LENGTH;
		Fos::RdByte (channel, &length, &this->config);
		Fos::Close (channel);
	}
	
	if ( (this->config.magic != CONFIG_MAGIC)
	  || (this->config.version != CONFIG_VERSION) ) {
//	  || (this->config.length != CONFIG_LENGTH) ) {
		this->config = default_set;
	}
}

Configurator::~Configurator ()
{
	//	we never quit...
}

void
Configurator::SetConfiguration ()
{
	this->SetConfiguration (&this->config);
}

Bool
Configurator::SetConfiguration (const ConfigSet *config)
{
	if ( (config->magic != CONFIG_MAGIC)
	  || (config->version != CONFIG_VERSION)
	  || (config->length != CONFIG_LENGTH) ) return FALSE;
	
	this->config = *config;
	
	activity_spy.ParseConfiguration (&this->config);
	clock.ParseConfiguration (&this->config);
	LookMan::SetColorMode (this->config.force_mono);
	
	g_beep_m3 = this->config.beep_m3;
	
	g_popup_mode = POPUP_NO;
	
	if (this->config.skpop_enabled) {
		
		g_popup_mode = POPUP_YES;
		
		if (this->config.skpop_slowon)   g_popup_mode |= POPUP_SLOW_ON;
		if (this->config.skpop_slowoff)  g_popup_mode |= POPUP_SLOW_OFF;
		if (this->config.skpop_clickoff) g_popup_mode |= POPUP_CLICK_OFF;
	}
	
	return TRUE;
}

void
Configurator::GetConfiguration (const ConfigSet*& config)
{
	config = &this->config;
}

