/*
 *	config.h
 *
 *	Configuration system for SMA_SMAKY
 *
 *	(C) Copyright 1995,  Erik BRUCHEZ
 */


#ifndef _SMA_CONFIG_H_
#define _SMA_CONFIG_H_

#include "system.h"
#include "activityspy.h"
#include "clock.h"

struct ConfigSet
{
	//	Header
	
	Card32		magic;				// CONFIG_MAGIC
	Card32		version;			// configuration structure version
	Card32		length;				// total length (with header)
	
	//	Activity spying
	
	GraphMode	mem_grmode;			// memory graph mode
	HistoMode	mem_hmode;			// memory histogram mode
	GraphMode	cpu_grmode;			// cpu graph mode
	HistoMode	cpu_hmode;			// cpu histogram mode
	Bool		sma_smaky_cpu;		// cpu time included SMA_SMAKY ?
	Card32		sample_period;		// unit : 20 ms
	Card32		mem_period_1;		// unit : sample_period
	Card32		mem_period_2;		// unit : mem_period_1
	Card32		cpu_period_1;		// unit : sample_period
	Card32		cpu_period_2;		// unit : cpu_period_1
	Card32		net_period;			// unit : sample_period
	Card32		mouse_period_1;		// unit : sample_period [unused]
	Card32		mouse_period_2;		// unit : mouse_period_1 [unused]
	
	//	Clock
	
	Bool		blinking_col;
	Card8		cycle_len;
	ClockMode	cycle[12];
	
	//	Color
	
	Bool		force_mono;
	
	//	Miscellaneous
	
	Bool		beep_m3;
	
	//	Soft-keys: automatic pop-up (version 3.0)
	
	Bool		skpop_enabled;		// enable automatic pop-up of soft-keys
	Bool		skpop_slowon;		// pop-up activates slowly
	Bool		skpop_slowoff;		// pop-up deactivates slowly
	Bool		skpop_clickoff;		// pop-up deactivates when clicked
};

#define CONFIG_MAGIC (0xc01cd12e)
#define CONFIG_VERSION (0x0100)
#define CONFIG_LENGTH (sizeof (ConfigSet))

#define CONFIG_FILE_NAME "#:(info:,)sms(_%n,).info"

class Configurator {
private:
	ConfigSet	config;
	
public:
	Configurator ();
	~ Configurator ();
	
	void SetConfiguration ();
	Bool SetConfiguration (const ConfigSet *config);
	void GetConfiguration (const ConfigSet*& config);
};

#endif /* _SMA_CONFIG_H_ */

