/*
 *		res.h
 *
 *		
 */

#define RSOPCACHE	(1<<0)
#define RSOPMTYP	(1<<3)
#define RSOPSYSTEM	(1<<2)
#define RSOPDEFAULT	(1<<4)
#define RSOPINCODE	(1<<5)
#define RSOPMINIMUM	(1<<6)
#define RSOPPOINTER	(1<<7)

#define RSCLUPDATE	(1<<0)
#define RSCLNOCLOSE	(1<<1)

#define RSGETPOINTER (1<<0)
#define RSGETCOPY	 (1<<1)
#define RSGETSUBRES	 (1<<5)

#define RSGIVSUBRES


class ResType;
class ResFile;

class Res {
	ResType& type;
	Card32	k_size;		// kind & size
	Card32*	aux;		// ^ to associated Card32
	Card32	num;		// resource number
	void*	data;		// ^ to resource data
	Bool	copy;		// data copied to user mem account
	Card16	err;		// last error

public:
	Res (ResType& t, Card32 num, Bool copy = FALSE);
	~Res ();

	Card32	GetSize ()	{ return (k_size & 0xffffff); }
	Card8	GetKind ()	{ return (k_size >> 24); }
	Card32	GetAux ()	{ return *aux; }
	void	SetAux (Card32 val) { *aux = val; }
	void*	GetData ()	{ return data; }
	Card32	GetNum ()	{ return num; }
	Card16	GetError ()	{ return this->err; }
};


class ResType {
	friend Res::Res (ResType&, Card32, Bool);
	friend Res::~Res ();

	ResFile& file;
	Card32 handle;
	Card32 resnum;
	Card32 key;
	Card16 err;

public:
	ResType (ResFile& f, Card32 type, Card32 key = 0);
	~ResType () {}

	Card32	GetNumber () { return resnum; }
	Card16	GetError ()	{ return this->err; }
};


class ResFile {
	friend ResType::ResType (ResFile&, Card32, Card32);
	friend Res::Res (ResType&, Card32, Bool);
	friend Res::~Res ();

	Card32 channel;
	Card16 err;
	Card32 close_mode;
	void*  close_saver;
	Card32 save_channel;

public:
	ResFile (const char* name, Card32 mode, Card32 revver, Card32 key = 0,
					 void* ptr = 0, Card16 mtyp = 0, void* mdesc = 0);
	~ResFile ();

	void	DefClose (Card32 mode, void* saver = 0, Card32 savech = 0);
	void	DefProgVar (void* ptr);
	Card16	GetError ()	{ return this->err; }
};

