/*
 *	def_sms.cxx
 *
 *	Programme de configuration pour SMA_SMAKY
 *
 *	(C)	1995,	Erik BRUCHEZ et EPSITEC-system SA
 *
 *				Inspir d'un exemple de Pierre ARNAUD
 */

extern "C" {
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
}

#include "../ntrel.h"
#include "../config.h"

typedef struct { short y,x; } Point;

extern "C"
{
#include "hldbox.h"

extern int L_drseg (Point origine, Point dim, u_short mode);
extern int L_afmenu (void *liste);
extern int L_getwdo (Point *UpperLeft, Point *Dim, int *nowdo);

extern int res_opelib (void);
extern int res_clolib (void);

extern int dbox_opelib (void);
extern int dbox_clolib (void);
}

#include "def_sms.h"
#include "ressource.h"

#define F0		0x80
#define F1		0x81
#define F2		0x82
#define F3		0x83
#define F4		0x84
#define F5		0x85
#define F6		0x86
#define F7		0x87
#define F8		0x88
#define F9		0x89
#define F10		0x8A
#define F11		0x8B
#define F12		0x8C
#define F13		0x8D
#define F14		0x8E
#define F15		0x8F

#define	UNDO	0x90
#define	HELP	0x91
#define	END		0x92
#define	MACRO	0x93
#define	FNCT	0x94
#define	DEFINE	0x95
#define POINT	0x97
#define	ENTER	0x98
#define	DELETE	0x9E
#define	CLEAR	0x9F
#define RETURN	0x0d

/****************************************************************/

unsigned long _stksize = 10*1024;		// pile
unsigned long _SMASOVER = 1;			// utilise entre OVERLAY de prfrence
unsigned char _SMAPRIO = 11;			// priorit leve (utilise que pour l'init.)
unsigned char _SMAREV = 0;				// rvision
unsigned char _SMAVER = 1;				// version
unsigned long _SMAUNIT = 0x000000A7;	// binaire GNU (no cache)
unsigned short _SMADIS[] = {20, 2000, 20, 2000};
char _SMAIDE[] = "(C)  Erik BRUCHEZ et EPSITEC SA";

/****************************************************************/

static struct dbox my_dbox;

static short my_convtable[] = {
    F1, F2, F3,			/* ====> */	F1, 0,
    F4, F5, F6,			/* ====> */	F4, 0,
    F7, F8, F9,			/* ====> */ F7, 0,
    F13, F14, F15,		/* ====> */ F13, 0,
    0
};

static struct dboxgroup my_group = {
    2, { 1 << 0 | 1 << 1, 1 << 4 | 1 << 5 },
};

/****************************************************************/

static int
LoadLibs ()
{
    int err;
    
    if (err = dbox_opelib ()) return err;
    atexit ((void (*)(void))(dbox_clolib));
    
    if (err = res_opelib ()) return err;
    atexit ((void (*)(void))(res_clolib));
    
    return 0;
}

/****************************************************************/

static const ConfigSet default_set = {
	
	//	Header
	
	CONFIG_MAGIC,
	CONFIG_VERSION,
	CONFIG_LENGTH,
	
	//	Activity spying
	
	GRAPH_MODE_BAR,
	HISTO_MODE_NORMAL,
	GRAPH_MODE_HISTOGRAM,
	HISTO_MODE_DYNAMICAL,
	FALSE,
	
	10,
	1, 6,
	1, 3,
	1,
	2, 3,

	//	Clock
	
	TRUE,
	3,
	{ CLOCK_NORM, CLOCK_MEM, CLOCK_CPU, (ClockMode)(0),
	  (ClockMode)(0), (ClockMode)(0), (ClockMode)(0), (ClockMode)(0),
	  (ClockMode)(0), (ClockMode)(0), (ClockMode)(0), (ClockMode)(0) },

	//	Color
	
	FALSE,		//	force mono
	
	//	Miscellaneous
	
	TRUE		//	beep M3
};

static ConfigSet config_set;
static ConfigSet reset_set;

/****************************************************************/

static void
ReadFile ()
{
	/*
	long length;
	
	fseek (file, 0, 2);
	length = ftell (file);
	fseek (file, 0, 0);
	
	if (length < CONFIG_LENGTH)
		config_set = default_set;
	*/
	
	FILE *file = fopen (CONFIG_FILE_NAME, "rb");
	
	config_set = default_set;
	
	if (file) {
		fread (&config_set, CONFIG_LENGTH, 1, file);
		fclose (file);
	}
	
	if ( (config_set.magic != CONFIG_MAGIC)
	  || (config_set.version != CONFIG_VERSION)
	  || (config_set.length != CONFIG_LENGTH) ) {
		config_set = default_set;
	}
	
	reset_set = config_set;
}


static void
UpdateFile ()
{
	FILE* file = fopen (CONFIG_FILE_NAME, "wb");
	
 	if (file) {
		fwrite (&config_set, CONFIG_LENGTH, 1, file);
		fclose (file);
	}
}

/****************************************************************/

static void
SetFlagsFromStruct ()
{
	long flags = 0;
	
	if (config_set.mem_grmode == GRAPH_MODE_BAR)
		flags |= (1 << 0);
	else
		flags |= (1 << 1);
	
	if (config_set.cpu_grmode == GRAPH_MODE_BAR)
		flags |= (1 << 4);
	else
		flags |= (1 << 5);
	
	if (config_set.mem_hmode == HISTO_MODE_DYNAMICAL)
		flags |= (1 << 3);
	
	if (config_set.cpu_hmode == HISTO_MODE_DYNAMICAL)
		flags |= (1 << 6);
	
	if (config_set.sma_smaky_cpu)
		flags |= (1 << 7);
	
	if (config_set.cycle_len == 0) {
		config_set.cycle_len = default_set.cycle_len;
		for (int i = 0; i < default_set.cycle_len; i++)
			config_set.cycle[i] = default_set.cycle[i];
	}
	
	for (int i = 0; i < config_set.cycle_len; i++)
		flags |= (1 << (17 + config_set.cycle[i]));
	
	if (config_set.blinking_col)
		flags |= (1 << 9);
	
	if (!config_set.force_mono)
		flags |= (1 << 14);
	
	if (config_set.beep_m3)
		flags |= (1 << 15);
	
	dboxputflags (&my_dbox, flags);
}

static void
SetStructFromFlags ()
{
	long flags = dboxgetflags (&my_dbox);
	
	config_set = default_set;
	
	config_set.mem_grmode = (flags & (1 << 0)) ? GRAPH_MODE_BAR : GRAPH_MODE_HISTOGRAM;
	config_set.cpu_grmode = (flags & (1 << 4)) ? GRAPH_MODE_BAR : GRAPH_MODE_HISTOGRAM;
	config_set.mem_hmode = (flags & (1 << 3)) ? HISTO_MODE_DYNAMICAL : HISTO_MODE_NORMAL;
	config_set.cpu_hmode = (flags & (1 << 6)) ? HISTO_MODE_DYNAMICAL : HISTO_MODE_NORMAL;
	config_set.sma_smaky_cpu = (flags & (1 << 7)) ? TRUE : FALSE;
	
	config_set.cycle_len = 0;
	
	for (int i = 0; i < 5; i++) {
		if ((flags & (1 << (17 + i)))) {
			config_set.cycle[config_set.cycle_len] = (ClockMode)(i);
			config_set.cycle_len++;
		}
	}
	
	config_set.blinking_col = (flags & (1 << 9)) ? TRUE : FALSE;
	config_set.force_mono = (flags & (1 << 14)) ? FALSE : TRUE;
	config_set.beep_m3 = (flags & (1 << 15)) ? TRUE : FALSE;
}

static void
SendStruct ()
{
	NtrBar bar ("#:SmConfig");
	
	if (bar.GetError () == ERBARE) {
		bar.Offer ();
		void *dummy;
		bar.EndOffer ((void *)(&config_set), dummy);
	}

}

/****************************************************************/

static void
DrawLines ()
{
	Point p1, p2, dim, dummy;
	int nowdo;
	
	L_getwdo (&dummy, &dim, &nowdo);
	dim.y = 0;
	
	for (int i = 0; i < 4; i++) {
		dboxgetco (&my_dbox, i, &p1, &p2);
		p1.x = 0;
		p1.y -= 20;
		L_drseg (p1, dim, 2);
	}
	
	p1. y += 20 + 16;
	L_drseg (p1, dim, 2);
}

static void
DrawMenu ()
{
	static const char menu[] = {
		"\0"
		"\0"
		"\0"
		"Termine\0"
		"\0"
		"Applique\0"
		"\0"
		"Restaure\0"
		"\0"
		"\0"
		"\0"
		"Annule\0"
	};
	
	L_afmenu ((void *)(menu));
}

/****************************************************************/

int
main (int argc, char** argv)
{
	int err;
	Bool stop = FALSE;
	long oldflags;
	
	/*
	FILE* file = fopen ("#mm0:trace", "wb");
	char test[200];
	for (int i = 0; i < 200; i++) test[i] = ' ';
	sprintf (test, "argc : %d, argv[0] : %s, argv[1] : %s\0", argc, argv[0], argv[1]);
	
 	if (file) {
		fwrite (test, 200, 1, file);
		fclose (file);
	}
	*/
	
	//	Load libraries
	
	if (err = LoadLibs ()) return err;
	if (err = openres ("(:,#:)DEF_SMS(_%l,).RS", 0x00000001)) return err;
	
	//	Read configuration file or default configuration
	
	ReadFile ();
	
	//	Initialize hldbox
	
	if (err = dboxinit ((u_char *) ressource (rMainDbox, RtypDbox),
			  &my_dbox, &my_group, my_convtable))
		return 1;
	
	//	Set flags
	
	SetFlagsFromStruct ();
	oldflags = dboxgetflags (&my_dbox);
	
	//	Open dbox
	
	dboxopen (&my_dbox);
	DrawLines ();
	DrawMenu ();
	
	//	Main loop
	
	do {
		short touche;
		
		dboxedit (&my_dbox, &touche);
		
		switch (touche) {
			
			case F1:	// termine
				SetStructFromFlags ();
				SendStruct ();
				UpdateFile ();
				stop = TRUE;
				break;
			
			case RETURN:
			case F4:	// applique
				SetStructFromFlags ();
				SendStruct ();
				break;
			
			case UNDO:
			case F7:	// restaure
				config_set = reset_set;
				SetFlagsFromStruct ();
				break;
			
			case F13:	// annule
				stop = TRUE;
				break;
			
			case 0:
				break;
			
			default :
				dboxbip (&my_dbox, touche);
		}
		
		//	Look if there is at least one function for the clock
		
		{
			long flags = dboxgetflags (&my_dbox);
			const long mask = 0x3e0000;
			
			if (!(flags & mask)) {
				flags = oldflags;
				dboxputflags (&my_dbox, flags);
			} else
				oldflags = flags;
		}
	} while (!stop);
	
	dboxclose (&my_dbox);
	
	return 0;
}

/****************************************************************/

