/*
 *		fos.cxx
 *
 *		File Operating System static class interface
 *
 *		(C)		1994 Daniel MARMIER
 */

#include "fos.h"


Card16
Fos::Install(const char *logical, const char *physical, const void *params, Card16 pid, Card8 *subdriver)
{
		Card16 err;
   asm(
	  "movel	%2,a3\n"						/* logique						*/
	  "movel	%3,a4\n"						/* physique						*/
	  "movel	%4,a2\n"						/* params						*/
	  "movew	%5,d3\n"						/* pid							*/
	  ".long	0x4e450018\n"			/* FOS?INSTALL			*/
	  "moveb	d3,%1\n"
	  "movew	d7,%0\n"
		:		"=g" (err), "=g" (*subdriver)
		:		"g"	 (logical), "g"	 (physical), "g"  (params), "g"	 (pid)
		:		"d3", "d7", "a2", "a3", "a4"  );
		return err;
}


Card16
Fos::Deinstall(const char *logical, Card16 pid)
{
		Card16 err;
   asm(
	  "movel	%1,a3\n"						/* logique						*/
	  "movew	%2,d3\n"						/* pid							*/
	  ".long	0x4e450019\n"					/* FOS?DEINSTALL				*/
	  "movew	d7,%0\n"
		:		"=g" (err)
		:		"g"	 (logical), 
				"g"	 (pid)
		:		"d3", "d7", "a3" ) ;
		return err;
}


Card16
Fos::NExecute(const char* exec)
{
	Card16 err;
   asm(
	  "movel	%1,a3\n"
	  "subl		a5,a5\n"
	  "moveql	#1,d4\n"
	  ".long	0x4e450038\n"					/* FOS?NEXECUTE				*/
	  "movew	d7,%0\n"
		:		"=g" (err)
		:		"g"	 (exec)
		:		"d3", "d4", "d7", "a3", "a5" ) ;
		return err;
}


Card16
Fos::Command(Card16 canal, const void *commandes)
{
		Card16 err;
  asm("movew	%1,d6\n"
	  "movel	%2,a4\n"
	  ".long	0x4e45001d\n"
	  "movew	d7,%0\n"
		:		"=g" (err)
		:		"g"	 (canal),					/* Entre						*/
				"g"	 (commandes)
		:		"d6","a4","d7")	 ;				/* Registres dtruits			*/
		return err;
}

Card16
Fos::Deassign (const char* logical, Card16 pid)
{
		Card16 err;
		asm (	"movel	%1,a3\n\t"
						"movew	%2,d3\n\t"
						".long	0x4e45001b\n\t"
						"movew	d7,%0\n\t"
				: "=g" (err)
				: "g" (logical), "g" (pid)
				: "d3", "d7", "a3" );
		return err;
}


Card16
Fos::VLogic (const char* phys, Card16 pid, Card8 all, char* buf, Card32 len)
{
		Card16 err;
		asm (	"movel	%1,a3\n\t"
						"movew	%2,d3\n\t"
						"moveb	%3,d2\n\t"
						"movel	%4,a4\n\t"
						"movel	%5,d4\n\t"
						".long	0x4e450066\n\t"
						"movew	d7,%0\n\t"
				: "=g" (err)
				: "g" (phys), "g" (pid), "g" (all), "g" (buf), "g" (len)
				: "d2", "d3", "d4", "d7", "a3", "a4" );
		return err;
}

Card16
Fos::MmVAssign (Card16 num, const char** phys, Card16* icon)
{
		Card16 err;
		asm (	"movew	%3,d4\n\t"
						".long	0x4e45006e\n\t"
						"movel	a3,%0\n\t"
						"movew	d3,%1\n\t"
						"movew	d7,%2\n\t"
				: "=g" (*phys), "=g" (*icon), "=g" (err)
				: "g" (num)
				: "d3", "d4", "d7", "a3" );
		return err;
}

Card16
Fos::Enter (const char* name, Card32 mode)
{
		Card16 err;
		asm (	"movel	%1,a3\n\t"
						"movel	%2,d3\n\t"
						".long	0x4e450064\n\t"
						"movew	d7,%0\n\t"
				: "=g" (err)
				: "g" (name), "g" (mode)
				: "d3", "d7", "a3" );
		return err;
}

Card16
Fos::Release (const char* name, Card32 mode)
{
		Card16 err;
		asm (	"movel	%1,a3\n\t"
						"movel	%2,d3\n\t"
						".long	0x4e450033\n\t"
						"movew	d7,%0\n\t"
				: "=g" (err)
				: "g" (name), "g" (mode)
				: "d3", "d7", "a3" );
		return err;
}

Card16
Fos::GSDir (const char*& name, Card16 proc_num = 0)
{
		Card16 err;
		asm (	"movew	%2,d4			\n\t"
						".long	0x4e450037		\n\t"
						"movel	a3,%0			\n\t"
						"movew	d7,%1			\n\t"
				: "=g" (name), "=g" (err)
				: "g" (proc_num)
				: "d4", "d7", "a3" );
		return err;
}

Card16
Fos::Avort (Card16 channel)
{
		Card16 err;
		asm (	"movew	%1,d6\n\t"
						".long	0x4e450047\n\t"
						"movew	d7,%0\n\t"
				: "=g" (err)
				: "g" (channel)
				: "d3" , "d7" );
		return err;
}


Card16
Fos::Create (const char *nom, Card32 attrib, Card16 type, Card16 coding)
{
		Card16 err;
  asm ("
		movel	%1,a3
		movel	%2,d3
		movew	%3,d4
		movew	%4,d5
		.long	0x4e450006
		movew	d7,%0"
		: "=g" (err)
		: "g"	(nom),
		  "g"	(attrib),
		  "g"	(type),
		  "g"	(coding)
		: "d3", "d4", "d5", "d7", "a3") ;
		return err;
}

Card16
Fos::Open (const char *filename, Card32 mode, Card16 *canal)
{
		Card16 err;
		asm (	"movel	%2,a3\n"
						"movel	%3,d3\n"
						".long	0x4e450000\n"
						"movew	d6,%1\n"
						"movew	d7,%0\n"
				:		"=g" (err), "=g" (*canal)
				:		"g" (filename),
						"g" (mode),
						"g" (canal)
		:		"d3", "d6", "d7", "a3" );
	  return err;
}

Card16
Fos::ArgsOpen (const char *filename, Card32 mode, SmArgs *args, char *name,
				Card16 *nodep, Card16 *clef, Card32 preres, Card16 *canal)
{
		Card16 dummy_16_0 = 0;
		Card16 dummy_16_1 = 0;
		if (nodep == 0) nodep = & dummy_16_0;
		if (clef == 0)	clef  = & dummy_16_1;
		
		Card16 err;
		asm (	"movel	%1,a3\n"						/* Nom du fichier				*/
						"movel	%2,d3\n"						/* mode							*/
						"orb			#0x08,d3\n"						/* met le bit BOPEXTEND			*/
						"movel	%3,a1\n"						/* ^no. de dpart -> a1			*/
						"movew	a1@,d2\n"						/* no. de dpart -> d2			*/
	  "movel	%6,a4\n"						/* ^arguments  -> a4			*/
	  "movel	#256,d4\n"						/* taille nom 256				*/
	  "movel	%7,a2\n"						/* ^nom complet -> a2			*/
	  "movel	%5,d5\n"						/* preres -> d5					*/
	  ".long	0x4e45004a\n"
	  "movew	d7,%0\n"						/* Rsultat						*/
	  "cmpl				#0,a1\n"
	  "beq				LL1\n"
	  "movew	d2,a1@\n"						/* no d'option trouv			*/
	  "LL1:\n"
	  "movel	%8,a2\n"						/* canal						*/
	  "movew	d6,a2@\n"
	  "movel	%4,a2\n"
	  "cmpl				#0,a2\n"
	  "beq				LL2\n"
	  "movew	d3,a2@\n"
	  "LL2:\n"
				:		"=g" (err)
				:		"g" (filename),
						"g" (mode),
						"g" (nodep),
						"g" (clef), 
						"g" (preres),
						"g" (args),
						"g" (name),
						"g" (canal)
				:		"d2", "d3", "d4", "d5", "d6", "d7", "a1", "a2", "a3", "a4" );
		return err;
}

Card16
Fos::Close (Card16 canal)
{
		Card16 err;
		asm (	"movew	%1,d6\n"
						".long	0x4e450005\n"
						"movew	d7,%0\n"
		:		"=g" (err)
		:		"g"	 (canal)
		:		"d6", "d7" );
		return err;
}

Card16
Fos::RdByte (Card16 canal, Card32 *length, void *data)
{
		Card16 err;
   asm(
	  "movew	%2,d6\n"
	  "movel	%1,d4\n"
	  "movel	%3,a4\n"
	  ".long	0x4e450001\n"
	  "movel	d4,%1\n"
	  "movew	d7,%0\n"
		:		"=g" (err), "=g" (*length)
		:		"g"	 (canal), "g"  (data)
		:		"d4", "d6", "d7", "a4" );
		return err;
}

Card16
Fos::WrByte(Card16 canal, Card32 *length, const void* data)
{
		Card16 err;
   asm(
	  "movew	%2,d6\n"
	  "movel	%1,d4\n"
	  "movel	%3,a4\n"
	  ".long	0x4e450002\n"
	  "movel	d4,%1\n"
	  "movew	d7,%0\n"
		:		"=g" (err), "=g" (*length)
		:		"g"	 (canal),
				"g"	 (data)
		:		"d4", "d6", "d7", "a4" );
		return err;
}


Card16
Fos::TrComm (const char *command, void *buffer, Card32 length)
{
		Card16 err;
  asm("movel	%1,a3\n"
	  "movel	%2,a4\n"
	  "movel	%3,d4\n"
	  ".long	0x4e460044\n"
	  "movew	d7,%0\n"
		:		"=g" (err)
		:		"g"	 (command),					/* Entre						*/
				"g"	 (buffer),
				"g"	 (length)
		:		"d4","a3","d7","a4")	 ;		/* Registres dtruits			*/
		return err;
}


Card16
Fos::RStatus (Card16 channel, Card32 length, void* ad)
{
		Card16 err;
		
		asm ("	movew	%1,d6			\n"
				"		movel	%2,d4			\n"
				"		movel	%3,a4			\n"
				"		.long	0x4e45001e		\n"
				"		movew	d7,%0			\n"
		:		"=g" (err)
		:		"g"	 (channel), 
				"g"	 (length),
				"g"	 (ad)
		:		"d4", "d6", "d7", "a4");
		
		return err;
}


Card16
Fos::VisuInst (Card16 num, const char*& name, const Card8*& flags, const Card8*& type)
{
		Card16 err;
		
		asm ("	movew	%4,d2			\n"
				"		.long	0x4e450041		\n"
				"		movel	a2,a3			\n"
				"		addw	d4,a2			\n"
				"		addw	d5,a3			\n"
				"		movel	a2,%1			\n"
				"		movel	a3,%2			\n"
				"		addql	#1,a3			\n"
				"		movel	a3,%3			\n"
				"		movew	d7,%0			\n"
		:		"=g" (err), "=g" (name), "=g" (flags), "=g" (type)
		:		"g" (num)
		:		"d2", "d3", "d4", "d5", "d7", "a2", "a3");
		
		return err;
}

