/*
 *	fos.h
 *
 *	File Operating System static class interface
 *
 *	(C)	1994 Daniel MARMIER
 */

/*
 *	Erik BRUCHEZ	november 1994 :	added RStatus
 *					january  1995 :	made static class
 *									added VisuInst
 *									added GSDir
 */

#ifndef _SMAKY_FOS_H_
#define _SMAKY_FOS_H_

#include "system.h"

#define	FOS_DEFATT	0x27FFL		// default attributes
#define	FOS_TYPRAND	0x01		// random file

//	Modes for Fos::Open, Fos::ArgsOpen

#define	FOS_OPEXCL		0x01	// exclusive open (read+write)
#define	FOS_OPRD		0x02	// read open
#define	FOS_OPWR		0x04	// write open
#define	FOS_OPEXTEND	0x08	// extended mode
#define	FOS_OPEXWR		0x10	// write only
#define	FOS_OPCODE		0x20	// open without key
#define	FOS_OPNDIR		0x40	// add no DIR
#define	FOS_OPSYS		0x80	// open with system search

//	Modes for Fos::Open

#define	FOS_APPEND		0x100	// start file pointer at end of file
#define	FOS_TRUNC		0x200	// if file exists, truncate to 0 length
#define	FOS_CREAT		0x400	// create file if none exists (uses pmode)
#define	FOS_EXCL		0x800	// return ERFAEX if file exists and FOS_CREAT
								// is specified (exclusive mode)

//	Modes for Fos::ArgsOpen

#define	FOS_OPARGS		0x00000100L	// ask also for ARGS
#define	FOS_OPCREATE	0x00000800L	// create if not exist
#define	FOS_OPOPEN		0x00001000L	// open it even if no BOPWR or BOPRD
#define	FOS_OPAPPEND	0x00002000L	// go to EOF
#define	FOS_OPRSTATUS	0x00004000L	// open for RSTATUS
#define	FOS_OPPRE		0x00008000L	// prereserve disk place
#define	FOS_OPNODIR		0x00040000L	// copy not directory
#define	FOS_OPGENERAL	0x00080000L	// not on current process account
#define	FOS_OPMMUNIT	0x00100000L	// opens a unit mass memory as strea.


#define ERTRAV (0x8262)
#define ERUNNI (0x8517)
#define ERNDEV (0x8281)
#define EROUTF (0x8511)

struct SmArgs
{
	Card8		type;
	Card8		open;
	Card32		att;
	Card32		lg;
	Card16		lgb;
	Card8		cd[3];
	Card8		ch[3];
	Card8		wd[3];
	Card8		wh[3];
	Card8		rd[3];
	Card8		rh[3];
	Card32		res1;
	Card32		apt;
	Card32		lgf;
	Card8		res2[22];
};

class Fos {

public:
	
	static Card16 Install (const char* logical, const char *physical, const void* params,
						   Card16 pid, Card8* subdriver);
	static Card16 Deinstall (const char* logical, Card16 pid);
	static Card16 Command (Card16 canal, const void* commandes);
	
	static Card16 Enter (const char* name, Card32 mode);
	static Card16 Release (const char* name, Card32 mode);
	
	static Card16 GSDir (const char*& name, Card16 proc_num = 0);
	
	static Card16 Deassign (const char* logical, Card16 pid);
	
	static Card16 Create (const char* nom, Card32 attrib, Card16 type, Card16 coding);
	static Card16 Open (const char* filename, Card32 mode, Card16* canal);
	static Card16 ArgsOpen (const char* filename, Card32 mode, SmArgs *args, char* name,
							Card16* nodep, Card16* clef, Card32 preres, Card16* canal);
	static Card16 Close (Card16 canal);
	
	static Card16 RdByte (Card16 canal, Card32 *length, void *data);
	static Card16 WrByte (Card16 canal, Card32 *length, const void* data);
	
	static Card16 VLogic (const char* phys, Card16 pid, Card8 all, char* buf, Card32 len);
	static Card16 VisuInst (Card16 num, const char*& name, const Card8*& flags, const Card8*& type);
	static Card16 MmVAssign (Card16 num, const char** phys, Card16* icon);
	static Card16 Avort (Card16 channel);
	static Card16 TrComm (const char* command, void* buffer, Card32 length);
	static Card16 RStatus (Card16 channel, Card32 length, void* ad);
	static Card16 NExecute (const char* exec);
};

#endif /* _SMAKY_FOS_H_ */

