
#include "gesmem.h"
#include "ntrel.h"

MemAccount::MemAccount ()
{
	Ntr::GetTaskPtr (this->desc);	//	id. du processus
	this->type = 1;					//	MTYPOP
}

MemAccount::~MemAccount ()
{
}

void*
MemAccount::Alloc (int size)
{
	short error;
	void* ptr;
	
	asm ( "movel %2,d1\n\t"
		  "movel %3,a1\n\t"
		  "movel %4,d4\n\t"
		  ".long 0x4E440028\n\t"	//	GESMEM ?GETMEM
		  "movel a4,%0\n\t"
		  "movew d7,%1"
		: "=g" (ptr), "=g" (error)
		: "g" (this->type), "g" (this->desc), "g" (size)
		: "d1", "d4", "d7", "a1", "a4" );
	
	if (error) ptr = 0;
	return ptr;
}

void
MemAccount::Free (void* ptr)
{
	asm ( "movel %0,d1\n\t"
		  "movel %1,a1\n\t"
		  "movel %2,a4\n\t"
		  ".long 0x4E44002B"
		:
		: "g" (this->type), "g" (this->desc), "g" (ptr)
		: "d1", "d7", "a1", "a4" );
}

Card32
MemAccount::GetTotalMemory ()
{
	Card32 size = 0;
	
	asm ( ".long 0x4e440030	\n\t"				// GESMEM ?ARGLGM
		  "movel d4,%0"
		: "=g" (size)
		:
		: "d4", "d5", "d7" );
	
	return size;
}


Card32
MemAccount::GetBiggestHole ()
{
	Card32 size = 0;
	
	asm ( ".long 0x4e44002e	\n\t"				// GESMEM ?ARGMEM
		  "movel d5,%0"
		: "=g" (size)
		:
		: "d4", "d5", "d7" );
	
	return size;
}


Card32
MemAccount::GetFreeMemory ()
{
	Card32 size = 0;
	
	asm ( ".long 0x4e44002e	\n\t"				// GESMEM ?ARGMEM
		  "movel d4,%0"
		: "=g" (size)
		:
		: "d4", "d5", "d7" );
	
	return size;
}

extern "C" int G_argmem(long *total, long *biggest);
extern "C" int G_getmem(long *length, int type, long *desc_memptr);
extern "C" int G_givmem(void *memptr, int type, void *desc);

int
G_argmem (long *total, long *biggest)
{
    total[0]   = MemAccount::GetFreeMemory ();
    biggest[0] = MemAccount::GetBiggestHole ();
    return 0;
}

static MemAccount g_account;

int
G_getmem(long *length, int type, long *desc_memptr)
{
    desc_memptr[0] = (long)(g_account.Alloc (length[0]));
    return desc_memptr[0] ? 0 : 0x0001;
}

int
G_givmem(void *memptr, int type, void *desc)
{
    g_account.Free (memptr);
    return 0;
}
