/*
 *	hwdm.h
 *
 *	General definitions about HWDIS and
 *	Display Manager for SMA_SMAKY.
 *
 *	(C)	1994 Erik BRUCHEZ
 */

#ifndef _HWDM_H_
#define _HWDM_H_

#include "system.h"

struct HWMonInfo
{
	Card32	check;			// 0x494d4f4e
	Card16	phys_dx_mm;
	Card16	phys_dy_mm;
	Card32	options;		// bit 0 : support DPMS standby ; bit 1 : support DPMS suspend
							// bit 2 : support DPMS off ; bit 3 : support economical mode
							// bit 8 : screen background is not white
							// bit 9 : screen has a PowerManager (EIZO)
	Card16	num_rec;		// total number of records
	Card16	glob_size;		// total size with header
	char	dm_name[16];	// associated DM name
	char	file_name[32];	// info file name
	Card16	gamma_len;		// gamma table len
	char	mon_name[32];	// monitor name
	Card8	res[30];		// reserve
};
/*
bDMPShutDown	= 4			; coupe le courant
bDMPBlank	= 5			; coupe le signal video (mais pas les synchros H-V)
*/
struct HWDynInfo
{
	Card32	size_depth_1;
	Card32	size_depth_2;
	Card32	size_depth_4;
	Card32	size_depth_8;
	Card32	size_depth_15;
	Card32	size_depth_16;
	Card32	size_depth_24;
	Card32	size_depth_32;
	Card8	clut_chg;
	Card8	reserve[31];
};

struct HWDisRec
{
	Card32		channel;
	void		*dmheader;
	HWMonInfo	*mon;
	volatile	HWDynInfo	*dyn;
};

struct HWMRInternal
{
	Card16	size;			// total size with the header
	Card8	res1[2];		// reserve
	char	name[32];		// little description
	Card32	hfreq;			// h freq [Hz]
	Card32	vfreq;			// v freq [mHz]
	Card16	dx;				// width in pixels
	Card16	dy;				// height in pixels
	Card16	byte_width;		// width in bytes
	Card16	depth;			// depth in bpp
	Card32	colors;			// color number (or 0 if 2 << 32)
	Card8	redshift;		// [red] shift left into pixel
	Card8	redwidth;		// [red] sample width
	Card8	grnshift;		// [green] shift left into pixel
	Card8	grnwidth;		// [green] sample width
	Card8	blushift;		// [blue] shift left into pixel
	Card8	bluwidth;		// [blue] sample width
	Card8	bitmoto;		// TRUE if bits in motorola format
	Card8	res2;
};


#endif /* _HWDM_H_ */

