/*
 *	iconsbar.cxx
 *
 *	User icons bar manager for SMA_SMAKY
 *
 *	(C)	1995 Erik BRUCHEZ
 *
 */

#include "iconsbar.h"
#include "usericons.h"

/****************************************************************/

/*
 *	Static members
 */

Card8		IconsBar::max_icons_num = 0;
Card8		IconsBar::sizes_num = 0;
Card8		*IconsBar::sizes_list = NULL;
Card8		IconsBar::icons_space = 0;

IconInfo	*IconsBar::infos = NULL;

/****************************************************************/

/*
 *	Local data structure
 */

struct IconInfo
{
	Bool		is_free;
	Bool		is_visible;
	Card8		width;			//	in simple icons
	void		**data;			//	one data description per size
	
};

/****************************************************************/

IconsBar::IconsBar (Gra *gra)
{
	this->gra = gra;
	
	Pos p = { 0, 0 };
	
	this->pos = p;
	this->size = 0;
	
}


IconsBar::~IconsBar ()
{
	/*
	 *	Not implemented yet...
	 */
}

/****************************************************************/

void
IconsBar::SetIconsSizes (Card8 number, const Card8 *list)
{
	if (number) {
		IconsBar::sizes_num = number;
		IconsBar::sizes_list = new Card8[number];
		for (int i = 0; i < number; i++) IconsBar::sizes_list[i] = list[i];
	}
}


void
IconsBar::SetMaxIconsNum (Card8 num)
{
	if (num) {
		IconsBar::max_icons_num = num;
		
		IconsBar::infos = new IconInfo[num];
		
		IconInfo info;
		
		info.is_free = TRUE;
		info.is_visible = FALSE;
		info.width = 0;
		
		for ( int i = 0; i < num; i++) {
			IconsBar::infos[i] = info;
			IconsBar::infos[i].data = (void **)(new Card32[IconsBar::sizes_num]);// static...
			void **data = IconsBar::infos[i].data;
			for (int j = 0; j < IconsBar::sizes_num; j++) data[j] = NULL;
		}
	}
}


void
IconsBar::SetSpaceBetweenIcons (Card8 space)
{
	IconsBar::icons_space = space;
}

/****************************************************************/

/*
 *	Open an icon. A location in the row is reserved for the icon.
 *	The width is in "simple icon" units. It can't be greater
 *	than the maximal number of icons. If the allocation succeeded,
 *	a valid icon identifier is returned (zero in case of failure).
 */

Card32
IconsBar::Open (Card8 width)
{
	if ( (width) && (width <= IconsBar::max_icons_num) ) {
		for (int i = 0; i < (IconsBar::max_icons_num - width + 1); i++) {
			if (IconsBar::infos[i].is_free) {
				
				//	One location free...
				
				if (width > 1) {
					
					//	Look for the rest...
					
					Bool ok = TRUE;
					
					for (int j = 1; j < width; j++) {
						if (!(IconsBar::infos[i + j].is_free)) {
							ok = FALSE;
							break;
						}
					}
					
					if (ok == FALSE) continue;
				}
				
				//	Found
				
				for (int j = 0; j < width; j++) {
					IconsBar::infos[i + j].is_free = FALSE;
					IconsBar::infos[i + j].is_visible = FALSE;
					IconsBar::infos[i + j].width = 0;
					
					for (int k = 0; k < IconsBar::sizes_num; k++)
						IconsBar::infos[i + j].data[k] = NULL;
				}
				
				IconsBar::infos[i].width = width;
				
				return i + 1;
			}
		}
	}
	
	//	Allocation failed
	
	return 0;
}


Bool
IconsBar::IdValid (Card32 id)
{
	return ( (id)
		  && (id <= IconsBar::max_icons_num)
		  && !(IconsBar::infos[id - 1].is_free)
		  && (IconsBar::infos[id - 1].width) );
}


/*
 *	Close an icon. If the identifier is valid, deallocate the
 *	space occupated by the icon and free the icon data.
 */

void
IconsBar::Close (Card32 id)
{
	if (IconsBar::IdValid (id)) {
		id--;
		
		IconInfo *info = &IconsBar::infos[id];
		
		//	Delete data
		
		for (int i = 0; i < IconsBar::sizes_num; i++) {
			if (info->data[i]) {
				delete info->data[i];
				info->data[i] = NULL;
			}
		}
		
		//	Deallocate
		
		for (i = 0; i < info->width; i++)
			IconsBar::infos[id + i].is_free = TRUE;
	}
}


void
IconsBar::GetIconsSizes (Card8 buffer_size, Card8 *buffer)
{
	if (buffer_size && buffer && IconsBar::sizes_num && IconsBar::sizes_list)
		for (int i = 0; (i < buffer_size) && (i < IconsBar::sizes_num); i++)
			buffer[i] = IconsBar::sizes_list[i];
}


/*
 *	Set icon data. If the identifier is valid, set the icon data for
 *	the given size number. The data is copied. If icon is NULL, the
 *	data for the given size is disabled. The real size of the icon
 *	(found in the icon data) must be adequate.
 */

void
IconsBar::SetIcon (Card32 id, Card8 size_num, const void *icon)
{
	if (IconsBar::IdValid (id)) {
		id--;
		
		if (size_num < IconsBar::sizes_num) {
			
			//	Valid size
			
			IconInfo *info = &IconsBar::infos[id];
			
			//	Delete old data
			
			if (info->data[size_num]) {
				delete info->data[size_num];
				info->data[size_num] = NULL;
			}
			
			if (icon) {
				
				//	We must copy the data
				
				const Card8 *ic = (const Card8 *)(icon);
				Card32 size = (ic[0] + 7) / 8 * ic[1];
				
				if (size) {
					Card32 s = size + 2;
					info->data[size_num] = new char[s];
					if (info->data[size_num]) {
						Card8 *dst = (Card8 *)(info->data[size_num]);
						while (s--) *dst++ = *ic++;
					}
				}
			}
		}
	}
}


void
IconsBar::Hide (Card32 id)
{
	if (IconsBar::IdValid (id)) {
		id--;
		
		IconsBar::infos[id].is_visible = FALSE;
	}
}


void
IconsBar::Show (Card32 id)
{
	if (IconsBar::IdValid (id)) {
		id--;
		
		IconsBar::infos[id].is_visible = TRUE;
	}
}

/****************************************************************/

void
IconsBar::SelectSize (Card8 size_num)
{
	if (size_num < IconsBar::sizes_num)
		this->size = size_num;
}


void
IconsBar::SetFirstIconPos (Pos pos)
{
	this->pos = pos;
}


void
IconsBar::Draw ()
{
	
}


void
IconsBar::DrawIcon (Card32 id)
{
	if (IconsBar::IdValid (id)) {
		id--;
		
		Pos pos = this->pos;
		Card8 size = IconsBar::sizes_list[this->size];
		
		pos.x += (IconsBar::icons_space + size) * id;
		/*
		if ()
		
		this->gra->Icon (pos, );
		*/
	}
}

/****************************************************************/

