/*
 *	iconsman.h
 *
 *	User icons manager for SMA_SMAKY
 *
 *	(C)	1995 Erik BRUCHEZ
 *
 */

#ifndef _ICONS_MAN_H_
#define _ICONS_MAN_H_

#include "system.h"
#include "gra.h"

struct ServiceRequest;

class IconsMan {

private:
	Gra		*gra;						// drawing interface
	Pos		pos;						// icon row position
	Card8	size;						// current icons size
	
	static Card8		max_icons_num;	// max. number of visible icons
	
	static Card8		sizes_num;		// number of different icons sizes
	static Card8		*sizes_list;	// list of these sizes
	
	static Card8		icons_space;	// space between the icons (in pixels)
	
	struct IconInfo;
	
	static IconInfo		*infos;			// icons descriptions
	
	static Bool IdValid (Card32 id);
	
public:
	IconsMan (Gra *gra);
	~ IconsMan ();
	
	//	These methods MUST be called EXACTLY ONCE before using the services
	//	(and in the listed order !)
	
	static void SetIconsSizes (Card8 number, const Card8 *list);
	static void SetMaxIconsNum (Card8 num);
	static void SetSpaceBetweenIcons (Card8 space);
	
	//	User point of view services

private:
	
	static Card32 Open (Card8 width);
	static void Close (Card32 id);
	
	static Card8 GetIconsSizesNum () { return IconsMan::sizes_num; }
	static void GetIconsSizes (Card8 buffer_size, Card8 *buffer);
	
	static void SetIcon (Card32 id, Card8 size_num, const void *icon);
	static void Hide (Card32 id);
	static void Show (Card32 id);

public:
	
	static void *ManageRequest (ServiceRequest *request);
	
	//	Menu bar point of view services
	
	void SelectSize (Card8 size_num);
	void SetFirstIconPos (Pos pos);
	void Draw ();
	void DrawIcon (Card32 id);
};

#endif /* _ICONS_MAN_H_ */

